/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.wizards;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.ContextLabelProvider;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingModel;
import com.sap.ide.webdynpro.template.wizards.ContextModel;
import com.sap.ide.webdynpro.template.wizards.ITemplateWizardPage;
import com.sap.ide.webdynpro.template.wizards.UIElementInfoProvider;
import com.sap.ide.webdynpro.template.wizards.WizardPageBase;
import com.sap.ide.webdynpro.template.wizards.generation.data.IContextAttributeModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class ContextSelectPage
extends WizardPageBase {
    private DevelopmentObject devObject;
    private ContextModel contextModel;
    private TreeViewer treeViewer;
    private CheckboxTreeViewer checkBoxTreeViewer;
    private ContextElement selectedElement;
    private ContextLabelProvider labelProvider;

    public ContextSelectPage(String pageName, String description, DevelopmentObject devObject, ContextModel model) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(description);
        this.devObject = devObject;
        this.contextModel = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.labelProvider = new ContextLabelProvider(((View)this.devObject.getMDO()).getViewController().getOutgoingControllerUsages(), false);
        this.checkBoxTreeViewer = new CheckboxTreeViewer(composite);
        this.checkBoxTreeViewer.setContentProvider((IContentProvider)new ContextContentProvider());
        this.checkBoxTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.checkBoxTreeViewer.setInput((Object)new ContextContentProvider.ContextRoot((ContextElement)((View)this.devObject.getMDO()).getViewController().getContext()));
        this.checkBoxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() != null) {
                    ContextSelectPage.this.selectedElement = (ContextElement)event.getElement();
                }
                ContextSelectPage.this.checkBoxTreeViewer.setSelection((ISelection)new StructuredSelection((Object)ContextSelectPage.this.selectedElement));
                if (ContextSelectPage.this.checkBoxTreeViewer.getCheckedElements() != null && ContextSelectPage.this.checkBoxTreeViewer.getCheckedElements().length > 0) {
                    ContextSelectPage.this.setPageComplete(true);
                } else {
                    ContextSelectPage.this.setPageComplete(false);
                }
            }
        });
        this.checkBoxTreeViewer.expandAll();
        this.checkBoxTreeViewer.refresh();
        this.setPageComplete(false);
        this.setControl((Control)composite);
        this.fireWizardPageListener();
        this.disableRoot();
    }

    public IWizardPage getNextPage() {
        if (this.getWizard() != null) {
            if (this.contextModel.isModelEmpty()) {
                this.contextModel.setModel(this.getOutput());
            }
            if (this.getWizard().getNextPage((IWizardPage)this) instanceof ITemplateWizardPage) {
                ((ITemplateWizardPage)this.getWizard().getNextPage((IWizardPage)this)).initializeBeforeDisplay();
            }
            return this.getWizard().getNextPage((IWizardPage)this);
        }
        return null;
    }

    public void setVisible(boolean visible) {
        Object rootElement;
        if (visible && (rootElement = this.getRootElement()) != null) {
            this.checkBoxTreeViewer.setSelection((ISelection)new StructuredSelection(rootElement), true);
        }
        super.setVisible(visible);
    }

    public void initializeBeforeNext() {
    }

    public void initializeBeforeDisplay() {
    }

    private AttributeBindingModel[] getOutput() {
        Object[] objects = this.checkBoxTreeViewer.getCheckedElements();
        ArrayList<AttributeBindingModel> list = new ArrayList<AttributeBindingModel>();
        ArrayList<ContextAttribute> attribList = new ArrayList<ContextAttribute>();
        ContextAttribute[] ctxAttribs = null;
        AttributeBindingModel[] modelElements = null;
        AttributeBindingModel model = null;
        String name = null;
        if (objects != null) {
            UIElementInfoProvider uiInfoProvider = this.contextModel.getUIInfoProvider();
            attribList.add(null);
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof ContextAttribute) {
                    model = new AttributeBindingModel(uiInfoProvider, (ContextAttribute)objects[i]);
                    name = this.contextModel.getValidUIElementName(model.getLabel(), model);
                    if (name != null) {
                        model.setInputLabel(name);
                    }
                    list.add(model);
                    attribList.add((ContextAttribute)objects[i]);
                }
                ++i;
            }
            modelElements = new AttributeBindingModel[list.size()];
            modelElements = list.toArray(modelElements);
            ctxAttribs = new ContextAttribute[attribList.size()];
            ctxAttribs = attribList.toArray(ctxAttribs);
            if (this.contextModel.getUIInfoProvider().getSelectedAttributes() == null) {
                this.contextModel.setContextAttributesForBinding(ctxAttribs);
            }
        }
        return modelElements;
    }

    public void setCheckStateListener(ICheckStateListener listener) {
        if (listener != null) {
            this.checkBoxTreeViewer.addCheckStateListener(listener);
        }
    }

    public ContextElement getSelectedItem() {
        return this.selectedElement;
    }

    public ContextAttribute[] getSelectedContextAttributes() {
        Object[] objects = this.checkBoxTreeViewer.getCheckedElements();
        ArrayList<ContextAttribute> attribList = new ArrayList<ContextAttribute>();
        ContextAttribute[] ctxAttribs = null;
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof ContextAttribute) {
                    attribList.add((ContextAttribute)objects[i]);
                }
                ++i;
            }
            ctxAttribs = new ContextAttribute[attribList.size()];
            ctxAttribs = attribList.toArray(ctxAttribs);
        }
        return ctxAttribs;
    }

    public void setSelection(ContextElement element, boolean state) {
        if (element != null) {
            this.checkBoxTreeViewer.setChecked((Object)element, state);
            this.checkBoxTreeViewer.refresh();
        }
    }

    public void setGraySelection(ContextElement element, boolean state) {
        if (element != null) {
            this.checkBoxTreeViewer.setGrayChecked((Object)element, state);
            this.checkBoxTreeViewer.refresh();
        }
    }

    public boolean getChecked(Object element) {
        return this.checkBoxTreeViewer.getChecked(element);
    }

    public boolean getGrayed(Object element) {
        return this.checkBoxTreeViewer.getGrayed(element);
    }

    private void disableRoot() {
        TreeItem[] items = this.checkBoxTreeViewer.getTree().getItems();
        if (items.length != 1) {
            return;
        }
        if (items[0].getData() instanceof ContextElement) {
            this.setGraySelection((ContextElement)items[0].getData(), true);
        }
    }

    public void clearAllSelection() {
        Object[] checkedElements = this.checkBoxTreeViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            this.checkBoxTreeViewer.setChecked(checkedElements[i], false);
            ++i;
        }
        Object[] greyCheckedElements = this.checkBoxTreeViewer.getGrayedElements();
        int i2 = 0;
        while (i2 < greyCheckedElements.length) {
            this.checkBoxTreeViewer.setGrayChecked(greyCheckedElements[i2], false);
            ++i2;
        }
        this.disableRoot();
    }

    public void setDefaultEditor(ContextElement element, String editor) {
        IContextAttributeModel[] attributeModels = this.contextModel.getContextAttributeModel();
        int i = 0;
        while (i < attributeModels.length) {
            AttributeBindingModel bindingModel = (AttributeBindingModel)attributeModels[i];
            if (element.equals(bindingModel.getContextAttribute())) {
                bindingModel.setInputFieldType(editor);
                break;
            }
            ++i;
        }
    }

    public void setDefaultProperty(ContextElement element, String string) {
    }

    public Object[] getSelectedNodes() {
        IStructuredSelection selection = (IStructuredSelection)this.checkBoxTreeViewer.getSelection();
        Iterator iterator = selection.iterator();
        Vector<Object> selectedItems = new Vector<Object>();
        Object[] items = this.checkBoxTreeViewer.getCheckedElements();
        if (items.length <= 0) {
            return selectedItems.toArray();
        }
        int i = 0;
        while (i < items.length) {
            Object element = items[i];
            if (element instanceof ContextNode) {
                selectedItems.add(element);
            }
            ++i;
        }
        return selectedItems.toArray();
    }

    public void updateParentSelection(ContextAttribute child) {
        ContextNode parent = (ContextNode)child.getParent();
        ContextAttribute[] childAttributes = parent.getAttributes();
        int i = 0;
        while (i < childAttributes.length) {
            if (!this.checkBoxTreeViewer.getChecked((Object)childAttributes[i]) && !this.checkBoxTreeViewer.getGrayed((Object)childAttributes[i])) {
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < childAttributes.length) {
            this.checkBoxTreeViewer.setGrayed((Object)childAttributes[i2], false);
            this.checkBoxTreeViewer.setChecked((Object)childAttributes[i2], true);
            ++i2;
        }
        this.checkBoxTreeViewer.setGrayed((Object)parent, false);
        this.checkBoxTreeViewer.setChecked((Object)parent, true);
    }

    public void grayOtherAttributes(ContextElement child) {
        ContextNode parent = (ContextNode)child.getParent();
        ContextAttribute[] childAttributes = parent.getAttributes();
        int i = 0;
        while (i < childAttributes.length) {
            if (!childAttributes[i].equals(child) && this.checkBoxTreeViewer.getChecked((Object)childAttributes[i])) {
                this.checkBoxTreeViewer.setGrayed((Object)childAttributes[i], true);
            }
            ++i;
        }
    }

    public void expand(ContextElement selectedElement) {
        this.checkBoxTreeViewer.setExpandedState((Object)selectedElement, true);
    }

    public void reveal(Object element) {
        if (this.checkBoxTreeViewer != null && this.labelProvider != null && element != null) {
            StructuredSelection structuredSelection = new StructuredSelection(element);
        }
    }

    public boolean isRootNode(ContextElement element) {
        TreeItem[] items = this.checkBoxTreeViewer.getTree().getItems();
        if (items.length != 1) {
            return false;
        }
        return element.equals(items[0].getData());
    }

    public void clearParentSelection(ContextAttribute child) {
        ContextNode parent = (ContextNode)child.getParent();
        ContextAttribute[] childAttributes = parent.getAttributes();
        int i = 0;
        while (i < childAttributes.length) {
            if (this.checkBoxTreeViewer.getChecked((Object)childAttributes[i]) || this.checkBoxTreeViewer.getGrayed((Object)childAttributes[i])) {
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < childAttributes.length) {
            this.checkBoxTreeViewer.setGrayed((Object)childAttributes[i2], false);
            this.checkBoxTreeViewer.setChecked((Object)childAttributes[i2], false);
            ++i2;
        }
        this.checkBoxTreeViewer.setGrayed((Object)parent, false);
        this.checkBoxTreeViewer.setChecked((Object)parent, false);
    }

    public boolean selectionExists() {
        Object rootElement = this.getRootElement();
        if (null == rootElement) {
            return true;
        }
        Object[] checkedElements = this.checkBoxTreeViewer.getCheckedElements();
        boolean found = false;
        int i = 0;
        while (i < checkedElements.length) {
            if (!checkedElements[i].equals(rootElement)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            return true;
        }
        Object[] grayedElements = this.checkBoxTreeViewer.getGrayedElements();
        int i2 = 0;
        while (i2 < grayedElements.length) {
            if (!grayedElements[i2].equals(rootElement)) {
                found = true;
                break;
            }
            ++i2;
        }
        return found;
    }

    public Object getRootElement() {
        TreeItem[] items = this.checkBoxTreeViewer.getTree().getItems();
        if (items.length > 0) {
            return items[0].getData();
        }
        return null;
    }

    public void setPageComplete(boolean complete) {
        this.contextModel.setIsComplete(complete);
        super.setPageComplete(complete);
    }
}

