/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.wizards;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.DeclarationTypeEnum;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingModel;
import com.sap.ide.webdynpro.template.wizards.TextPool;
import com.sap.ide.webdynpro.template.wizards.UIElementInfoProvider;
import com.sap.ide.webdynpro.template.wizards.generation.data.IContextAttributeModel;
import com.sap.ide.webdynpro.template.wizards.generation.data.IContextModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Vector;

public class ContextModel
implements IContextModel {
    public static int TMP_FORM_VIEW = 0;
    public static int TMP_TABLE_VIEW = 1;
    private DevelopmentObject developmentObject;
    private ArrayList modelElements;
    private String[] attribsNames;
    private UIElementInfoProvider uiInfoProvider;
    private UIElementContainer mRootUIElementContainer;
    private int templateInitializer = -1;
    private boolean isComplete;

    public ContextModel(DevelopmentObject devObject) {
        this.modelElements = new ArrayList();
        this.developmentObject = devObject;
        this.uiInfoProvider = devObject != null ? new UIElementInfoProvider((DevelopmentObject)((View)devObject.getMDO()).getViewController()) : new UIElementInfoProvider();
        this.attribsNames = new String[1];
        this.attribsNames[0] = "None";
        this.setRootUIElementContainer(devObject);
    }

    private void setRootUIElementContainer(DevelopmentObject devObject) {
        if (devObject instanceof View) {
            this.mRootUIElementContainer = ((View)devObject).getRootUIElementContainer();
        } else if (devObject.getMDO() instanceof View) {
            View view = (View)devObject.getMDO();
            this.mRootUIElementContainer = view.getRootUIElementContainer();
        }
    }

    public ContextModel(UIElementInfoProvider provider) {
        this.modelElements = new ArrayList();
        this.uiInfoProvider = provider;
        this.attribsNames = new String[1];
        this.attribsNames[0] = "None";
    }

    public ContextModel(AttributeBindingModel[] model, UIElementInfoProvider provider) {
        this.uiInfoProvider = provider;
        this.resetModel(model);
    }

    public void setTemplateType(int type) {
        this.templateInitializer = type;
        this.uiInfoProvider.setTemplateType(this.templateInitializer);
    }

    public void setUIInfoProvider(UIElementInfoProvider provider) {
        this.uiInfoProvider = provider;
    }

    public UIElementInfoProvider getUIInfoProvider() {
        return this.uiInfoProvider;
    }

    public DevelopmentObject getDevelopmentOject() {
        return this.developmentObject;
    }

    public void setDevelopmentObject(DevelopmentObject devObject) {
        this.developmentObject = devObject;
    }

    private void resetModel(AttributeBindingModel[] model) {
        this.modelElements = new ArrayList();
        if (model != null) {
            int i = 0;
            while (i < model.length) {
                this.modelElements.add(model[i]);
                ++i;
            }
        }
    }

    private boolean checkPresence(ArrayList nameList, String name) {
        if (nameList != null && name != null) {
            String temp = null;
            int i = 0;
            while (i < nameList.size()) {
                temp = (String)nameList.get(i);
                if (temp != null && temp.equals(name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setModel(AttributeBindingModel[] model) {
        this.resetModel(model);
    }

    public IContextAttributeModel[] getContextAttributeModel() {
        AttributeBindingModel[] modelArray = null;
        if (this.modelElements != null) {
            modelArray = new AttributeBindingModel[this.modelElements.size()];
            modelArray = this.modelElements.toArray(modelArray);
        }
        return modelArray;
    }

    public IContextAttributeModel[] getVisibleContextAttributeModel() {
        AttributeBindingModel[] modelArray = null;
        Vector<AttributeBindingModel> visibleElements = new Vector<AttributeBindingModel>();
        int i = 0;
        while (i < this.modelElements.size()) {
            AttributeBindingModel bindingModel = (AttributeBindingModel)this.modelElements.get(i);
            if (bindingModel.isSelected()) {
                visibleElements.add(bindingModel);
            }
            ++i;
        }
        if (visibleElements != null) {
            modelArray = new AttributeBindingModel[visibleElements.size()];
            modelArray = visibleElements.toArray(modelArray);
        }
        return modelArray;
    }

    public void addModelElement(IContextAttributeModel model) {
        if (this.modelElements == null) {
            this.modelElements = new ArrayList();
        }
        this.modelElements.add(model);
    }

    public void deleteModelElement(IContextAttributeModel model) {
        if (this.modelElements != null) {
            ((AbstractCollection)this.modelElements).remove(model);
        }
    }

    public void moveUp(int index) {
        Object model;
        if (this.modelElements != null && index > 0 && (model = this.modelElements.get(index)) != null) {
            Object above = this.modelElements.get(index - 1);
            this.modelElements.set(index - 1, model);
            this.modelElements.set(index, above);
        }
    }

    public void moveDown(int index) {
        Object model;
        if (this.modelElements != null && index != -1 && index < this.modelElements.size() - 1 && (model = this.modelElements.get(index)) != null) {
            Object below = this.modelElements.get(index + 1);
            this.modelElements.set(index + 1, model);
            this.modelElements.set(index, below);
        }
    }

    public String[] getAllAttributeNames() {
        return this.attribsNames;
    }

    public void resetAttributeNames() {
        if (this.getUIInfoProvider() != null && this.getUIInfoProvider().getSelectedAttributes() != null) {
            ContextAttribute[] attribs = this.getUIInfoProvider().getSelectedAttributes();
            this.attribsNames = new String[attribs.length];
            int i = 0;
            while (i < attribs.length) {
                this.attribsNames[i] = attribs[i] == null ? "None" : this.getFullPathName(attribs[i]);
                ++i;
            }
        } else {
            this.attribsNames = new String[1];
            this.attribsNames[0] = "None";
        }
    }

    public void resetContextAttributes() {
        ArrayList<ContextAttribute> attribList = new ArrayList<ContextAttribute>();
        attribList.add(null);
        if (this.modelElements != null) {
            IContextAttributeModel model = null;
            int i = 0;
            while (i < this.modelElements.size()) {
                model = (IContextAttributeModel)this.modelElements.get(i);
                if (model.getContextAttribute() != null) {
                    attribList.add(model.getContextAttribute());
                }
                ++i;
            }
        }
        ContextAttribute[] ctxAttribs = new ContextAttribute[attribList.size()];
        ctxAttribs = attribList.toArray(ctxAttribs);
        this.getUIInfoProvider().setSelectedAttributes(ctxAttribs);
    }

    public IContextAttributeModel createContextAttributeModel() {
        AttributeBindingModel attribModel = new AttributeBindingModel(this.uiInfoProvider);
        this.addModelElement(attribModel);
        return attribModel;
    }

    public IContextAttributeModel createContextAttributeModel(DevelopmentObject ctxAttrib) {
        AttributeBindingModel attribModel = null;
        attribModel = ctxAttrib != null && ctxAttrib instanceof ContextAttribute ? new AttributeBindingModel(this.uiInfoProvider, (ContextAttribute)ctxAttrib) : new AttributeBindingModel(this.uiInfoProvider);
        String name = this.getValidUIElementName(attribModel.getLabel(), attribModel);
        if (name != null) {
            attribModel.setInputLabel(name);
        }
        this.addModelElement(attribModel);
        return attribModel;
    }

    public String getValidUIElementName(String name, IContextAttributeModel modelElement) {
        int counter = 0;
        String newName = name;
        while (this.isNameAvailableForElement(newName, modelElement) != null) {
            if (!CheckServices.isValidIdentifier((String)newName)) {
                return newName;
            }
            newName = name + "_" + counter++;
        }
        return newName;
    }

    public String isNameAvailableForElement(String name, IContextAttributeModel selectedModel) {
        String[] invalidIdentifier = new String[]{name};
        if (name == null || name.equals("")) {
            return CoreTextPool.getInstance().getText(3);
        }
        if (!CheckServices.isValidIdentifier((String)name)) {
            return CoreTextPool.getInstance().getText(2);
        }
        if (null == this.mRootUIElementContainer) {
            return null;
        }
        Object[] values = new String[]{name, this.mRootUIElementContainer.getMDO().getName()};
        if (name.equalsIgnoreCase(this.mRootUIElementContainer.getName())) {
            return TextPool.getInstance().getText(1, values);
        }
        int i = 0;
        while (i < this.mRootUIElementContainer.getChildren().length) {
            if (!this.isNameAvailableForElement(name, (DevelopmentObject)this.mRootUIElementContainer.getChild(i)) && !this.mRootUIElementContainer.getChild(i).equals(this.developmentObject)) {
                return TextPool.getInstance().getText(1, values);
            }
            ++i;
        }
        if (this.nameExistsInCache(name, selectedModel)) {
            return TextPool.getInstance().getText(1, values);
        }
        return null;
    }

    private boolean nameExistsInCache(String name, IContextAttributeModel selectedModel) {
        IContextAttributeModel[] models = this.getContextAttributeModel();
        boolean found = false;
        int i = 0;
        while (i < models.length) {
            IContextAttributeModel attModel = models[i];
            if (!selectedModel.equals(attModel) && name.equals(attModel.getLabel())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isNameAvailableForElement(String name, DevelopmentObject element) {
        if (element.getName().equalsIgnoreCase(name)) {
            return false;
        }
        MetaClass lClass = element.getMetaClass();
        while (lClass != null) {
            Aggregation[] lAggregations = lClass.getAggregations();
            int i = 0;
            while (i < lAggregations.length) {
                Aggregation lAggregation = lAggregations[i];
                if (lAggregation.getDeclarationType() != DeclarationTypeEnum.ABSTRACT) {
                    Class<?> lJavaClass = element.getClass();
                    Class<?>[] lInterfaces = lJavaClass.getInterfaces();
                    int k = 0;
                    while (k < lInterfaces.length) {
                        Class[] lArray = new Class[]{};
                        Method lMethod = null;
                        try {
                            lMethod = lInterfaces[k].getMethod("get" + lAggregation.getName(), lArray);
                        }
                        catch (NoSuchMethodException e) {
                            Plugin.internalError(this.getClass(), (String)"isNameAvailableForElement(String name, DevelopmentObject element)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                        }
                        Object ret = null;
                        if (lMethod != null) {
                            Object[] lArgs = new Object[]{};
                            DevelopmentObject[] lObjects = null;
                            DevelopmentObject lObject = null;
                            try {
                                ret = lMethod.invoke((Object)element, lArgs);
                            }
                            catch (InvocationTargetException e) {
                                Plugin.internalError(this.getClass(), (String)"isNameAvailableForElement(String name, DevelopmentObject element)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                            }
                            catch (IllegalAccessException e) {
                                Plugin.internalError(this.getClass(), (String)"isNameAvailableForElement(String name, DevelopmentObject element)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                            }
                            if (ret instanceof DevelopmentObject[]) {
                                lObjects = (DevelopmentObject[])ret;
                                int j = 0;
                                while (j < lObjects.length) {
                                    if (lObjects[j].getName().equals(name)) {
                                        return false;
                                    }
                                    if (!this.isNameAvailableForElement(name, lObjects[j])) {
                                        return false;
                                    }
                                    ++j;
                                }
                            } else if (ret instanceof DevelopmentObject) {
                                lObject = (DevelopmentObject)ret;
                                if (lObject.getName().equalsIgnoreCase(name)) {
                                    return false;
                                }
                                if (!this.isNameAvailableForElement(name, lObject)) {
                                    return false;
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            lClass = lClass.getSuperClass();
        }
        return true;
    }

    public boolean isModelEmpty() {
        return this.modelElements == null || this.modelElements.isEmpty();
    }

    public void setContextAttributesForBinding(ContextAttribute[] attributes) {
        if (attributes != null) {
            ArrayList<ContextAttribute> attribList = new ArrayList<ContextAttribute>();
            ArrayList<String> nameList = new ArrayList<String>();
            nameList.add("None");
            attribList.add(null);
            int i = 0;
            while (i < attributes.length) {
                if (attributes[i] != null && !this.checkPresence(nameList, ContextService.getAbsoluteContextElementPath((ContextElement)attributes[i]))) {
                    nameList.add(this.getFullPathName(attributes[i]));
                    attribList.add(attributes[i]);
                }
                ++i;
            }
            this.attribsNames = new String[nameList.size()];
            this.attribsNames = nameList.toArray(this.attribsNames);
            attributes = new ContextAttribute[attribList.size()];
            attributes = attribList.toArray(attributes);
            this.getUIInfoProvider().setSelectedAttributes(attributes);
            this.updateValuesMap();
        }
    }

    private void updateValuesMap() {
        if (this.modelElements != null) {
            ContextAttribute attribute = null;
            AttributeBindingModel model = null;
            int i = 0;
            while (i < this.modelElements.size()) {
                model = (AttributeBindingModel)this.modelElements.get(i);
                if (model != null && (attribute = model.getContextAttribute()) != null) {
                    model.setContextAttribute(attribute);
                }
                ++i;
            }
        }
    }

    private String getFullPathName(ContextAttribute contextAttrib) {
        String fullName = "";
        if (contextAttrib != null) {
            fullName = contextAttrib.getName() + "(" + ContextService.getAbsoluteContextElementPath((ContextElement)contextAttrib) + ")";
        }
        return fullName;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setIsComplete(boolean status) {
        this.isComplete = status;
    }
}

