/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.wizards;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.enum.BindingTypeEnum;
import com.sap.ide.metamodel.webdynpro.framework.uielib.AbstractViewElementPropertyDef;
import com.sap.ide.metamodel.webdynpro.framework.uielib.TranslatableViewElementPropertyDef;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementPropertyDef;
import com.sap.ide.webdynpro.checklayer.view.ViewElementChecker;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingCellModifier;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingContentProvider;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingLabelProvider;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingModel;
import com.sap.ide.webdynpro.template.wizards.ContextModel;
import com.sap.ide.webdynpro.template.wizards.TextPool;
import com.sap.ide.webdynpro.template.wizards.WizardPageBase;
import com.sap.ide.webdynpro.template.wizards.generation.data.IContextAttributeModel;
import com.sap.ide.webdynpro.template.wizards.plugin.TemplateWizardsPlugin;
import com.sap.ide.webdynpro.template.wizards.tablebinding.ReflectionHelper;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AttributeBindingPage
extends WizardPageBase {
    private Composite parentComposite;
    private IGridLayoutPane m_glp;
    private Text tLabel;
    private Combo comboType;
    private TableViewer tableViewer;
    private Table table;
    private Image upImage;
    private Image downImage;
    private DevelopmentObject devObject;
    private ContextModel contextModel;
    private ContextNode mContext;
    private ContextNode contextElement;

    public AttributeBindingPage(String pageName, String description, DevelopmentObject devObject, ContextModel model) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(description);
        this.devObject = devObject;
        this.contextModel = model;
    }

    public void createControl(Composite parent) {
        this.m_glp = PaneFactory.createGridLayoutPane((Composite)parent, (int)0);
        this.m_glp.getComposite().setLayout((Layout)new GridLayout(2, false));
        IGridLayoutPane detailsPane = this.m_glp.addGridLayoutPane(0);
        detailsPane.getComposite().setLayout((Layout)new GridLayout(1, true));
        detailsPane.getComposite().setLayoutData((Object)new GridData(1808));
        this.tableViewer = detailsPane.addTableViewer(false);
        this.table = this.tableViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.heightHint = 153;
        gridData.widthHint = 400;
        this.table.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new AttributeBindingContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AttributeBindingLabelProvider(this.tableViewer));
        this.createColumns();
        this.setUpCellEditors();
        this.tableViewer.setCellModifier((ICellModifier)new AttributeBindingCellModifier(this.tableViewer, this.table, this));
        this.tableViewer.setColumnProperties(AttributeBindingModel.getTableHeaders());
        this.tableViewer.setInput((Object)this.contextModel);
        IGridLayoutPane buttonsPane = this.m_glp.addGridLayoutPane(0);
        buttonsPane.getComposite().setLayout((Layout)new GridLayout(1, true));
        buttonsPane.getComposite().setLayoutData((Object)new GridData(1808));
        this.upImage = TemplateWizardsPlugin.getDefault().getImage(TemplateWizardsPlugin.IMG_UP_ARROW);
        Button bMoveUp = buttonsPane.addPushButton(this.upImage);
        bMoveUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = AttributeBindingPage.this.tableViewer.getTable().getSelectionIndex();
                AttributeBindingPage.this.contextModel.moveUp(index);
                AttributeBindingPage.this.tableViewer.setInput((Object)AttributeBindingPage.this.contextModel);
                AttributeBindingPage.this.tableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.downImage = TemplateWizardsPlugin.getDefault().getImage(TemplateWizardsPlugin.IMG_DOWN_ARROW);
        Button bMoveDown = buttonsPane.addPushButton(this.downImage);
        bMoveDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = AttributeBindingPage.this.tableViewer.getTable().getSelectionIndex();
                AttributeBindingPage.this.contextModel.moveDown(index);
                AttributeBindingPage.this.tableViewer.setInput((Object)AttributeBindingPage.this.contextModel);
                AttributeBindingPage.this.tableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof AttributeBindingModel) {
                    AttributeBindingModel attrModel = (AttributeBindingModel)element;
                    if (!attrModel.isNew()) {
                        if (!attrModel.isSelected()) {
                            attrModel.setContextAttribute(null);
                            attrModel.setIsSelected(true);
                        }
                    } else {
                        return attrModel.isSelected();
                    }
                }
                return true;
            }
        });
        this.setControl((Control)this.m_glp.getComposite());
    }

    protected void createColumns() {
        this.table.setHeaderVisible(true);
        this.table.removeAll();
        TableColumn statusColumn = new TableColumn(this.table, 0, 0);
        statusColumn.setResizable(true);
        statusColumn.setText(AttributeBindingModel.TMP_VIEW_NAME);
        statusColumn.setWidth(75);
        TableColumn attribColumn = new TableColumn(this.table, 0, 1);
        attribColumn.setResizable(true);
        attribColumn.setText(AttributeBindingModel.TMP_VIEW_ATTRIB);
        attribColumn.setWidth(175);
        TableColumn typeColumn = new TableColumn(this.table, 0, 2);
        typeColumn.setResizable(true);
        typeColumn.setText(AttributeBindingModel.TMP_VIEW_EDITOR);
        typeColumn.setWidth(75);
        TableColumn bindPropColumn = new TableColumn(this.table, 0, 3);
        bindPropColumn.setResizable(true);
        bindPropColumn.setText(AttributeBindingModel.TMP_VIEW_BIND_PROP);
        bindPropColumn.setWidth(95);
    }

    private void setUpCellEditors() {
        final CellEditor[] editors = new CellEditor[4];
        editors[0] = new TextCellEditor((Composite)this.table);
        editors[0].addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                String name = (String)editors[0].getValue();
                TableItem[] selectedItems = AttributeBindingPage.this.tableViewer.getTable().getSelection();
                AttributeBindingModel selectedModel = (AttributeBindingModel)selectedItems[0].getData();
                String message = AttributeBindingPage.this.contextModel.isNameAvailableForElement(name, selectedModel);
                if (message != null && selectedModel != null) {
                    editors[0].setValue((Object)selectedModel.getLabel());
                }
            }

            public void cancelEditor() {
                String errMsg = AttributeBindingPage.this.checkForErrors();
                AttributeBindingPage.this.setErrorMessage(errMsg);
                AttributeBindingPage.this.setPageComplete(errMsg == null);
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                String name = (String)editors[0].getValue();
                TableItem[] selectedItems = AttributeBindingPage.this.tableViewer.getTable().getSelection();
                AttributeBindingModel selectedModel = (AttributeBindingModel)selectedItems[0].getData();
                String message = AttributeBindingPage.this.contextModel.isNameAvailableForElement(name, selectedModel);
                if (message != null) {
                    message = AttributeBindingPage.this.isNameValid(name, selectedModel);
                }
                if (null == message || message.equals("")) {
                    AttributeBindingPage.this.setPageComplete(true);
                } else {
                    AttributeBindingPage.this.setPageComplete(false);
                }
                AttributeBindingPage.this.setErrorMessage(message);
            }
        });
        editors[1] = new ComboBoxCellEditor((Composite)this.table, this.contextModel.getAllAttributeNames(), 8);
        editors[2] = new ComboBoxCellEditor((Composite)this.table, this.contextModel.getUIInfoProvider().getInputFieldTypes(), 8);
        editors[3] = new ComboBoxCellEditor((Composite)this.table, new String[0], 8);
        this.tableViewer.setCellEditors(editors);
    }

    public void initializeBeforeNext() {
    }

    public void initializeBeforeDisplay() {
        this.tableViewer.setInput((Object)this.contextModel);
        CellEditor[] editors = this.tableViewer.getCellEditors();
        if (editors[1] instanceof ComboBoxCellEditor) {
            ComboBoxCellEditor comboBox = (ComboBoxCellEditor)editors[1];
            comboBox.setItems(this.contextModel.getAllAttributeNames());
            editors[1] = comboBox;
            this.tableViewer.setCellEditors(editors);
        }
        this.tableViewer.refresh();
        this.fireWizardPageListener();
        this.tableViewer.refresh();
        String errMsg = this.checkForErrors();
        this.setErrorMessage(errMsg);
        this.setPageComplete(errMsg == null);
    }

    public ContextModel getModel() {
        return this.contextModel;
    }

    public void setCellModifier(ICellModifier modifier) {
        if (modifier != null) {
            this.tableViewer.setCellModifier(modifier);
        }
    }

    public void setLabelProvider(ILabelProvider provider) {
        if (provider != null) {
            this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        }
    }

    public void setContentProvider(IContentProvider provider) {
        if (provider != null) {
            this.tableViewer.setContentProvider(provider);
        }
    }

    public void setDefaultEditor(UIElement element, String editor) {
        IContextAttributeModel[] attributeModels = this.contextModel.getContextAttributeModel();
        int i = 0;
        while (i < attributeModels.length) {
            AttributeBindingModel bindingModel = (AttributeBindingModel)attributeModels[i];
            if (element.equals(bindingModel.getContextAttribute())) {
                bindingModel.setInputFieldType(editor);
                break;
            }
            ++i;
        }
    }

    public void setDefaultProperty(UIElement element, String string) {
    }

    public String isValid(Object name, ViewElementDefinition mObject, String bindingProperty) {
        if (name instanceof ContextElement) {
            AbstractViewElementPropertyDef definition = ReflectionHelper.findPropertyInDefinition(mObject, bindingProperty);
            if (ViewElementChecker.areUIElementPropertyAndContextElementCompatible((ContextElement)((ContextElement)name), (AbstractViewElementPropertyDef)definition)) {
                return null;
            }
            BindingTypeEnum type = null;
            String typeName = null;
            if (definition instanceof ViewElementPropertyDef) {
                ViewElementPropertyDef def = (ViewElementPropertyDef)definition;
                type = def.getBindingType();
                typeName = def.getType() != null ? def.getType().getName() : "";
            } else if (definition instanceof TranslatableViewElementPropertyDef) {
                type = BindingTypeEnum.ATTRIBUTE;
                typeName = "string";
            }
            if (type != null) {
                if (type == BindingTypeEnum.ATTRIBUTE) {
                    return TextPool.getInstance().getText(14, typeName);
                }
                if (type == BindingTypeEnum.MULTIPLENODEATTRIBUTE) {
                    return TextPool.getInstance().getText(15, typeName);
                }
                if (typeName != null) {
                    if (type == BindingTypeEnum.MULTIPLENODE) {
                        return TextPool.getInstance().getText(17);
                    }
                    if (type == BindingTypeEnum.MULTIPLENODERANGE) {
                        return TextPool.getInstance().getText(16);
                    }
                }
            }
        }
        return "";
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.devObject;
    }

    public String checkForErrors() {
        String errMsg = this.checkForNames();
        if (errMsg == null || errMsg.equals("")) {
            errMsg = this.checkForEditorTypes();
        }
        return errMsg;
    }

    private String checkForNames() {
        TableItem[] tableItems = this.table.getItems();
        if (tableItems != null) {
            AttributeBindingModel model = null;
            AttributeBindingModel tempModel = null;
            String name = null;
            Object definition = null;
            Object bindingProperty = null;
            String message = null;
            int i = 0;
            while (i < tableItems.length) {
                model = (AttributeBindingModel)tableItems[i].getData();
                name = model.getLabel();
                message = this.isNameValid(name, model);
                if (message != null && !message.equals("")) {
                    String errMsg = "Error for UIElement with label " + model.getLabel() + "\n" + message;
                    this.table.select(i);
                    return errMsg;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < tableItems.length) {
                model = (AttributeBindingModel)tableItems[i2].getData();
                name = model.getLabel();
                int j = i2 + 1;
                while (j < tableItems.length) {
                    tempModel = (AttributeBindingModel)tableItems[j].getData();
                    if (tempModel.getLabel().equals(name)) {
                        Object[] values = new String[]{name, this.devObject.getMDO().getName()};
                        this.table.select(i2);
                        return TextPool.getInstance().getText(1, values);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return null;
    }

    private String isNameValid(String name, IContextAttributeModel selectedModel) {
        String[] invalidIdentifier = new String[]{name};
        UIElementContainer mRootUIElementContainer = ((View)this.devObject.getMDO()).getRootUIElementContainer();
        if (name == null || name.equals("")) {
            return CoreTextPool.getInstance().getText(3);
        }
        if (!CheckServices.isValidIdentifier((String)name)) {
            return CoreTextPool.getInstance().getText(2);
        }
        if (null == mRootUIElementContainer) {
            return null;
        }
        Object[] values = new String[]{name, mRootUIElementContainer.getMDO().getName()};
        if (name.equalsIgnoreCase(mRootUIElementContainer.getName())) {
            return TextPool.getInstance().getText(1, values);
        }
        int i = 0;
        while (i < mRootUIElementContainer.getChildren().length) {
            if (!this.contextModel.isNameAvailableForElement(name, (DevelopmentObject)mRootUIElementContainer.getChild(i)) && !mRootUIElementContainer.getChild(i).equals(this.devObject)) {
                return TextPool.getInstance().getText(1, values);
            }
            ++i;
        }
        return null;
    }

    private String checkForEditorTypes() {
        TableItem[] tableItems = this.table.getItems();
        if (tableItems != null) {
            AttributeBindingModel model = null;
            String name = null;
            ViewElementDefinition definition = null;
            String bindingProperty = null;
            String message = null;
            int i = 0;
            while (i < tableItems.length) {
                model = (AttributeBindingModel)tableItems[i].getData();
                name = model.getEditorType();
                definition = MetamodelServices.getViewElementDefinition((String)((View)this.devObject.getMDO()).getRoot().getMetamodel().getName(), (String)name);
                bindingProperty = model.getBindingProperty();
                message = this.isValid(model.getContextAttribute(), definition, bindingProperty);
                if (message != null && !message.equals("")) {
                    String errMsg = "Error for UIElement with label " + model.getLabel() + "\n" + message;
                    this.table.select(i);
                    return errMsg;
                }
                ++i;
            }
        }
        return null;
    }

    public void setPageComplete(boolean complete) {
        this.contextModel.setIsComplete(complete);
        super.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        IContextAttributeModel[] modelElements;
        if (visible && this.contextModel != null && (modelElements = this.contextModel.getContextAttributeModel()) != null) {
            String name = null;
            AttributeBindingModel model = null;
            int i = 0;
            while (i < modelElements.length) {
                model = (AttributeBindingModel)modelElements[i];
                name = this.contextModel.getValidUIElementName(model.getLabel(), model);
                if (name != null) {
                    model.setInputLabel(name);
                }
                ++i;
            }
            this.tableViewer.refresh();
            String errMsg = this.checkForErrors();
            this.setErrorMessage(errMsg);
            this.setPageComplete(errMsg == null);
        }
        super.setVisible(visible);
    }
}

