/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.wizards;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.template.wizards.UIElementInfoProvider;
import com.sap.ide.webdynpro.template.wizards.generation.data.IContextAttributeModel;
import java.util.HashMap;
import java.util.Map;

public class AttributeBindingModel
implements IContextAttributeModel {
    private boolean mIsNew = false;
    private boolean mIsSelected = true;
    public static String TMP_VIEW_NAME = "Name";
    public static String TMP_VIEW_ATTRIB = "Attribute";
    public static String TMP_VIEW_EDITOR = "Editor";
    public static String TMP_VIEW_BIND_PROP = "Binding Property";
    public static String[] tableHeaders = new String[]{TMP_VIEW_NAME, TMP_VIEW_ATTRIB, TMP_VIEW_EDITOR, TMP_VIEW_BIND_PROP};
    private UIElementInfoProvider infoProvider;
    private ContextNode contextElement;
    private ContextAttribute contextAttrib;
    private String inputLabel;
    private String inputFieldType;
    private String bindingProperty;
    private Map valuesMap = new HashMap();

    public AttributeBindingModel(UIElementInfoProvider provider) {
        this.valuesMap.put(TMP_VIEW_NAME, null);
        this.valuesMap.put(TMP_VIEW_ATTRIB, new Integer(0));
        this.valuesMap.put(TMP_VIEW_EDITOR, new Integer(0));
        this.valuesMap.put(TMP_VIEW_BIND_PROP, new Integer(0));
        this.infoProvider = provider;
    }

    public AttributeBindingModel(UIElementInfoProvider provider, ContextAttribute attribute) {
        this(provider);
        if (attribute != null) {
            this.contextElement = attribute.getNode();
            this.setContextAttribute(attribute);
            this.setInputLabel(attribute.getName());
            this.setInputFieldType(provider.getDefaultEditorForElementType(attribute, CheckLayerHelper.getType((ContextAttribute)attribute)));
            this.setBindingProperty(provider.getDefaultPropertyForEditorType(this.inputFieldType));
        }
    }

    public static String[] getTableHeaders() {
        return tableHeaders;
    }

    public String getName() {
        if (this.contextAttrib != null) {
            return this.contextAttrib.getName();
        }
        return "";
    }

    public String getFullPathName() {
        String fullName = "";
        if (this.contextAttrib != null) {
            fullName = this.contextAttrib.getName() + "(" + ContextService.getAbsoluteContextElementPath((ContextElement)this.contextAttrib) + ")";
        }
        return fullName;
    }

    public void setUIElementInfoProvider(UIElementInfoProvider provider) {
        this.infoProvider = provider;
    }

    public UIElementInfoProvider setUIElementInfoProvider() {
        return this.infoProvider;
    }

    public void setParent(ContextNode ctxElement) {
        this.contextElement = ctxElement;
    }

    public ContextElement getParent() {
        return this.contextElement;
    }

    public void setContextAttribute(ContextAttribute attrib) {
        this.contextAttrib = attrib;
        if (attrib != null) {
            this.contextElement = attrib.getNode();
        }
        if (attrib != null && this.infoProvider != null) {
            this.valuesMap.put(TMP_VIEW_ATTRIB, new Integer(this.infoProvider.getAttributeIndex(ContextService.getAbsoluteContextElementPath((ContextElement)attrib))));
        } else {
            this.valuesMap.put(TMP_VIEW_ATTRIB, new Integer(0));
        }
    }

    public ContextAttribute getContextAttribute() {
        return this.contextAttrib;
    }

    public void setInputLabel(String label) {
        this.inputLabel = label;
        this.valuesMap.put(TMP_VIEW_NAME, this.inputLabel);
    }

    public String getLabel() {
        return this.inputLabel;
    }

    public void setDefaultInputFieldType() {
        this.setInputFieldType(this.infoProvider.getInputFieldType(0));
        this.updateBindingProperty();
    }

    public void setInputFieldType(String fieldType) {
        this.inputFieldType = fieldType;
        if (this.infoProvider != null) {
            this.valuesMap.put(TMP_VIEW_EDITOR, new Integer(this.infoProvider.getInputFieldTypeIndex(fieldType)));
        }
    }

    public String getEditorType() {
        return this.inputFieldType;
    }

    public void setBindingProperty(String prop) {
        this.bindingProperty = prop;
        if (this.infoProvider != null) {
            this.valuesMap.put(TMP_VIEW_BIND_PROP, new Integer(this.infoProvider.getBindingPropertyIndex(this.inputFieldType, prop)));
        }
    }

    public String getBindingProperty() {
        return this.bindingProperty;
    }

    public Object getValue(String property) {
        if (property != null && this.valuesMap != null) {
            return this.valuesMap.get(property);
        }
        return null;
    }

    public void setInputFieldType(int index) {
        this.inputFieldType = this.infoProvider.getInputFieldType(index);
        this.valuesMap.put(TMP_VIEW_EDITOR, new Integer(index));
    }

    public void setBindingProperty(int index) {
        this.bindingProperty = this.infoProvider.getBindingProperty(this.inputFieldType, index);
        this.valuesMap.put(TMP_VIEW_BIND_PROP, new Integer(index));
    }

    public void setAttribute(int index) {
        this.contextAttrib = this.infoProvider.getContextAttribute(index);
        this.valuesMap.put(TMP_VIEW_ATTRIB, new Integer(index));
    }

    public String[] getEditorTypes() {
        if (this.infoProvider != null) {
            return this.infoProvider.getInputFieldTypes();
        }
        return null;
    }

    public String[] getBindingProperty(String editorType) {
        if (this.infoProvider != null) {
            return this.infoProvider.getBindingProperties(editorType);
        }
        return null;
    }

    public void updateBindingProperty() {
        if (this.inputFieldType != null) {
            String defaultProp = this.infoProvider.getDefaultPropertyForEditorType(this.inputFieldType);
            if (defaultProp != null && defaultProp.equals("") && this.infoProvider.getBindingProperties(this.inputFieldType) != null && this.infoProvider.getBindingProperties(this.inputFieldType).length > 0) {
                defaultProp = this.infoProvider.getBindingProperties(this.inputFieldType)[0];
            }
            this.setBindingProperty(defaultProp);
        }
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setIsSelected(boolean isSelected) {
        this.mIsSelected = isSelected;
    }

    public boolean isNew() {
        return this.mIsNew;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }
}

