/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.wizards;

import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingModel;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class AttributeBindingCellModifier
implements ICellModifier {
    private TableViewer tableViewer;
    private Table table;
    private AttributeBindingPage wizardPage;

    public AttributeBindingCellModifier(TableViewer tViewer, Table table, AttributeBindingPage page) {
        this.tableViewer = tViewer;
        this.table = table;
        this.wizardPage = page;
    }

    public boolean canModify(Object element, String tableHeader) {
        CellEditor[] editors;
        if (tableHeader.equals(AttributeBindingModel.TMP_VIEW_BIND_PROP) && (editors = this.tableViewer.getCellEditors())[3] instanceof ComboBoxCellEditor) {
            AttributeBindingModel model = (AttributeBindingModel)element;
            ComboBoxCellEditor comboBox = (ComboBoxCellEditor)editors[3];
            comboBox.setItems(model.getBindingProperty(model.getEditorType()));
            editors[3] = comboBox;
            this.tableViewer.setCellEditors(editors);
            this.tableViewer.refresh();
        }
        return true;
    }

    public Object getValue(Object element, String tableHeader) {
        AttributeBindingModel model = (AttributeBindingModel)element;
        return model.getValue(tableHeader);
    }

    public void modify(Object element, String tableHeader, Object newValue) {
        TableItem item = (TableItem)element;
        AttributeBindingModel model = (AttributeBindingModel)item.getData();
        boolean msgSet = false;
        if (tableHeader.equals(AttributeBindingModel.TMP_VIEW_NAME)) {
            model.setInputLabel((String)newValue);
            String message = this.wizardPage.checkForErrors();
            this.wizardPage.setErrorMessage(message);
            this.wizardPage.setPageComplete(message == null);
        } else if (tableHeader.equals(AttributeBindingModel.TMP_VIEW_ATTRIB)) {
            model.setAttribute((Integer)newValue);
            String message = this.wizardPage.checkForErrors();
            this.wizardPage.setErrorMessage(message);
            this.wizardPage.setPageComplete(message == null);
        } else if (tableHeader.equals(AttributeBindingModel.TMP_VIEW_EDITOR)) {
            model.setInputFieldType((Integer)newValue);
            CellEditor[] editors = this.tableViewer.getCellEditors();
            if (editors[3] instanceof ComboBoxCellEditor) {
                ComboBoxCellEditor comboBox = (ComboBoxCellEditor)editors[3];
                comboBox.setItems(model.getBindingProperty(model.getEditorType()));
                editors[3] = comboBox;
                this.tableViewer.setCellEditors(editors);
            }
            model.updateBindingProperty();
            String name = model.getEditorType();
            ViewElementDefinition definition = MetamodelServices.getViewElementDefinition((String)((View)this.wizardPage.getDevelopmentObject().getMDO()).getRoot().getMetamodel().getName(), (String)name);
            String bindingProperty = model.getBindingProperty();
            String message = this.wizardPage.isValid(model.getContextAttribute(), definition, bindingProperty);
            if (null == message || message.equals("")) {
                message = this.wizardPage.checkForErrors();
                this.wizardPage.setErrorMessage(message);
                this.wizardPage.setPageComplete(message == null);
            } else {
                this.wizardPage.setPageComplete(false);
                String errMsg = "Error for UIElement with label " + model.getLabel() + "\n" + message;
                this.wizardPage.setErrorMessage(errMsg);
                msgSet = true;
            }
            this.tableViewer.refresh();
        } else if (tableHeader.equals(AttributeBindingModel.TMP_VIEW_BIND_PROP)) {
            model.setBindingProperty((Integer)newValue);
            String message = this.wizardPage.checkForErrors();
            this.wizardPage.setErrorMessage(message);
            this.wizardPage.setPageComplete(message == null);
        }
        this.tableViewer.refresh();
    }
}

