/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ScriptingEnvironment
extends BaseScriptingEnvironment {
    protected static final String FRAGMENT_PREFIX = "<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'>";
    protected Timer timer = new Timer(true);
    protected UpdateManager updateManager;
    protected RunnableQueue updateRunnableQueue;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener svgAbortListener = new ScriptingEventListener("onabort");
    protected EventListener svgErrorListener = new ScriptingEventListener("onerror");
    protected EventListener svgResizeListener = new ScriptingEventListener("onresize");
    protected EventListener svgScrollListener = new ScriptingEventListener("onscroll");
    protected EventListener svgUnloadListener = new ScriptingEventListener("onunload");
    protected EventListener svgZoomListener = new ScriptingEventListener("onzoom");
    protected EventListener beginListener = new ScriptingEventListener("onbegin");
    protected EventListener endListener = new ScriptingEventListener("onend");
    protected EventListener repeatListener = new ScriptingEventListener("onrepeat");
    protected EventListener focusinListener = new ScriptingEventListener("onfocusin");
    protected EventListener focusoutListener = new ScriptingEventListener("onfocusout");
    protected EventListener activateListener = new ScriptingEventListener("onactivate");
    protected EventListener clickListener = new ScriptingEventListener("onclick");
    protected EventListener mousedownListener = new ScriptingEventListener("onmousedown");
    protected EventListener mouseupListener = new ScriptingEventListener("onmouseup");
    protected EventListener mouseoverListener = new ScriptingEventListener("onmouseover");
    protected EventListener mouseoutListener = new ScriptingEventListener("onmouseout");
    protected EventListener mousemoveListener = new ScriptingEventListener("onmousemove");

    public ScriptingEnvironment(BridgeContext bridgeContext) {
        super(bridgeContext);
        this.updateManager = bridgeContext.getUpdateManager();
        this.updateRunnableQueue = this.updateManager.getUpdateRunnableQueue();
        this.addScriptingListeners(this.document.getDocumentElement());
        EventTarget eventTarget = (EventTarget)((Object)this.document);
        this.domNodeInsertedListener = new DOMNodeInsertedListener();
        eventTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
        this.domNodeRemovedListener = new DOMNodeRemovedListener();
        eventTarget.addEventListener("DOMAttrRemoved", this.domNodeRemovedListener, false);
    }

    public org.apache.batik.script.Window createWindow(Interpreter interpreter, String string) {
        return new Window(interpreter, string);
    }

    public void runEventHandler(String string, Event event, String string2) {
        Interpreter interpreter = this.bridgeContext.getInterpreter(string2);
        if (interpreter == null && this.userAgent != null) {
            this.userAgent.displayError(new Exception("unknow language: " + string2));
        }
        interpreter.bindObject("event", (Object)event);
        interpreter.bindObject("evt", (Object)event);
        try {
            interpreter.evaluate(string);
        }
        catch (InterpreterException interpreterException) {
            this.handleInterpreterException(interpreterException);
        }
    }

    public void interrupt() {
        this.timer.cancel();
        this.removeScriptingListeners(this.document.getDocumentElement());
        EventTarget eventTarget = (EventTarget)((Object)this.document);
        eventTarget.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
        eventTarget.removeEventListener("DOMAttrRemoved", this.domNodeRemovedListener, false);
    }

    protected void addScriptingListeners(Node node) {
        Node node2;
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            EventTarget eventTarget = (EventTarget)((Object)node2);
            if ("http://www.w3.org/2000/svg".equals(node2.getNamespaceURI())) {
                if ("svg".equals(node2.getLocalName())) {
                    if (node2.hasAttributeNS(null, "onabort")) {
                        eventTarget.addEventListener("SVGAbort", this.svgAbortListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onerror")) {
                        eventTarget.addEventListener("SVGError", this.svgErrorListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onresize")) {
                        eventTarget.addEventListener("SVGResize", this.svgResizeListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onscroll")) {
                        eventTarget.addEventListener("SVGScroll", this.svgScrollListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onunload")) {
                        eventTarget.addEventListener("SVGUnload", this.svgUnloadListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onzoom")) {
                        eventTarget.addEventListener("SVGZoom", this.svgZoomListener, false);
                    }
                } else {
                    String string = node2.getLocalName();
                    if (string.equals("set") || string.startsWith("animate")) {
                        if (node2.hasAttributeNS(null, "onbegin")) {
                            eventTarget.addEventListener("beginEvent", this.beginListener, false);
                        }
                        if (node2.hasAttributeNS(null, "onend")) {
                            eventTarget.addEventListener("endEvent", this.endListener, false);
                        }
                        if (node2.hasAttributeNS(null, "onrepeat")) {
                            eventTarget.addEventListener("repeatEvent", this.repeatListener, false);
                        }
                        return;
                    }
                }
            }
            if (node2.hasAttributeNS(null, "onfocusin")) {
                eventTarget.addEventListener("DOMFocusIn", this.focusinListener, false);
            }
            if (node2.hasAttributeNS(null, "onfocusout")) {
                eventTarget.addEventListener("DOMFocusOut", this.focusoutListener, false);
            }
            if (node2.hasAttributeNS(null, "onactivate")) {
                eventTarget.addEventListener("DOMActivate", this.activateListener, false);
            }
            if (node2.hasAttributeNS(null, "onclick")) {
                eventTarget.addEventListener("click", this.clickListener, false);
            }
            if (node2.hasAttributeNS(null, "onmousedown")) {
                eventTarget.addEventListener("mousedown", this.mousedownListener, false);
            }
            if (node2.hasAttributeNS(null, "onmouseup")) {
                eventTarget.addEventListener("mouseup", this.mouseupListener, false);
            }
            if (node2.hasAttributeNS(null, "onmouseover")) {
                eventTarget.addEventListener("mouseover", this.mouseoverListener, false);
            }
            if (node2.hasAttributeNS(null, "onmouseout")) {
                eventTarget.addEventListener("mouseout", this.mouseoutListener, false);
            }
            if (node2.hasAttributeNS(null, "onmousemove")) {
                eventTarget.addEventListener("mousemove", this.mousemoveListener, false);
            }
        }
        node2 = node.getFirstChild();
        while (node2 != null) {
            this.addScriptingListeners(node2);
            node2 = node2.getNextSibling();
        }
    }

    protected void removeScriptingListeners(Node node) {
        Node node2;
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            EventTarget eventTarget = (EventTarget)((Object)node2);
            if ("http://www.w3.org/2000/svg".equals(node2.getNamespaceURI())) {
                if ("svg".equals(node2.getLocalName())) {
                    eventTarget.removeEventListener("SVGAbort", this.svgAbortListener, false);
                    eventTarget.removeEventListener("SVGError", this.svgErrorListener, false);
                    eventTarget.removeEventListener("SVGResize", this.svgResizeListener, false);
                    eventTarget.removeEventListener("SVGScroll", this.svgScrollListener, false);
                    eventTarget.removeEventListener("SVGUnload", this.svgUnloadListener, false);
                    eventTarget.removeEventListener("SVGZoom", this.svgZoomListener, false);
                } else {
                    String string = node2.getLocalName();
                    if (string.equals("set") || string.startsWith("animate")) {
                        eventTarget.removeEventListener("beginEvent", this.beginListener, false);
                        eventTarget.removeEventListener("endEvent", this.endListener, false);
                        eventTarget.removeEventListener("repeatEvent", this.repeatListener, false);
                        return;
                    }
                }
            }
            eventTarget.removeEventListener("DOMFocusIn", this.focusinListener, false);
            eventTarget.removeEventListener("DOMFocusOut", this.focusoutListener, false);
            eventTarget.removeEventListener("DOMActivate", this.activateListener, false);
            eventTarget.removeEventListener("click", this.clickListener, false);
            eventTarget.removeEventListener("mousedown", this.mousedownListener, false);
            eventTarget.removeEventListener("mouseup", this.mouseupListener, false);
            eventTarget.removeEventListener("mouseover", this.mouseoverListener, false);
            eventTarget.removeEventListener("mouseout", this.mouseoutListener, false);
            eventTarget.removeEventListener("mousemove", this.mousemoveListener, false);
        }
        node2 = node.getFirstChild();
        while (node2 != null) {
            this.removeScriptingListeners(node2);
            node2 = node2.getNextSibling();
        }
    }

    protected class ScriptingEventListener
    implements EventListener {
        protected String attribute;

        public ScriptingEventListener(String string) {
            this.attribute = string;
        }

        public void handleEvent(Event event) {
            Element element;
            Element element2 = element = (Element)((Object)event.getCurrentTarget());
            while (!(element2 == null || "http://www.w3.org/2000/svg".equals(element2.getNamespaceURI()) && "svg".equals(element2.getLocalName()))) {
                element2 = SVGUtilities.getParentElement(element2);
            }
            if (element2 == null) {
                return;
            }
            String string = element2.getAttributeNS(null, "contentScriptType");
            String string2 = element.getAttributeNS(null, this.attribute);
            if (string2.length() > 0) {
                ScriptingEnvironment.this.runEventHandler(string2, event, string);
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event event) {
            ScriptingEnvironment.this.removeScriptingListeners((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event event) {
            ScriptingEnvironment.this.addScriptingListeners((Node)((Object)event.getTarget()));
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interpreter, String string) {
            this.interpreter = interpreter;
            this.language = string;
        }

        public Object setInterval(String string, long l) {
            TimerTask timerTask = new TimerTask(this, string){
                EvaluateIntervalRunnable eir;
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$script = string;
                    this.eir = Window.access$000(this.this$1).new EvaluateIntervalRunnable(this.val$script, this.this$1.interpreter);
                }

                public void run() {
                    if (this.eir.count > 1) {
                        return;
                    }
                    ++this.eir.count;
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater((Runnable)this.eir);
                    if (this.eir.error) {
                        this.cancel();
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(timerTask, l, l);
            return timerTask;
        }

        public Object setInterval(Runnable runnable, long l) {
            TimerTask timerTask = new TimerTask(this, runnable){
                EvaluateRunnableRunnable eihr;
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$r = runnable;
                    this.eihr = Window.access$000(this.this$1).new EvaluateRunnableRunnable(this.val$r);
                }

                public void run() {
                    if (this.eihr.count > 1) {
                        return;
                    }
                    ++this.eihr.count;
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater((Runnable)this.eihr);
                    if (this.eihr.error) {
                        this.cancel();
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(timerTask, l, l);
            return timerTask;
        }

        public void clearInterval(Object object) {
            ((TimerTask)object).cancel();
        }

        public Object setTimeout(String string, long l) {
            TimerTask timerTask = new TimerTask(this, string){
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$script = string;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater((Runnable)Window.access$000(this.this$1).new EvaluateRunnable(this.val$script, this.this$1.interpreter));
                }
            };
            ScriptingEnvironment.this.timer.schedule(timerTask, l);
            return timerTask;
        }

        public Object setTimeout(Runnable runnable, long l) {
            TimerTask timerTask = new TimerTask(this, runnable){
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$r = runnable;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                        private final /* synthetic */ 4 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            block2: {
                                try {
                                    4.access$100(this.this$2).run();
                                }
                                catch (Exception exception) {
                                    if (Window.access$000((Window)4.access$200(this.this$2)).userAgent == null) break block2;
                                    Window.access$000((Window)4.access$200(this.this$2)).userAgent.displayError(exception);
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ Runnable access$100(4 var0) {
                    return var0.val$r;
                }

                static /* synthetic */ Window access$200(4 var0) {
                    return var0.this$1;
                }
            };
            ScriptingEnvironment.this.timer.schedule(timerTask, l);
            return timerTask;
        }

        public void clearTimeout(Object object) {
            ((TimerTask)object).cancel();
        }

        public DocumentFragment parseXML(String string, Document document) {
            SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            String string2 = ((SVGOMDocument)ScriptingEnvironment.this.bridgeContext.getDocument()).getURLObject().toString();
            DocumentFragment documentFragment = null;
            try {
                SVGOMDocument sVGOMDocument = sAXSVGDocumentFactory.createDocument(string2, (Reader)new StringReader(string));
                documentFragment = document.createDocumentFragment();
                documentFragment.appendChild(document.importNode(sVGOMDocument.getDocumentElement(), true));
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer(string.length() + ScriptingEnvironment.FRAGMENT_PREFIX.length() + "</svg>".length());
                stringBuffer.append(ScriptingEnvironment.FRAGMENT_PREFIX);
                stringBuffer.append(string);
                stringBuffer.append("</svg>");
                string = stringBuffer.toString();
                try {
                    SVGOMDocument sVGOMDocument = sAXSVGDocumentFactory.createDocument(string2, (Reader)new StringReader(string));
                    Node node = sVGOMDocument.getDocumentElement().getFirstChild();
                    while (node != null) {
                        System.out.println("We screwed up");
                        if (node.getNodeType() == 1) {
                            node = document.importNode(node, true);
                            documentFragment = document.createDocumentFragment();
                            documentFragment.appendChild(node);
                        }
                        node = node.getNextSibling();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return documentFragment;
        }

        public void getURL(String string, Window.GetURLHandler getURLHandler) {
            this.getURL(string, getURLHandler, "UTF8");
        }

        public void getURL(String string, Window.GetURLHandler getURLHandler, String string2) {
            Thread thread = new Thread(this, string, string2, getURLHandler){
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$enc;
                private final /* synthetic */ Window.GetURLHandler val$h;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$uri = string;
                    this.val$enc = string2;
                    this.val$h = getURLHandler;
                }

                public void run() {
                    try {
                        int n;
                        URL uRL = ((SVGOMDocument)Window.access$000((Window)this.this$1).document).getURLObject();
                        ParsedURL parsedURL = new ParsedURL(uRL, this.val$uri);
                        String string = EncodingUtilities.javaEncoding((String)this.val$enc);
                        string = string == null ? this.val$enc : string;
                        Reader reader = new InputStreamReader(parsedURL.openStream(), string);
                        reader = new BufferedReader(reader);
                        StringWriter stringWriter = new StringWriter();
                        char[] cArray = new char[4096];
                        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                            stringWriter.write(cArray, 0, n);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this, parsedURL, stringWriter){
                            private final /* synthetic */ ParsedURL val$purl;
                            private final /* synthetic */ StringWriter val$sw;
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$purl = parsedURL;
                                this.val$sw = stringWriter;
                            }

                            public void run() {
                                6.access$300(this.this$2).getURLDone(true, this.val$purl.getContentType(), this.val$sw.toString());
                            }
                        });
                    }
                    catch (Exception exception) {
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                6.access$300(this.this$2).getURLDone(false, null, null);
                            }
                        });
                    }
                }

                static /* synthetic */ Window.GetURLHandler access$300(6 var0) {
                    return var0.val$h;
                }
            };
            thread.setPriority(1);
            thread.start();
        }

        public void alert(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                ScriptingEnvironment.this.userAgent.showAlert(string);
            }
        }

        public boolean confirm(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showConfirm(string);
            }
            return false;
        }

        public String prompt(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(string);
            }
            return null;
        }

        public String prompt(String string, String string2) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(string, string2);
            }
            return null;
        }

        public BridgeContext getBridgeContext() {
            return ScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }

        static /* synthetic */ ScriptingEnvironment access$000(Window window) {
            return window.ScriptingEnvironment.this;
        }
    }

    protected class EvaluateRunnableRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Runnable runnable;

        public EvaluateRunnableRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() {
            if (this.error) {
                return;
            }
            --this.count;
            try {
                this.runnable.run();
            }
            catch (Exception exception) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(exception);
                }
                this.error = true;
            }
        }
    }

    protected class EvaluateIntervalRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Interpreter interpreter;
        protected String script;

        public EvaluateIntervalRunnable(String string, Interpreter interpreter) {
            this.interpreter = interpreter;
            this.script = string;
        }

        public void run() {
            if (this.error) {
                return;
            }
            --this.count;
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException interpreterException) {
                ScriptingEnvironment.this.handleInterpreterException(interpreterException);
                this.error = true;
            }
            catch (Exception exception) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(exception);
                }
                this.error = true;
            }
        }
    }

    protected class EvaluateRunnable
    implements Runnable {
        protected Interpreter interpreter;
        protected String script;

        public EvaluateRunnable(String string, Interpreter interpreter) {
            this.interpreter = interpreter;
            this.script = string;
        }

        public void run() {
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException interpreterException) {
                ScriptingEnvironment.this.handleInterpreterException(interpreterException);
            }
        }
    }
}

