/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPolylineProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsHandler;
import org.apache.batik.parser.PointsParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPolylineElementBridge
extends SVGDecoratedShapeElementBridge {
    public String getLocalName() {
        return "polyline";
    }

    public Bridge getInstance() {
        return new SVGPolylineElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        AWTPolylineProducer aWTPolylineProducer;
        block5: {
            String string = element.getAttributeNS(null, "points");
            if (string.length() != 0) {
                aWTPolylineProducer = new AWTPolylineProducer();
                aWTPolylineProducer.setWindingRule(CSSUtilities.convertFillRule(element));
                try {
                    try {
                        PointsParser pointsParser = new PointsParser();
                        pointsParser.setPointsHandler((PointsHandler)aWTPolylineProducer);
                        pointsParser.parse(string);
                    }
                    catch (ParseException parseException) {
                        BridgeException bridgeException = new BridgeException(element, "attribute.malformed", new Object[]{"points"});
                        bridgeException.setGraphicsNode((GraphicsNode)shapeNode);
                        throw bridgeException;
                    }
                    Object var9_8 = null;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    shapeNode.setShape(aWTPolylineProducer.getShape());
                    throw throwable;
                }
            }
            throw new BridgeException(element, "attribute.missing", new Object[]{"points"});
        }
        shapeNode.setShape(aWTPolylineProducer.getShape());
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }
}

