/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGShapeElementBridge;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGCircleElementBridge
extends SVGShapeElementBridge {
    public String getLocalName() {
        return "circle";
    }

    public Bridge getInstance() {
        return new SVGCircleElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "cx");
        float f = 0.0f;
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "cx", context);
        }
        string = element.getAttributeNS(null, "cy");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "cy", context);
        }
        if ((string = element.getAttributeNS(null, "r")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"r", string});
        }
        float f3 = UnitProcessor.svgOtherLengthToUserSpace(string, "r", context);
        if (f3 == 0.0f) {
            shapeNode.setShape(null);
            return;
        }
        float f4 = f - f3;
        float f5 = f2 - f3;
        float f6 = f3 * 2.0f;
        shapeNode.setShape((Shape)new Ellipse2D.Float(f4, f5, f6, f6));
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("cx") || string.equals("cy") || string.equals("r")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }
}

