/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.SubscrRecipients;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistUtils;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrRecipients;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import java.util.Collection;
import java.util.Map;

public class PersistSubscrRecipients
extends SubscrRecipients
implements IPersistSubscrRecipients {
    private Object m_key;
    private IPersistState m_state = new PersistState();

    protected ClassLoader getClassLoader() {
        return ((IPersistSubscription)this.getSubscription()).getApplication().getClassLoader();
    }

    public IPersistState getState() {
        return this.m_state;
    }

    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof IXMLPersistManager) {
            this.load((IXMLPersistManager)manager);
        } else if (manager instanceof ISQLPersistManager) {
            this.load((ISQLPersistManager)manager);
        }
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
        IPersistApplication app = (IPersistApplication)this.getSubscription().getApplication();
        this.setDescription(PersistUtils.resolveResRef(XMLUtils.getStrChildNodeValue(manager.getCurrentNode(), "description", true), app.getResourceName(), app.getClassLoader()));
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
        Map values = SQLUtils.loadObjValues(manager, "SELECT DESCR FROM CAF_RT_NS_RECIP WHERE (RECIP_KEY=?)", ISQLNames.SELECT_RECIP_TYPES, this);
        this.setDescription((String)values.get("DESCR"));
    }

    public void store(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            SQLUtils.execUpdate(sqlManager, "UPDATE CAF_RT_NS_RECIP SET SUBSCR_KEY=?,CLASS_NAME=?,DESCR=? WHERE (RECIP_KEY=?)", ISQLNames.UPDATE_RECIP_TYPES, new Object[]{((ISQLPersistEntity)((Object)this.getSubscription())).getKey(), this.getClass().getName(), this.getDescription(), this.getKey()});
        }
    }

    public void delete(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            SQLUtils.execUpdate(sqlManager, "DELETE FROM CAF_RT_NS_RECIP WHERE (RECIP_KEY=? AND SUBSCR_KEY=?)", ISQLNames.DELETE_RECIP_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getSubscription())).getKey()});
        }
    }

    public void create(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            this.setKey(SQLUtils.createKey());
            SQLUtils.execUpdate(sqlManager, "INSERT INTO CAF_RT_NS_RECIP (RECIP_KEY,SUBSCR_KEY,CLASS_NAME,DESCR) VALUES (?,?,?,?)", ISQLNames.INSERT_RECIP_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getSubscription())).getKey(), this.getClass().getName(), this.getDescription()});
        }
    }

    public void setDescription(String descr) {
        super.setDescription(descr);
        this.getState().setUpdated(true);
    }

    public Object getKey() {
        return this.m_key;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public Collection getUserIds(INotifEvent event) {
        return null;
    }
}

