/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.app.Application;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import com.sap.engine.services.deploy.DeployService;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class PersistApplication
extends Application
implements IPersistApplication {
    private Object m_key;
    private String m_sResName;
    private String m_sName;
    private IPersistState m_state = new PersistState();

    public PersistApplication() {
    }

    public PersistApplication(String id) {
        super(id, null, null);
    }

    public IPersistState getState() {
        return this.m_state;
    }

    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof IXMLPersistManager) {
            this.load((IXMLPersistManager)manager);
        } else if (manager instanceof ISQLPersistManager) {
            this.load((ISQLPersistManager)manager);
        }
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
        try {
            Map values = SQLUtils.loadObjValues(manager, "SELECT ID,NAME,RES_NAME FROM CAF_RT_NS_APP WHERE (APP_KEY=?)", ISQLNames.SELECT_APP_TYPES, this);
            String id = (String)values.get("ID");
            this.setId(id);
            this.setName((String)values.get("NAME"));
            this.setResourceName((String)values.get("RES_NAME"));
            this.invalidate();
        }
        catch (PersistException e) {
            throw new PersistException("CANT_LOAD_APP", (Throwable)((Object)e));
        }
    }

    public void invalidate() throws PersistException {
        ClassLoader appLoader = null;
        Properties appProps = null;
        this.setActive(false);
        try {
            String appId = this.getId();
            ClassLoader runtimeLoader = this.getClass().getClassLoader();
            appLoader = JndiUtils.getAppClassLoader(runtimeLoader, appId);
            appProps = JndiUtils.getAppProperties(runtimeLoader, appId);
            DeployService deplSvc = JndiUtils.getDeployService(runtimeLoader);
            this.setActive("STARTED".equals(deplSvc.getApplicationStatus(appId)));
        }
        catch (Exception e) {
            Log.fatal(e);
            appLoader = null;
            appProps = null;
            this.setActive(false);
        }
        this.setClassLoader(appLoader);
        this.setProperties(appProps);
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
        Node root = manager.getCurrentNode();
        Map nodes = XMLUtils.getNodesAsMap(root);
        this.setName(XMLUtils.getStrChildNodeValue(root, nodes, "name", true));
        this.setResourceName(XMLUtils.getStrChildNodeValue(root, nodes, "resources", true));
    }

    public void create(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            this.setKey(SQLUtils.createKey());
            SQLUtils.execUpdate(sqlManager, "INSERT INTO CAF_RT_NS_APP (APP_KEY,ID,NAME,RES_NAME) VALUES (?,?,?,?)", ISQLNames.INSERT_APP_TYPES, new Object[]{this.getKey(), this.getId(), this.getName(), this.getResourceName()});
        }
    }

    public void store(IPersistManager manager) throws PersistException {
        if (!this.isActive()) {
            throw new PersistException("CANT_STORE_INACTIVE", new Object[]{this.getKey()});
        }
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            SQLUtils.execUpdate(sqlManager, "UPDATE CAF_RT_NS_APP SET ID=?,NAME=?,RES_NAME=? WHERE (APP_KEY=?)", ISQLNames.UPDATE_APP_TYPES, new Object[]{this.getId(), this.getName(), this.getResourceName(), this.getKey()});
        }
    }

    public void delete(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            SQLUtils.execUpdate(sqlManager, "DELETE FROM CAF_RT_NS_APP WHERE (APP_KEY=?)", ISQLNames.DELETE_APP_TYPES, new Object[]{this.getKey()});
        }
    }

    public String getName() {
        return this.m_sName;
    }

    protected void setName(String name) {
        this.m_sName = name;
        this.getState().setUpdated(true);
    }

    public Object getKey() {
        return this.m_key;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public void setId(String id) {
        super.setId(id);
        this.getState().setUpdated(true);
    }

    public String getResourceName() {
        return this.m_sResName;
    }

    public void setResourceName(String name) {
        this.m_sResName = name;
        this.getState().setUpdated(true);
    }

    public void setClassLoader(ClassLoader loader) {
        super.setClassLoader(loader);
        this.setActive(loader != null);
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = super.getClassLoader();
        return classLoader != null ? classLoader : this.getClass().getClassLoader();
    }
}

