/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.sql;

import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistObjNotFoundException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SQLUtils {
    public static Object[] EMPTY_PARAMS = new Object[0];
    public static Integer INT_0 = new Integer(0);
    public static Integer INT_1 = new Integer(1);

    public static String createKey() throws PersistException {
        try {
            return PrimaryKeyFactory.getInstance().getPrimaryKey();
        }
        catch (DataAccessException e) {
            throw new PersistException("CANT_CREATE_PK", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execUpdate(ISQLPersistManager manager, String sql, int[] types, Object[] params) throws PersistException {
        try {
            Connection conn = manager.getConnection();
            try {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                try {
                    for (int i = 0; i < params.length; ++i) {
                        SQLUtils.setParam(pstmt, i + 1, params[i], types[i]);
                    }
                    pstmt.execute();
                }
                finally {
                    pstmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new PersistException("CANT_EXEC_SQL", new Object[]{sql, params}, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static List execSelect(ISQLPersistManager manager, String sql, int[] types, Object[] params) throws PersistException {
        try {
            Connection conn = manager.getConnection();
            try {
                ArrayList arrayList;
                ResultSet rs;
                PreparedStatement pstmt;
                block13: {
                    pstmt = conn.prepareStatement(sql);
                    for (int i = 0; i < params.length; ++i) {
                        SQLUtils.setParam(pstmt, i + 1, params[i], types[i]);
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) break block13;
                    List list = Collections.EMPTY_LIST;
                    pstmt.close();
                    return list;
                }
                try {
                    ResultSetMetaData meta = rs.getMetaData();
                    int cols = meta.getColumnCount();
                    ArrayList rows = new ArrayList();
                    do {
                        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                        for (int i = 1; i <= cols; ++i) {
                            row.put(meta.getColumnName(i), rs.getObject(i));
                        }
                        rows.add(row);
                    } while (rs.next());
                    arrayList = rows;
                }
                catch (Throwable throwable) {
                    pstmt.close();
                    throw throwable;
                }
                pstmt.close();
                return arrayList;
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new PersistException("CANT_EXEC_SQL", new Object[]{sql, params}, e);
        }
    }

    public static Map loadObjValues(ISQLPersistManager manager, String sql, int[] paramTypes, ISQLPersistEntity obj) throws PersistException {
        Object key = obj.getKey();
        if (key == null) {
            throw new PersistException("NULL_KEY", new Object[]{obj.getClass().getName()});
        }
        List rows = SQLUtils.execSelect(manager, sql, paramTypes, new Object[]{key});
        if (rows.size() == 0) {
            throw new PersistObjNotFoundException((IPersistEntity)obj, key);
        }
        return (Map)rows.get(0);
    }

    public static Map loadObjValues(ISQLPersistManager manager, String sql, int[] keyTypes, Object[] keyValues, ISQLPersistEntity obj) throws PersistException {
        int i = keyValues.length;
        while (--i >= 0) {
            if (keyValues[i] != null) continue;
            throw new PersistException("NULL_KEY", new Object[]{obj.getClass().getName()});
        }
        List rows = SQLUtils.execSelect(manager, sql, keyTypes, keyValues);
        if (rows.size() == 0) {
            throw new PersistObjNotFoundException((IPersistEntity)obj, keyValues);
        }
        return (Map)rows.get(0);
    }

    public static Map loadMap(ISQLPersistManager manager, String sql, int[] keyTypes, Object[] keyValues) throws PersistException {
        List rows = SQLUtils.execSelect(manager, sql, keyTypes, keyValues);
        if (rows == null || rows.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < rows.size(); ++i) {
            Map row = (Map)rows.get(i);
            String[] entry = row.values().toArray(new String[2]);
            result.put(entry[0], entry[1]);
        }
        return result;
    }

    private static void setParam(PreparedStatement pstmt, int num, Object value, int type) throws SQLException {
        if (value == null) {
            pstmt.setNull(num, type);
        } else if (12 == type) {
            pstmt.setString(num, ((String)value).trim());
        } else if (4 == type) {
            pstmt.setInt(num, (Integer)value);
        } else {
            throw new UnsupportedOperationException("Type:[" + type + "] is not supported");
        }
    }
}

