/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.app.lifecycle;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.AppDeployListener;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.AppLifeCycleException;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.IAppLifeCycleListener;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.IAppLifeCycleMonitor;
import com.sap.engine.services.deploy.DeployCallback;
import com.sap.engine.services.deploy.DeployCallbackImpl;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.DeployListener;
import com.sap.engine.services.deploy.DeployService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AppLifeCycleMonitor
implements IAppLifeCycleMonitor {
    protected static IAppLifeCycleMonitor s_monitor;
    protected List m_listeners = new LinkedList();

    protected AppLifeCycleMonitor() throws AppLifeCycleException {
        try {
            ClassLoader runtimeLoader = this.getClass().getClassLoader();
            DeployService deplSvc = JndiUtils.getDeployService(runtimeLoader);
            DeployCallbackImpl deplCallback = new DeployCallbackImpl();
            deplCallback.addDeployListener((DeployListener)new AppDeployListener(this));
            deplSvc.registerDeployCallback((DeployCallback)deplCallback, new String[]{JndiUtils.getClusterElementName(runtimeLoader)});
        }
        catch (Exception e) {
            Log.fatal(e);
            throw new AppLifeCycleException(e);
        }
    }

    public static synchronized IAppLifeCycleMonitor getInstance() throws AppLifeCycleException {
        if (s_monitor == null) {
            s_monitor = new AppLifeCycleMonitor();
        }
        return s_monitor;
    }

    public void addListener(IAppLifeCycleListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(IAppLifeCycleListener listener) {
        this.m_listeners.remove(listener);
    }

    void processEvent(DeployEvent event) {
        byte type = event.getActionType();
        if (type == 8 || type == 9 || type == 7 || type == 0 || type == 6) {
            byte phase = event.getAction();
            String appId = event.getComponentName();
            Iterator itr = this.m_listeners.iterator();
            while (itr.hasNext()) {
                IAppLifeCycleListener listener = (IAppLifeCycleListener)itr.next();
                listener.appStateChanged(appId, phase, type);
            }
        }
    }
}

