/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.app;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.app.IAppSubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class AppSubscrList
extends PersistSubscrList
implements IAppSubscrList {
    private IPersistApplication m_app;
    private Map m_groups = new LinkedHashMap();

    public AppSubscrList() {
    }

    public AppSubscrList(IPersistApplication app) {
        this.setApplication(app);
    }

    public synchronized void addSubscription(ISubscription subscr) {
        super.addSubscription(subscr);
        subscr.setSubscrList(this);
        subscr.setApplication(this.getApplication());
        this.addSubscrByGroup(subscr);
    }

    public synchronized void removeSubscription(String id) {
        ISubscription subscr = this.getSubscription(id);
        if (subscr != null) {
            super.removeSubscription(id);
            this.removeSubscrByGroup(subscr);
        }
    }

    public Iterator getSubscrByGroup(String groupId) {
        Map keys = this.getGrouppedKeys(groupId);
        return keys == null ? Collections.EMPTY_LIST.iterator() : keys.values().iterator();
    }

    protected void addSubscrByGroup(ISubscription subscr) {
        String groupId = subscr.getGroupId();
        Map grouppedKeys = this.getGrouppedKeys(groupId);
        if (grouppedKeys == null) {
            grouppedKeys = this.addGroupId(groupId);
        }
        String id = subscr.getId();
        grouppedKeys.put(id, subscr);
    }

    protected void removeSubscrByGroup(ISubscription subscr) {
        String subscrId = subscr.getId();
        if (subscr == null) {
            return;
        }
        Map grouppedKeys = this.getGrouppedKeys(subscr.getGroupId());
        if (grouppedKeys != null) {
            grouppedKeys.remove(subscrId);
        }
    }

    public Iterator getGroupIds() {
        return this.m_groups.keySet().iterator();
    }

    protected Map addGroupId(String groupId) {
        LinkedHashMap keys = new LinkedHashMap();
        this.m_groups.put(groupId, keys);
        return keys;
    }

    protected Map getGrouppedKeys(String groupId) {
        return (Map)this.m_groups.get(groupId);
    }

    public IPersistApplication getApplication() {
        return this.m_app;
    }

    public void setApplication(IPersistApplication app) {
        this.m_app = app;
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
        try {
            IPersistApplication app = this.getApplication();
            List rows = SQLUtils.execSelect(manager, "SELECT SUBSCR_KEY FROM CAF_RT_NS_SUBSCR WHERE (APP_KEY=?)", ISQLNames.SELECT_SUBSCR_KEYS_TYPES, new Object[]{app.getKey()});
            int i = rows.size();
            while (--i >= 0) {
                Map row = (Map)rows.get(i);
                PersistSubscription subscr = new PersistSubscription();
                subscr.setKey((String)row.get("SUBSCR_KEY"));
                subscr.setApplication(app);
                manager.load(subscr);
                this.addSubscription(subscr);
                subscr.getState().reset();
            }
        }
        catch (PersistException e) {
            throw new PersistException("CANT_LOAD_SUBSCR_LIST", (Throwable)((Object)e));
        }
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
        try {
            ClassLoader loader = this.getClassLoader();
            Node root = manager.getCurrentNode();
            manager.load(XMLUtils.getChildNode(manager.getCurrentNode(), "application"), this.m_app);
            boolean bDebug = Log.isDebugEnabled();
            IPersistApplication app = this.getApplication();
            List nodes = XMLUtils.getNodesAsList(root, "subscription");
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                PersistSubscription subscr = new PersistSubscription();
                subscr.setApplication(app);
                manager.load(node, subscr);
                this.addSubscription(subscr);
                subscr.getState().reset();
            }
        }
        catch (PersistException e) {
            throw new PersistException("CANT_LOAD_SUBSCR_LIST", (Throwable)((Object)e));
        }
    }

    protected ClassLoader getClassLoader() {
        return this.getApplication().getClassLoader();
    }
}

