/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.ISubscrFilter;
import com.sap.caf.rt.services.notify.subscr.ISubscrType;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SubscrFilter
implements ISubscrFilter {
    protected Map m_types = new LinkedHashMap();
    protected ISubscription m_subscr;

    public ISubscription getSubscription() {
        return this.m_subscr;
    }

    public void setSubscription(ISubscription subscr) {
        this.m_subscr = subscr;
    }

    public boolean accept(INotifEvent event) {
        ISubscription subscr = this.getSubscription();
        if (!subscr.isEnabled()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Subscription:" + subscr.getId() + " is disabled, event ignored");
            }
            return false;
        }
        ISubscrType eventType = event.getType();
        Iterator itr = this.getTypes();
        while (itr.hasNext()) {
            ISubscrType type = (ISubscrType)itr.next();
            if (!type.equals(eventType)) continue;
            return true;
        }
        return false;
    }

    public Iterator getTypes() {
        return this.m_types.values().iterator();
    }

    public ISubscrType getType(String id) {
        return (ISubscrType)this.m_types.get(id);
    }

    public void addType(ISubscrType type) {
        type.setFilter(this);
        this.m_types.put(type.getId(), type);
    }

    public void removeType(String typeId) {
        this.m_types.remove(typeId);
    }
}

