/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.notif;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.common.NSBaseException;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.notif.NotifDispatcher;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.ISubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.deployed.DeployedSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.app.registered.RegisteredSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import java.util.ArrayList;
import java.util.Iterator;

public class RegisteredNotifDispatcher
extends NotifDispatcher {
    protected ISubscrListFactory getSubscrListFactory() throws SubscrException {
        return CAFContext.NOTIF_USE_DEPLOYED_SUBSCR ? DeployedSubscrListFactory.getInstance() : RegisteredSubscrListFactory.getInstance();
    }

    protected void fireOnBeforeSend(ISubscription subscr, INotifEvent event) throws NSBaseException {
        event.setAttribute("priv:appProps", ((IPersistSubscription)subscr).getApplication().getProperties());
    }

    protected Iterator getSubscriptions(ISubscrList subscrList, INotifEvent event) throws SubscrException {
        String subscrId = event.getId();
        ISubscription subscr = subscrList.getSubscription(subscrId);
        if (subscr == null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Could not find subscription by id:[{0}]", new Object[]{subscrId});
            }
            return null;
        }
        ArrayList<ISubscription> list = new ArrayList<ISubscription>(1);
        list.add(subscr);
        return list.iterator();
    }
}

