/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.localization;

import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.localization.ILocalizationService;
import com.sap.caf.rt.services.localization.LocalizationDataAccessor;
import com.sap.caf.rt.services.localization.LocalizationDataBean;
import com.sap.caf.rt.services.localization.LocalizationResourceAccessor;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

public class LocalizationServiceBean
implements SessionBean,
ILocalizationService {
    protected SessionContext sessionContext;
    private static final String APPLICATION = (class$com$sap$caf$rt$services$localization$LocalizationServiceBean == null ? (class$com$sap$caf$rt$services$localization$LocalizationServiceBean = LocalizationServiceBean.class$("com.sap.caf.rt.services.localization.LocalizationServiceBean")) : class$com$sap$caf$rt$services$localization$LocalizationServiceBean).getName();
    private static final String jARMRequest = "CAF:RT:oal" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    static /* synthetic */ Class class$com$sap$caf$rt$services$localization$LocalizationServiceBean;

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext context) {
        this.sessionContext = context;
    }

    public void ejbCreate() throws CreateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(LocalizationDataBean localizationBean) throws ServiceException {
        String method = "create(LocalizationDataBean)";
        CAFPublicLogger.entering((String)this.getUser(), (String)jARMRequest, (String)"create(LocalizationDataBean)", (Location)logger, (int)1);
        try {
            String string = LocalizationDataAccessor.createObject(localizationBean);
            return string;
        }
        finally {
            CAFPublicLogger.exiting((String)this.getUser(), (String)jARMRequest, (String)"create(LocalizationDataBean)", (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalizationDataBean findByPK(String pk) throws ServiceException {
        String method = "findByPK(String)";
        CAFPublicLogger.entering((String)this.getUser(), (String)jARMRequest, (String)"findByPK(String)", (Location)logger, (int)1);
        try {
            LocalizationDataBean localizationDataBean = LocalizationDataAccessor.selectObjectByPk(pk);
            return localizationDataBean;
        }
        finally {
            CAFPublicLogger.exiting((String)this.getUser(), (String)jARMRequest, (String)"findByPK(String)", (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(LocalizationDataBean localizationBean) throws ServiceException {
        String method = "delete(LocalizationDataBean)";
        CAFPublicLogger.entering((String)this.getUser(), (String)jARMRequest, (String)"delete(LocalizationDataBean)", (Location)logger, (int)1);
        try {
            String pk = (String)localizationBean.getProperty("objectKey");
            LocalizationDataBean dbObj = null;
            if (!this.isEmpty(pk)) {
                try {
                    dbObj = LocalizationDataAccessor.selectObjectByPk(pk);
                }
                catch (ServiceException e) {
                    CAFPublicLogger.traceThrowable((int)300, (Location)logger, (String)"delete(LocalizationDataBean)", (Throwable)e);
                }
            }
            if (dbObj != null) {
                LocalizationDataAccessor.deleteObject(localizationBean);
            }
        }
        finally {
            CAFPublicLogger.exiting((String)this.getUser(), (String)jARMRequest, (String)"delete(LocalizationDataBean)", (Location)logger, (int)1);
        }
    }

    public void update(LocalizationDataBean localizationBean) throws ServiceException {
        String method = "update(LocalizationDataBean)";
        CAFPublicLogger.entering((String)this.getUser(), (String)jARMRequest, (String)"update(LocalizationDataBean)", (Location)logger, (int)1);
        try {
            String pk = (String)localizationBean.getProperty("objectKey");
            LocalizationDataBean dbObj = null;
            if (!this.isEmpty(pk)) {
                try {
                    dbObj = LocalizationDataAccessor.selectObjectByPk(pk);
                }
                catch (ServiceException e) {
                    CAFPublicLogger.traceThrowable((int)300, (Location)logger, (String)"update(LocalizationDataBean)", (Throwable)e);
                }
            }
            String text = (String)localizationBean.getProperty("text");
            if (dbObj == null) {
                if (text != null && !"".equals(text.trim())) {
                    this.create(localizationBean);
                }
            } else if (text == null || "".equals(text.trim())) {
                LocalizationDataAccessor.deleteObject(localizationBean);
            } else {
                LocalizationDataAccessor.updateObject(localizationBean);
            }
        }
        catch (ServiceException e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"update(LocalizationDataBean)", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"update(LocalizationDataBean)", (Throwable)e);
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)this.getUser(), (String)jARMRequest, (String)"update(LocalizationDataBean)", (Location)logger, (int)1);
        }
    }

    public LocalizationDataBean findByResourceName(String serviceModuleName, String aspectName, String queryName, String actionName, String paramName, String locStr) throws ServiceException {
        String method = "findByResourceName(String, String, String, String, String, String)";
        CAFPublicLogger.entering((String)this.getUser(), (String)jARMRequest, (String)"findByResourceName(String, String, String, String, String, String)", (Location)logger, (int)1);
        try {
            if (this.isEmpty(paramName) || "*".equals(paramName)) {
                throw new IllegalArgumentException("Name of Attribute (Parameter) mustn't be empty or '*'");
            }
            String resourceName = LocalizationResourceAccessor.getResourceName(serviceModuleName, aspectName, queryName, actionName, paramName);
            Collection dbBeans = LocalizationDataAccessor.selectObjectByResName(resourceName, locStr);
            if (dbBeans.size() == 1) {
                LocalizationDataBean localizationDataBean = (LocalizationDataBean)dbBeans.iterator().next();
                return localizationDataBean;
            }
            if (dbBeans.isEmpty()) {
                LocalizationDataBean localizationDataBean = this.getSingleLocalizationDataForLocale(serviceModuleName, resourceName, locStr);
                return localizationDataBean;
            }
            try {
                throw new RuntimeException("There are more then one resource named " + resourceName + " in locale " + locStr);
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"findByResourceName(String, String, String, String, String, String)", (Throwable)e);
                throw new CAFFindException("BO_READ", (Throwable)e);
            }
        }
        finally {
            CAFPublicLogger.exiting((String)this.getUser(), (String)jARMRequest, (String)"findByResourceName(String, String, String, String, String, String)", (Location)logger, (int)1);
        }
    }

    private String getProp(IDataContainerBean bean, String propName) {
        Object o = bean.getProperty(propName);
        return o == null ? null : o.toString();
    }

    private boolean isEmpty(String l) {
        return l == null || l.equals("");
    }

    private String getUser() {
        return this.sessionContext.getCallerPrincipal().getName();
    }

    public Collection findDefaultByResourceName(String serviceModuleName, String aspectName, String queryName, String actionName, Collection paramNames, String locStr) throws ServiceException {
        String method = "findDefaultByResourceName(String, String, String, String, Collection, String)";
        CAFPublicLogger.entering((String)this.getUser(), (String)jARMRequest, (String)"findDefaultByResourceName(String, String, String, String, Collection, String)", (Location)logger, (int)1);
        try {
            String resourceName = LocalizationResourceAccessor.getResourceName(serviceModuleName, aspectName, queryName, actionName, null);
            List localizedTexts = this.getLocalizationDataForLocale(serviceModuleName, resourceName, locStr, paramNames);
            ArrayList<LocalizationDataBean> result = new ArrayList<LocalizationDataBean>(localizedTexts.size() / 2);
            Iterator i = localizedTexts.iterator();
            while (i.hasNext()) {
                String fullResourceName = (String)i.next();
                String text = (String)i.next();
                result.add(new LocalizationDataBean(null, fullResourceName, text, locStr, LocalizationDataAccessor.getTypeName(fullResourceName)));
            }
            Collections.sort(result, new LocalizationDataBean.LocComparator());
            ArrayList<LocalizationDataBean> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"findDefaultByResourceName(String, String, String, String, Collection, String)", (Throwable)e);
            throw new CAFFindException("BO_READ", (Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)this.getUser(), (String)jARMRequest, (String)"findDefaultByResourceName(String, String, String, String, Collection, String)", (Location)logger, (int)1);
        }
    }

    public LocalizationDataBean findDefaultLocalizationData(LocalizationDataBean bean) throws ServiceException {
        String method = "findDefaultLocalizationData(LocalizationDataBean)";
        CAFPublicLogger.entering((String)this.getUser(), (String)jARMRequest, (String)"findDefaultLocalizationData(LocalizationDataBean)", (Location)logger, (int)1);
        try {
            if (bean == null) {
                throw new IllegalArgumentException("Passed Localization data bean is null");
            }
            String resourceName = bean.getResourceName();
            LocalizationDataBean localizationDataBean = this.getSingleLocalizationDataForLocale(LocalizationResourceAccessor.getServiceModuleName(resourceName), resourceName, bean.getLanguage());
            return localizationDataBean;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"findDefaultLocalizationData(LocalizationDataBean)", (Throwable)e);
            throw new CAFFindException("BO_READ", (Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)this.getUser(), (String)jARMRequest, (String)"findDefaultLocalizationData(LocalizationDataBean)", (Location)logger, (int)1);
        }
    }

    public Collection findByResourceName(String serviceModuleName, String aspectName, String queryName, String actionName, Collection paramNames, String locStr) throws ServiceException {
        String method = "findByResourceName(String, String, String, String, Collection, String)";
        CAFPublicLogger.entering((String)this.getUser(), (String)jARMRequest, (String)"findByResourceName(String, String, String, String, Collection, String)", (Location)logger, (int)1);
        try {
            String resourceName = LocalizationResourceAccessor.getResourceName(serviceModuleName, aspectName, queryName, actionName, null);
            Collection dbBeans = LocalizationDataAccessor.selectObjectByResName(resourceName, locStr);
            HashMap<String, LocalizationDataBean> resourceName2dbBean = new HashMap<String, LocalizationDataBean>(dbBeans.size());
            Iterator i = dbBeans.iterator();
            while (i.hasNext()) {
                LocalizationDataBean bean = (LocalizationDataBean)i.next();
                resourceName2dbBean.put(bean.getResourceName(), bean);
            }
            List localizedTexts = this.getLocalizationDataForLocale(serviceModuleName, resourceName, locStr, paramNames);
            ArrayList<LocalizationDataBean> result = new ArrayList<LocalizationDataBean>(localizedTexts.size() / 2 + resourceName2dbBean.size());
            Iterator i2 = localizedTexts.iterator();
            while (i2.hasNext()) {
                String fullResourceName = (String)i2.next();
                String text = (String)i2.next();
                LocalizationDataBean dbBean = (LocalizationDataBean)resourceName2dbBean.remove(fullResourceName);
                LocalizationDataBean resultBean = dbBean != null ? dbBean : new LocalizationDataBean(null, fullResourceName, text, locStr, LocalizationDataAccessor.getTypeName(fullResourceName));
                result.add(resultBean);
            }
            result.addAll(resourceName2dbBean.values());
            Collections.sort(result, new LocalizationDataBean.LocComparator());
            ArrayList<LocalizationDataBean> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"findByResourceName(String, String, String, String, Collection, String)", (Throwable)e);
            throw new CAFFindException("BO_READ", (Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)this.getUser(), (String)jARMRequest, (String)"findByResourceName(String, String, String, String, Collection, String)", (Location)logger, (int)1);
        }
    }

    private LocalizationDataBean getSingleLocalizationDataForLocale(String serviceModuleName, String resourceName, String locStr) throws Exception {
        String localizedParam = LocalizationResourceAccessor.getLocalizedText(LocalizationDataAccessor.getLocaleByStringCode(locStr), resourceName, serviceModuleName, LocalizationServiceBean.getModuleClassLoader(serviceModuleName));
        return new LocalizationDataBean(null, resourceName, localizedParam, locStr, LocalizationDataAccessor.getTypeName(resourceName));
    }

    private List getLocalizationDataForLocale(String serviceModuleName, String resourceName, String locStr, Collection paramNames) throws Exception {
        ArrayList<String> localizedTexts = LocalizationResourceAccessor.getLocalizedTexts(LocalizationDataAccessor.getLocaleByStringCode(locStr), resourceName, serviceModuleName, LocalizationServiceBean.getModuleClassLoader(serviceModuleName));
        if (localizedTexts.isEmpty() && paramNames != null) {
            localizedTexts = new ArrayList<String>(paramNames.size() * 2);
            Iterator i = paramNames.iterator();
            while (i.hasNext()) {
                localizedTexts.add(LocalizationResourceAccessor.completeResourceName(resourceName, (String)i.next()));
                localizedTexts.add(null);
            }
        }
        return localizedTexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClassLoader getModuleClassLoader(String serviceModuleName) throws Exception {
        String method = "getModuleClassLoader(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)"getModuleClassLoader(String)", (Location)logger);
        try {
            InitialContext ctx = new InitialContext();
            Object lh = ctx.lookup(LocalizationServiceBean.getServiceJNDI_KEY(serviceModuleName));
            ClassLoader classLoader = lh.getClass().getClassLoader();
            return classLoader;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)"getModuleClassLoader(String)", (Location)logger);
        }
    }

    static String getServiceJNDI_KEY(String serviceModuleName) {
        return "localejbs/" + serviceModuleName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

