/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.localization;

import com.sap.caf.rt.services.localization.LocalizationDataAccessor;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizationResourceAccessor
extends ResourceAccessor {
    static final String JARM_REQUEST = "CAF:RT:oal";
    private static final String APPLICATION = (class$com$sap$caf$rt$services$localization$LocalizationResourceAccessor == null ? (class$com$sap$caf$rt$services$localization$LocalizationResourceAccessor = LocalizationResourceAccessor.class$("com.sap.caf.rt.services.localization.LocalizationResourceAccessor")) : class$com$sap$caf$rt$services$localization$LocalizationResourceAccessor).getName();
    private static final String jARMRequest = "CAF:RT:oal" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    static final char LOCALIZED_KEY_SPLITTER = '@';
    static final String LOCALIZED_KEY_SPLITTER_STR = "@";
    private static final int METHOD_TYPE_QUERY = 0;
    private static final int METHOD_TYPE_ACTION = 1;
    private ClassLoader cl;
    private HashMap bundles = new HashMap(2);
    private static HashMap accessors = new HashMap(10);
    static /* synthetic */ Class class$com$sap$caf$rt$services$localization$LocalizationResourceAccessor;

    private LocalizationResourceAccessor(String resourceBundleName, ClassLoader cl) {
        super(resourceBundleName);
        this.cl = cl;
    }

    private static LocalizationResourceAccessor getResourceAccessor(String serviceModuleName, ClassLoader cl) throws Exception {
        return LocalizationResourceAccessor.getResourceAccessorInt(LocalizationResourceAccessor.getBundleNameByServiceModule(serviceModuleName), cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized LocalizationResourceAccessor getResourceAccessorInt(String bundleName, ClassLoader classLoader) throws Exception {
        String method = "getResourceAccessor(String, ClassLoader)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)"getResourceAccessor(String, ClassLoader)", (Location)logger);
        try {
            if (bundleName == null || classLoader == null) {
                throw new IllegalArgumentException("One of passed parameters is null: LocalizationResourceAccessor.getResourceAccessorInt(String bundleName, ClassLoader classLoader)");
            }
            String key = bundleName + ":" + System.identityHashCode(classLoader);
            LocalizationResourceAccessor ra = (LocalizationResourceAccessor)((Object)accessors.get(key));
            if (ra == null) {
                ra = new LocalizationResourceAccessor(bundleName, classLoader);
                accessors.put(key, ra);
            }
            LocalizationResourceAccessor localizationResourceAccessor = ra;
            return localizationResourceAccessor;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)"getResourceAccessor(String, ClassLoader)", (Location)logger);
        }
    }

    private static String getBundleNameByServiceModule(String moduleName) {
        if (moduleName != null) {
            int lastIndex = moduleName.lastIndexOf(47);
            return moduleName.substring(lastIndex < 0 ? 0 : lastIndex + 1);
        }
        return null;
    }

    public static String getResourceName(String serviceModuleName, String aspectName, String queryName, String actionName, String parameterName) throws Exception {
        StringBuffer result = new StringBuffer(50);
        if (LocalizationResourceAccessor.isEmpty(serviceModuleName)) {
            throw new IllegalArgumentException("Service Module name must be not null.");
        }
        result.append(serviceModuleName).append('@');
        boolean subModuleSetted = true;
        if (!LocalizationResourceAccessor.isEmpty(aspectName)) {
            result.append(aspectName).append('@');
        } else if (!LocalizationResourceAccessor.isEmpty(queryName)) {
            result.append(queryName).append('@').append(0).append('@');
        } else if (!LocalizationResourceAccessor.isEmpty(actionName)) {
            result.append(actionName).append('@').append(1).append('@');
        } else {
            subModuleSetted = false;
        }
        if (!LocalizationResourceAccessor.isEmpty(parameterName)) {
            if (!subModuleSetted) {
                throw new IllegalArgumentException("Aspect, Query or Action name must be specified along with property/parameter name.");
            }
            result.append(parameterName);
        }
        return result.toString();
    }

    static String getServiceModuleName(String resourceName) {
        if (resourceName != null) {
            int firstSplitterIdx = resourceName.indexOf(64);
            return firstSplitterIdx >= 0 ? resourceName.substring(0, firstSplitterIdx) : resourceName;
        }
        return null;
    }

    static String getAttributeName(String resourceName) {
        if (resourceName != null) {
            int ind = resourceName.lastIndexOf(64);
            return ind >= 0 ? resourceName.substring(ind + 1) : "";
        }
        return null;
    }

    static String completeResourceName(String resourceNamePrefix, String paramName) throws Exception {
        if (paramName == null || resourceNamePrefix == null) {
            throw new IllegalArgumentException("One of passed parameters are null");
        }
        StringBuffer sb = new StringBuffer(resourceNamePrefix.length() + paramName.length());
        return sb.append(resourceNamePrefix).append(paramName).toString();
    }

    public static String getCustomizedText(Locale locale, String patternKey, String moduleName, ClassLoader cl) throws Exception {
        LocalizationResourceAccessor accessor = LocalizationResourceAccessor.getResourceAccessor(moduleName, cl);
        return accessor.getMessageText(locale, patternKey);
    }

    private String getValueFromLocalizationService(Locale locale, String patternKey) {
        String method = "getValueFromLocalizationService(Locale, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)"getValueFromLocalizationService(Locale, String)", (Location)logger);
        String result = null;
        try {
            Collection resources = LocalizationDataAccessor.selectObjectByResName(patternKey, locale.toString(), true);
            int size = resources.size();
            if (size > 1) {
                throw new RuntimeException("There are more then one resource named " + patternKey + " in locale " + locale);
            }
            if (size == 1) {
                result = (String)((IDataContainerBean)resources.iterator().next()).getProperty("text");
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"getValueFromLocalizationService(Locale, String)", (Throwable)e);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)"getValueFromLocalizationService(Locale, String)", (Location)logger);
        return result;
    }

    public String getMessageText(Locale locale, String patternKey) {
        String method = "getMessageText(Locale, String)";
        String message = null;
        try {
            ResourceBundle rb;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((message = this.getValueFromLocalizationService(locale, patternKey)) == null && patternKey != null && (rb = this.getResourceBundle(locale)) != null) {
                message = rb.getString(patternKey);
            }
        }
        catch (MissingResourceException mre) {
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"getMessageText(Locale, String)", (Throwable)e);
        }
        return message;
    }

    public static String getLocalizedText(Locale locale, String patternKey, String moduleName, ClassLoader cl) throws Exception {
        LocalizationResourceAccessor accessor = LocalizationResourceAccessor.getResourceAccessor(moduleName, cl);
        return accessor.getMessageTextForLocale(locale, patternKey);
    }

    public static List getLocalizedTexts(Locale locale, String patternKey, String moduleName, ClassLoader cl) throws Exception {
        LocalizationResourceAccessor accessor = LocalizationResourceAccessor.getResourceAccessor(moduleName, cl);
        return accessor.getMessageTextsForLocale(locale, patternKey);
    }

    public String getMessageTextForLocale(Locale locale, String patternKey) {
        String method = "getMessageTextForLocale(Locale, String)";
        String result = null;
        try {
            ResourceBundle rb;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((rb = this.getResourceBundle(locale)) != null && locale.equals(rb.getLocale())) {
                result = rb.getString(patternKey);
            }
        }
        catch (MissingResourceException mre) {
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"getMessageTextForLocale(Locale, String)", (Throwable)e);
        }
        return result;
    }

    public List getMessageTextsForLocale(Locale locale, String patternKey) {
        String method = "getMessageTextsForLocale(Locale, String)";
        ArrayList<String> result = Collections.EMPTY_LIST;
        try {
            ResourceBundle rb;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (patternKey != null && (rb = this.getResourceBundle(locale)) != null && locale.equals(rb.getLocale())) {
                Enumeration<String> bundleKeys = rb.getKeys();
                result = new ArrayList<String>();
                while (bundleKeys.hasMoreElements()) {
                    String key = bundleKeys.nextElement();
                    if (!key.startsWith(patternKey)) continue;
                    result.add(key);
                    result.add(rb.getString(key));
                }
            }
        }
        catch (MissingResourceException mre) {
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)"getMessageTextsForLocale(Locale, String)", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundle(Locale locale) throws Exception {
        String method = "getResourceBundle(Locale)";
        ResourceBundle rb = null;
        HashMap hashMap = this.bundles;
        synchronized (hashMap) {
            rb = (ResourceBundle)this.bundles.get(locale);
            if (rb == null && this.getResourceBundleName() != null && this.cl != null && (rb = ResourceBundle.getBundle(this.getResourceBundleName(), locale, this.cl)) != null) {
                this.bundles.put(locale, rb);
            }
        }
        return rb;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

