/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.localization;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.localization.LocalizationResourceAccessor;
import com.sap.caf.rt.srv.IDataContainerBean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class LocalizationDataBean
implements IDataContainerBean {
    public static final String PROP_OBJECTKEY = "objectKey";
    public static final String PROP_RES_NAME = "resourceName";
    public static final String PROP_ATTRIBUTE = "attribute";
    public static final String PROP_TEXT = "text";
    public static final String PROP_LANGUAGE = "language";
    public static final String PROP_CUSTOM_TYPE = "customType";
    private static List localizationPropInfo = new ArrayList(6);
    private String objectKey;
    private String resourceName;
    private String attribute;
    private String text;
    private String language;
    private String customType;

    public LocalizationDataBean() {
    }

    public LocalizationDataBean(LocalizationDataBean original) {
        this(original.objectKey, original.resourceName, original.text, original.language, original.customType);
    }

    public LocalizationDataBean(String objectKey, String resourceName, String text, String language, String customType) {
        this.objectKey = objectKey;
        this.resourceName = resourceName;
        this.text = text;
        this.language = language;
        this.customType = customType;
    }

    public Object getProperty(String propertyName) {
        String prop = null;
        if (PROP_OBJECTKEY.equals(propertyName)) {
            prop = this.getObjectKey();
        } else if (PROP_RES_NAME.equals(propertyName)) {
            prop = this.getResourceName();
        } else if (PROP_ATTRIBUTE.equals(propertyName)) {
            prop = this.getAttribute();
        } else if (PROP_TEXT.equals(propertyName)) {
            prop = this.getText();
        } else if (PROP_LANGUAGE.equals(propertyName)) {
            prop = this.getLanguage();
        } else if (PROP_CUSTOM_TYPE.equals(propertyName)) {
            prop = this.getCustomType();
        }
        return prop;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        if (PROP_OBJECTKEY.equals(propertyName)) {
            this.setObjectKey((String)propertyValue);
        } else if (PROP_RES_NAME.equals(propertyName)) {
            this.setResourceName((String)propertyValue);
        } else if (PROP_ATTRIBUTE.equals(propertyName)) {
            this.setAttribute((String)propertyValue);
        } else if (PROP_TEXT.equals(propertyName)) {
            this.setText((String)propertyValue);
        } else if (PROP_LANGUAGE.equals(propertyName)) {
            this.setLanguage((String)propertyValue);
        } else if (PROP_CUSTOM_TYPE.equals(propertyName)) {
            this.setCustomType((String)propertyValue);
        }
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getText() {
        return this.text;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCustomType() {
        return this.customType;
    }

    public void setObjectKey(String value) {
        this.objectKey = value;
    }

    public void setResourceName(String value) {
        this.resourceName = value;
    }

    public void setText(String value) {
        this.text = value;
    }

    public void setLanguage(String value) {
        this.language = value;
    }

    public void setCustomType(String value) {
        this.customType = value;
    }

    public String getAttribute() {
        if (this.attribute == null) {
            this.attribute = LocalizationResourceAccessor.getAttributeName(this.resourceName);
        }
        return this.attribute;
    }

    public void setAttribute(String attr) {
        this.attribute = attr;
    }

    public void validateData() throws ServiceException {
        if (this.text == null || "".equals(this.text)) {
            throw new ServiceException("LOCALIZATION_EMPTY_TEXT", (Object[])new String[]{this.getAttribute()});
        }
    }

    public List getPropertyList() {
        return localizationPropInfo;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof LocalizationDataBean) {
            LocalizationDataBean bean = (LocalizationDataBean)obj;
            String key = this.getObjectKey();
            if (key != null) {
                return key.equals(bean.getObjectKey());
            }
        }
        return false;
    }

    static {
        localizationPropInfo.add(PROP_OBJECTKEY);
        localizationPropInfo.add(PROP_RES_NAME);
        localizationPropInfo.add(PROP_ATTRIBUTE);
        localizationPropInfo.add(PROP_TEXT);
        localizationPropInfo.add(PROP_LANGUAGE);
        localizationPropInfo.add(PROP_CUSTOM_TYPE);
    }

    protected static class LocComparator
    implements Comparator {
        protected LocComparator() {
        }

        public int compare(Object o1, Object o2) {
            String attr1 = ((LocalizationDataBean)o1).getAttribute();
            String attr2 = ((LocalizationDataBean)o2).getAttribute();
            if (attr1 != null) {
                return attr1.compareToIgnoreCase(attr2);
            }
            return attr2 == null ? 0 : 1;
        }
    }
}

