/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.localization;

import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.localization.LocalizationDataBean;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.s2x.tools.S2XGUID;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class LocalizationDataAccessor {
    private static DataSource dataSource;
    private static final String JNDI_NAME = "jdbc/notx/SAP/CAF_RT";
    private static final String TABLE_NAME = "CAF_RT_LOCALIZ";
    private static final String DELETE = "delete from CAF_RT_LOCALIZ where \"OBJECTKEY\" = ?";
    private static final String INSERT = "insert into CAF_RT_LOCALIZ (\"OBJECTKEY\", \"RESOURCE_NAME\", \"TEXT\", \"LANG\") values(?, ?, ?, ?)";
    private static final String SELECT_PK = "select \"OBJECTKEY\", \"RESOURCE_NAME\", \"TEXT\", \"LANG\" from CAF_RT_LOCALIZ where \"OBJECTKEY\" = ?";
    private static final String SELECT_RES = "select \"OBJECTKEY\", \"RESOURCE_NAME\", \"TEXT\", \"LANG\" from CAF_RT_LOCALIZ where \"RESOURCE_NAME\" like ? and \"LANG\" = ?";
    private static final String SELECT_LANG = "select \"OBJECTKEY\", \"RESOURCE_NAME\", \"TEXT\", \"LANG\" from CAF_RT_LOCALIZ where \"LANG\" = ?";
    private static final String SELECT_DEF_RES = "select \"OBJECTKEY\", \"RESOURCE_NAME\", \"TEXT\", \"LANG\" from CAF_RT_LOCALIZ where \"RESOURCE_NAME\" like ? and \"LANG\" is null";
    private static final String SELECT_DEF_LANG = "select \"OBJECTKEY\", \"RESOURCE_NAME\", \"TEXT\", \"LANG\" from CAF_RT_LOCALIZ where \"LANG\" is null";
    private static final String UPDATE = "update CAF_RT_LOCALIZ set \"RESOURCE_NAME\" = ?, \"TEXT\" = ?, \"LANG\" = ? where \"OBJECTKEY\" = ?";
    private static Map cacheObject;
    private static Map localeByStringCashe;

    private static Connection getConnection() throws SQLException {
        return LocalizationDataAccessor.getDataSource().getConnection();
    }

    private static DataSource getDataSource() {
        String method = "getDataSource()";
        if (dataSource == null) {
            try {
                InitialContext context = new InitialContext();
                dataSource = (DataSource)context.lookup(JNDI_NAME);
            }
            catch (NamingException e) {
                dataSource = null;
            }
        }
        return dataSource;
    }

    private static PreparedStatement getDeleteStatement(Connection connection) throws SQLException {
        return LocalizationDataAccessor.getStatement(DELETE, connection);
    }

    private static PreparedStatement getInsertStatement(Connection connection) throws SQLException {
        return LocalizationDataAccessor.getStatement(INSERT, connection);
    }

    private static PreparedStatement getSelectPkStatement(Connection connection) throws SQLException {
        return LocalizationDataAccessor.getStatement(SELECT_PK, connection);
    }

    private static PreparedStatement getSelectResStatement(Connection connection) throws SQLException {
        return LocalizationDataAccessor.getStatement(SELECT_RES, connection);
    }

    private static PreparedStatement getSelectDefaultLang(Connection connection) throws SQLException {
        return LocalizationDataAccessor.getStatement(SELECT_DEF_LANG, connection);
    }

    private static PreparedStatement getSelectLanguage(Connection connection) throws SQLException {
        return LocalizationDataAccessor.getStatement(SELECT_LANG, connection);
    }

    private static PreparedStatement getSelectDefaultResources(Connection connection) throws SQLException {
        return LocalizationDataAccessor.getStatement(SELECT_DEF_RES, connection);
    }

    private static PreparedStatement getStatement(String sql, Connection connection) throws SQLException {
        return connection.prepareStatement(sql);
    }

    private static PreparedStatement getUpdateStatement(Connection connection) throws SQLException {
        return LocalizationDataAccessor.getStatement(UPDATE, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createObject(IDataContainerBean bean) throws ServiceException {
        String guid;
        try {
            guid = S2XGUID.getGUID();
            Connection conn = LocalizationDataAccessor.getConnection();
            try {
                PreparedStatement pst = LocalizationDataAccessor.getInsertStatement(conn);
                try {
                    String resName = LocalizationDataAccessor.getProp(bean, "resourceName");
                    pst.setString(1, guid);
                    pst.setString(2, resName);
                    String text = LocalizationDataAccessor.getProp(bean, "text");
                    if (text != null) {
                        text = text.trim();
                    }
                    if ("".equals(text)) {
                        text = null;
                    }
                    pst.setString(3, text);
                    String lang = LocalizationDataAccessor.getProp(bean, "language");
                    pst.setString(4, LocalizationDataAccessor.isEmpty(lang) ? null : lang);
                    pst.execute();
                    String typeName = LocalizationDataAccessor.getProp(bean, "customType");
                }
                finally {
                    pst.close();
                }
            }
            finally {
                conn.close();
            }
            LocalizationDataAccessor.clearCache();
        }
        catch (Exception e) {
            throw new CAFCreateException("BO_CREATE", (Throwable)e);
        }
        bean.setProperty("objectKey", (Object)guid);
        return guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteObject(IDataContainerBean bean) throws ServiceException {
        try {
            Connection conn = LocalizationDataAccessor.getConnection();
            try {
                PreparedStatement pst = LocalizationDataAccessor.getDeleteStatement(conn);
                try {
                    pst.setString(1, LocalizationDataAccessor.getProp(bean, "objectKey"));
                    pst.execute();
                }
                finally {
                    pst.close();
                }
            }
            finally {
                conn.close();
            }
            LocalizationDataAccessor.clearCache();
            String string = LocalizationDataAccessor.getProp(bean, "customType");
        }
        catch (Exception e) {
            throw new CAFDeleteException("BO_DELETE", (Throwable)e);
        }
    }

    public static String getTypeName(String resName) throws ServiceException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalizationDataBean selectObjectByPk(String pk) throws ServiceException {
        try {
            Connection conn = LocalizationDataAccessor.getConnection();
            try {
                PreparedStatement pst = LocalizationDataAccessor.getSelectPkStatement(conn);
                try {
                    pst.setString(1, pk);
                    ResultSet rs = pst.executeQuery();
                    try {
                        if (!rs.next()) throw new CAFRetrieveException("BO_READ");
                        String resName = rs.getString(1);
                        String resText = rs.getString(3);
                        if (resText == null) {
                            resText = "";
                        }
                        LocalizationDataBean dataBean = new LocalizationDataBean(resName, rs.getString(2), resText, rs.getString(4), LocalizationDataAccessor.getTypeName(resName));
                        if (rs.next()) {
                            throw new RuntimeException("Primary key (OBJECTKEY) " + pk + " is not unique in " + TABLE_NAME);
                        }
                        LocalizationDataBean localizationDataBean = dataBean;
                        return localizationDataBean;
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    pst.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
    }

    public static Collection selectObjectByResName(String resName, String locale) throws ServiceException {
        return LocalizationDataAccessor.selectObjectByResName(resName, locale, false);
    }

    static Locale getLocaleByStringCode(String locale) {
        Locale localeObj = (Locale)localeByStringCashe.get(locale);
        if (localeObj == null) {
            String[] values = new String[]{"", "", ""};
            int i = 0;
            StringTokenizer st = new StringTokenizer(locale, "_", false);
            while (st.hasMoreTokens()) {
                values[i] = st.nextToken();
                ++i;
            }
            localeObj = new Locale(values[0], values[1], values[2]);
            localeByStringCashe.put(locale, localeObj);
        }
        return localeObj;
    }

    /*
     * Exception decompiling
     */
    private static Map readEntireLocale(String locale) throws SQLException, ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized Collection selectObjectByResName(String resName, String locale, boolean generalizeLocale) throws ServiceException {
        HashMap<String, LocalizationDataBean> result = new HashMap<String, LocalizationDataBean>(10);
        try {
            ArrayList<String> localeNames = null;
            if (generalizeLocale) {
                localeNames = LocalizationDataAccessor.calculateLocaleNames(LocalizationDataAccessor.getLocaleByStringCode(locale));
            } else {
                localeNames = new ArrayList<String>(1);
                localeNames.add(locale);
            }
            int size = localeNames.size();
            boolean likeCriteria = resName != null && resName.endsWith("@");
            for (int i = 0; i < size; ++i) {
                String loc = (String)localeNames.get(i);
                Map resourceSet = (Map)cacheObject.get(loc);
                if (resourceSet == null) {
                    resourceSet = LocalizationDataAccessor.readEntireLocale(loc);
                    cacheObject.put(loc, resourceSet);
                }
                Iterator j = resourceSet.entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry entry = j.next();
                    String entryKey = (String)entry.getKey();
                    boolean found = likeCriteria ? entryKey.startsWith(resName) : entryKey.equals(resName);
                    if (!found) continue;
                    LocalizationDataBean ldc = new LocalizationDataBean((LocalizationDataBean)entry.getValue());
                    result.put(ldc.getResourceName(), ldc);
                }
            }
        }
        catch (Exception e) {
            throw new CAFFindException("BO_READ", (Throwable)e);
        }
        return result.values();
    }

    protected static List calculateLocaleNames(Locale locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        result.add(null);
        result.add(language);
        if (languageLength > 0 && countryLength > 0) {
            result.add(language + "_" + country);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateObject(IDataContainerBean bean) throws ServiceException {
        try {
            Connection conn = LocalizationDataAccessor.getConnection();
            try {
                PreparedStatement pst = LocalizationDataAccessor.getUpdateStatement(conn);
                try {
                    String resName = LocalizationDataAccessor.getProp(bean, "resourceName");
                    pst.setString(1, resName);
                    String text = LocalizationDataAccessor.getProp(bean, "text");
                    if (text != null) {
                        text = text.trim();
                    }
                    if ("".equals(text)) {
                        text = null;
                    }
                    pst.setString(2, text);
                    String lang = LocalizationDataAccessor.getProp(bean, "language");
                    pst.setString(3, LocalizationDataAccessor.isEmpty(lang) ? null : lang);
                    pst.setString(4, LocalizationDataAccessor.getProp(bean, "objectKey"));
                    pst.execute();
                    String typeName = LocalizationDataAccessor.getProp(bean, "customType");
                }
                finally {
                    pst.close();
                }
            }
            finally {
                conn.close();
            }
            LocalizationDataAccessor.clearCache();
        }
        catch (Exception e) {
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
    }

    private static String getProp(IDataContainerBean bean, String propName) {
        Object o = bean.getProperty(propName);
        return o == null ? null : o.toString();
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void clearCache() {
        cacheObject.clear();
    }

    static {
        cacheObject = new LinkedHashMap(129);
        localeByStringCashe = new HashMap();
    }
}

