/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases;

import com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases.DBPoolAliasWizard;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ProjectListPage
extends WizardPage {
    private static final String TITLE = "Select Project";
    private static final String DESCRIPTION = "This page lists all open Enterprise Application projects, which do not yet contain a Datasource Alias. Select the project for which you want to create a Datasource Alias";
    private ArrayList _projectList;
    private List _projectsCombo;

    public ProjectListPage() {
        super(TITLE);
        this.setTitle(TITLE);
        this.setMessage(DESCRIPTION);
        this.setPageComplete(false);
        this.determineProjectList();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        Label name = new Label(container, 0);
        name.setText("Alias Name");
        this._projectsCombo = new List(container, 2080);
        this._projectsCombo.addSelectionListener((SelectionListener)new ProjectSelectionListener());
        GridData data = new GridData(0);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        this._projectsCombo.setLayoutData((Object)data);
        int i = 0;
        while (i < this._projectList.size()) {
            IProject nextProject = (IProject)this._projectList.get(i);
            this._projectsCombo.add(nextProject.getName());
            ++i;
        }
        this.setControl((Control)container);
    }

    private void determineProjectList() {
        this._projectList = new ArrayList();
        IEarProject[] j2eeProject = J2eeProjectManager.getEarProjects();
        int i = 0;
        while (i < j2eeProject.length) {
            boolean projectDoesNotContainDSAlias;
            IProject project = j2eeProject[i].getProject();
            IFile file = project.getFile("META-INF/data-source-aliases.xml");
            boolean bl = projectDoesNotContainDSAlias = file == null || !file.exists();
            if (projectDoesNotContainDSAlias) {
                this._projectList.add(project);
            }
            ++i;
        }
    }

    private class ProjectSelectionListener
    implements SelectionListener {
        private ProjectSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ProjectListPage.this.setPageComplete(ProjectListPage.this._projectsCombo.getSelectionCount() == 1);
            if (ProjectListPage.this.isPageComplete()) {
                ((DBPoolAliasWizard)ProjectListPage.this.getWizard()).setProject((IProject)ProjectListPage.this._projectList.get(ProjectListPage.this._projectsCombo.getSelectionIndex()));
            }
        }
    }
}

