/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases;

import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.eclipse.j2ee.model.ui.common.dialog.StringLabelProvider;
import com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases.DBPoolAliasWizard;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.NameCharacteristic;
import com.sap.lcr.namealloc.api.AllocationState;
import com.tssap.j2ee.model.ext.SapDSAliasesSemanticChecker;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import javax.naming.CompoundName;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DBPoolAliasWizardPage
extends WizardPage {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$wizards$sapdsaliases$DBPoolAliasWizardPage == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$wizards$sapdsaliases$DBPoolAliasWizardPage = DBPoolAliasWizardPage.class$("com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases.DBPoolAliasWizardPage")) : class$com$sap$ide$eclipse$j2ee$model$ui$wizards$sapdsaliases$DBPoolAliasWizardPage));
    private static final String TITLE = "Datasource alias name";
    private static final String DESCRIPTION = "The alias name must only contain the following characters: upper case letter, digit, slash and underscore. It must contain at most 32 characters.";
    private static final String TITLE_ONLY_TESTAPP = "Only alias for test application";
    private static final String ERROR_NOPREFIXES_AVAILABLE = "No prefixes are defined on the Nameserver of this Development Component project. This means that you can only make aliases for test applications.";
    private static final String ERROR_NO_NAMESERVER_CONNECTION = "No connection can be established to the Nameserver of this Development Component project. This means that you can only make aliases for test applications.";
    public static final String TESTAPPLICATION_ALIAS_NAME = "TMP/TEST";
    private boolean _isValidName;
    private boolean _dcProject;
    private NameAllocator _nameAllocator;
    private boolean _testApplication;
    private IProject _project;
    private Label _projectLabel;
    private Label _projectNameLabel;
    private Group _nameGroup;
    private Text _nameText;
    private Button _nameSelectionButton;
    private Group _prefixGroup;
    private Combo _prefixCombo;
    private Group _appTypeGroup;
    private Button _productiveApplicationRadio;
    private Button _testApplicationRadio;
    private boolean _inNameModifyEvent;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$wizards$sapdsaliases$DBPoolAliasWizardPage;

    public DBPoolAliasWizardPage() {
        super(TITLE);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setPageComplete(false);
        this._isValidName = false;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        this._projectLabel = new Label(container, 0);
        this._projectLabel.setText("Project Name");
        this._projectNameLabel = new Label(container, 2048);
        this._projectNameLabel.setText("Project");
        GridData data = new GridData(0);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._projectNameLabel.setLayoutData((Object)data);
        this._appTypeGroup = new Group(container, 0);
        this._appTypeGroup.setText("Application Type");
        data = new GridData(0);
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._appTypeGroup.setLayoutData((Object)data);
        layout = new GridLayout(2, true);
        this._appTypeGroup.setLayout((Layout)layout);
        ApplicationTypeRadioListener appTypeRadiolistener = new ApplicationTypeRadioListener();
        this._testApplicationRadio = new Button((Composite)this._appTypeGroup, 16);
        this._testApplicationRadio.setText("Test Application");
        this._testApplicationRadio.addSelectionListener((SelectionListener)appTypeRadiolistener);
        this._testApplicationRadio.setSelection(true);
        this._productiveApplicationRadio = new Button((Composite)this._appTypeGroup, 16);
        this._productiveApplicationRadio.setText("Productive Application");
        this._productiveApplicationRadio.addSelectionListener((SelectionListener)appTypeRadiolistener);
        this._productiveApplicationRadio.setSelection(false);
        this._prefixGroup = new Group(container, 0);
        this._prefixGroup.setText("Name prefix");
        data = new GridData(0);
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._prefixGroup.setLayoutData((Object)data);
        layout = new GridLayout(3, false);
        this._prefixGroup.setLayout((Layout)layout);
        this._prefixCombo = new Combo((Composite)this._prefixGroup, 8);
        data = new GridData(0);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        this._prefixCombo.setLayoutData((Object)data);
        this._prefixCombo.addModifyListener((ModifyListener)new PrefixModifyListener());
        this._nameSelectionButton = new Button((Composite)this._prefixGroup, 8);
        this._nameSelectionButton.setText("Browse alias names");
        this._nameSelectionButton.addSelectionListener((SelectionListener)new BrowseNameserverSelectionListener());
        this._nameGroup = new Group(container, 0);
        this._nameGroup.setText("Alias Name");
        data = new GridData(0);
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._nameGroup.setLayoutData((Object)data);
        layout = new GridLayout(1, false);
        this._nameGroup.setLayout((Layout)layout);
        this._nameText = new Text((Composite)this._nameGroup, 2048);
        data = new GridData(0);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this._nameText.setLayoutData((Object)data);
        this._nameText.addModifyListener((ModifyListener)new NameModifyListener());
        container.pack(true);
        parent.pack(true);
        this.setControl((Control)container);
        this.displayProjectData();
    }

    public boolean isPageComplete() {
        if (this.isCurrentPage()) {
            if (this.getAliasName().equals("")) {
                return false;
            }
            return this._isValidName;
        }
        return false;
    }

    public void setProject(IProject project) {
        if (project != null) {
            this._project = project;
            this._dcProject = DBPoolAliasWizard.isCentralDCProject(this._project);
            this.initNameserverConnection();
            this.displayProjectData();
        }
    }

    private void displayProjectData() {
        String METHOD = "displayProjectData()";
        if (this._project == null || this._projectNameLabel == null) {
            return;
        }
        this._projectNameLabel.setText(this._project.getName());
        this._appTypeGroup.setVisible(this._dcProject);
        this._prefixGroup.setVisible(this._dcProject);
        this._prefixCombo.setVisible(this._dcProject);
        this._testApplicationRadio.setVisible(this._dcProject);
        this._nameSelectionButton.setVisible(this._dcProject);
        this._nameText.setEditable(true);
        if (this._dcProject) {
            if (this._nameAllocator != null) {
                try {
                    CompoundName[] names = this._nameAllocator.listAllowedPrefixes("SAP_DBPoolName", true);
                    if (names.length == 0) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE_ONLY_TESTAPP, (String)ERROR_NOPREFIXES_AVAILABLE);
                    } else {
                        this._prefixCombo.removeAll();
                        int i = 0;
                        while (i < names.length) {
                            CompoundName name = names[i];
                            this._prefixCombo.add(name.toString());
                            ++i;
                        }
                        if (this._prefixCombo.getItemCount() > 0) {
                            this._prefixCombo.select(0);
                        }
                    }
                }
                catch (Exception e) {
                    TRACER.error("displayProjectData()", "Error when communicating with Nameserver: " + e.toString(), (Throwable)e);
                }
            } else {
                this._prefixCombo.removeAll();
                this._testApplicationRadio.setSelection(true);
                this._productiveApplicationRadio.setSelection(false);
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE_ONLY_TESTAPP, (String)ERROR_NO_NAMESERVER_CONNECTION);
            }
            this._productiveApplicationRadio.setEnabled(this._prefixCombo.getItemCount() > 0);
            this.applicationTypeChanged();
        }
    }

    public String getFullAliasName() {
        String fullAliasName = this.getAliasName();
        String prefix = this.getPrefix();
        if (prefix != null) {
            fullAliasName = prefix + this.getAliasName();
        }
        return fullAliasName;
    }

    private boolean validate() {
        char[] chars;
        String errorMessage = null;
        String name = this.getFullAliasName();
        this._isValidName = name != null || name.length() != 0 ? (errorMessage = SapDSAliasesSemanticChecker.validateAliasName((char[])(chars = name.toCharArray()))) == null : false;
        this.setErrorMessage(errorMessage);
        this.setPageComplete(this._isValidName);
        return this._isValidName;
    }

    private String getAliasName() {
        return this._nameText.getText();
    }

    private void initNameserverConnection() {
        String METHOD = "initNameserverConnection()";
        if (this._dcProject) {
            try {
                this._nameAllocator = NameServerUtil.getNameAllocator((IProject)this._project);
            }
            catch (Exception e) {
                TRACER.error("initNameserverConnection()", "Error when communicating with Nameserver: " + e.toString(), (Throwable)e);
            }
        }
    }

    private String getPrefix() {
        if (this._prefixCombo.isVisible()) {
            String prefix = this._prefixCombo.getText();
            while (prefix.endsWith("*")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            return prefix;
        }
        return null;
    }

    private void applicationTypeChanged() {
        this._testApplication = this._testApplicationRadio.getSelection();
        if (this._testApplication) {
            this._nameText.setText(TESTAPPLICATION_ALIAS_NAME);
            this._nameText.setEditable(false);
            this._prefixGroup.setVisible(false);
            this._prefixCombo.setVisible(false);
        } else {
            this._nameText.setText("");
            this._nameText.setEditable(true);
            boolean connectionActive = this._nameAllocator != null;
            boolean hasPrefixes = this._prefixCombo.getItemCount() > 0;
            boolean enabled = connectionActive && hasPrefixes;
            this._prefixGroup.setVisible(enabled);
            this._prefixCombo.setVisible(enabled);
        }
        this._nameSelectionButton.setVisible(this._prefixCombo.isVisible());
    }

    public void openNameSelectionDialog() {
        String METHOD = "openNameSelectionDialog()";
        String prefix = this.getPrefix();
        try {
            NameCharacteristic nameCharacteristic = this._nameAllocator.getNameCharacteristic("SAP_DBPoolName");
            CompoundName compoundName = this._nameAllocator.getMyNameServerUtil().createCompoundNameFromString(prefix + "*", nameCharacteristic);
            AllocationState[] states = this._nameAllocator.listReservations(null, "SAP_DBPoolName", compoundName, true, false);
            Object[] names = new String[states.length];
            int i = 0;
            while (i < states.length) {
                String name = states[i].getFlatName();
                if (name.startsWith(prefix)) {
                    names[i] = name.substring(prefix.length());
                }
                ++i;
            }
            ObjectSelectionDialog selectionDialog = new ObjectSelectionDialog(this.getShell(), "Choose alias-name", "Choose one of the alias-names, which are already defined for the prefix " + this.getPrefix());
            selectionDialog.setSingleSelection(true);
            selectionDialog.setLabelProvider((ILabelProvider)new StringLabelProvider(null));
            Object[] selectedObject = selectionDialog.openDialog(names);
            if (selectedObject != null && selectedObject.length != 0) {
                String selectedName = selectedObject[0].toString();
                this._nameText.setText(selectedName);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Can not get the available names for the prefix " + prefix + " from the nameserver. Details: " + e.toString()));
            TRACER.error("openNameSelectionDialog()", "Can not get the available names for the prefix " + prefix + " from the nameserver. Details: " + e.toString(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BrowseNameserverSelectionListener
    implements SelectionListener {
        private BrowseNameserverSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            DBPoolAliasWizardPage.this.openNameSelectionDialog();
        }
    }

    private class ApplicationTypeRadioListener
    implements SelectionListener {
        private ApplicationTypeRadioListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            DBPoolAliasWizardPage.this.applicationTypeChanged();
        }
    }

    private class PrefixModifyListener
    implements ModifyListener {
        private PrefixModifyListener() {
        }

        public void modifyText(ModifyEvent arg0) {
            DBPoolAliasWizardPage.this.validate();
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!DBPoolAliasWizardPage.this._inNameModifyEvent) {
                try {
                    DBPoolAliasWizardPage.this._inNameModifyEvent = true;
                    int pos = DBPoolAliasWizardPage.this._nameText.getCaretPosition();
                    DBPoolAliasWizardPage.this._nameText.setText(DBPoolAliasWizardPage.this._nameText.getText().trim().toUpperCase());
                    DBPoolAliasWizardPage.this._nameText.setSelection(pos);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    DBPoolAliasWizardPage.this._inNameModifyEvent = false;
                    throw throwable;
                }
                DBPoolAliasWizardPage.this._inNameModifyEvent = false;
                {
                }
            }
            DBPoolAliasWizardPage.this.validate();
        }
    }
}

