/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases;

import com.sap.ide.eclipse.component.core.DCProject;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.eclipse.j2ee.model.ui.J2EEModelDescriptorFactory;
import com.sap.ide.eclipse.j2ee.model.ui.J2EEModelUIPlugin;
import com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases.DBPoolAliasWizardPage;
import com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases.DBPoolPropertySetter;
import com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases.ProjectListPage;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ext.XMLParserHelper;
import com.tssap.j2ee.model.ext.dsaliases.dd.IAlias;
import com.tssap.j2ee.model.ext.dsaliases.dd.IAliases;
import com.tssap.j2ee.model.ext.dsaliases.dd.IDataSourceAliases;
import com.tssap.j2ee.model.ext.dsaliases.dd.impl.dom.DataSourceAliases;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;

public class DBPoolAliasWizard
extends Wizard
implements INewWizard {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$wizards$sapdsaliases$DBPoolAliasWizard == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$wizards$sapdsaliases$DBPoolAliasWizard = DBPoolAliasWizard.class$("com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases.DBPoolAliasWizard")) : class$com$sap$ide$eclipse$j2ee$model$ui$wizards$sapdsaliases$DBPoolAliasWizard));
    private IProject _project;
    private DBPoolAliasWizardPage _mainWizardPage;
    private NameAllocator _nameAllocator;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$wizards$sapdsaliases$DBPoolAliasWizard;

    public DBPoolAliasWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public DBPoolAliasWizard(IProject project) {
        this();
        this._project = project;
    }

    public boolean performFinish() {
        try {
            IFile file;
            IEarProject earProject;
            if (DBPoolAliasWizard.isCentralDCProject(this._project) && !this.checkNameReservation()) {
                return false;
            }
            if (this._project == null) {
                this.throwCoreException("Can not create file META-INF/data-source-aliases.xml, because no project is defined");
            }
            if ((earProject = J2eeProjectManager.getEarProject((String)this._project.getName())) == null) {
                this.throwCoreException("Can not create file META-INF/data-source-aliases.xml, because the project " + this._project.getName() + " is not an Enterprise Application project.");
            }
            J2EEModelDescriptorFactory.copyTemplate((IJ2eeProject)earProject, "META-INF/data-source-aliases.xml");
            String aliasName = this._mainWizardPage.getFullAliasName();
            IDataSourceAliases dataSourceAliases = XMLParserHelper.getDataSourceAliasesForProject((IProject)this._project);
            if (dataSourceAliases != null) {
                IAliases[] aliases = dataSourceAliases.getAliasess();
                int i = 0;
                while (i < aliases.length) {
                    IAlias[] alias = aliases[i].getAliass();
                    int k = 0;
                    while (k < alias.length) {
                        alias[k].setValue(aliasName);
                        ++k;
                    }
                    ++i;
                }
            }
            if ((file = this._project.getFile("META-INF/data-source-aliases.xml")) != null && file.exists()) {
                Document document = ((DataSourceAliases)dataSourceAliases).getUnderlyingDocument();
                XMLParserHelper.setDomAsContent((Document)document, (IFile)file);
            }
            J2EEModelDescriptorFactory.openEditor((IJ2eeProject)earProject, "META-INF/data-source-aliases.xml");
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
            return false;
        }
        return true;
    }

    public void addPages() {
        if (this._project == null) {
            ProjectListPage projectsPage = new ProjectListPage();
            this.addPage((IWizardPage)projectsPage);
            this._mainWizardPage = new DBPoolAliasWizardPage();
            this.addPage((IWizardPage)this._mainWizardPage);
        } else {
            this._mainWizardPage = new DBPoolAliasWizardPage();
            this._mainWizardPage.setProject(this._project);
            this.getShell().setSize(630, 450);
            try {
                Rectangle rect = this.getContainer().getShell().getParent().getBounds();
                int x = (rect.width - this.getContainer().getShell().getBounds().width) / 2;
                int y = (rect.height - this.getContainer().getShell().getBounds().height) / 2;
                rect = this.getContainer().getShell().getBounds();
                rect.x = x;
                rect.y = y;
                this.getContainer().getShell().setBounds(rect);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.addPage((IWizardPage)this._mainWizardPage);
                throw throwable;
            }
            this.addPage((IWizardPage)this._mainWizardPage);
            {
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New Datasource Alias");
    }

    public boolean canFinish() {
        return this._mainWizardPage.isPageComplete();
    }

    public Image getDefaultPageImage() {
        return J2EEModelUIPlugin.getImage("wizard/SapDSAliasesWizard.gif");
    }

    public void setProject(IProject project) {
        this._project = project;
        this._mainWizardPage.setProject(this._project);
    }

    public static boolean isCentralDCProject(IProject project) {
        boolean dcProject;
        String METHOD = "isDCProject(IProject)";
        if (project == null) {
            return false;
        }
        IJ2eeProject j2eeProject = J2eeProjectManager.getJ2eeProject((String)project.getName());
        boolean bl = dcProject = j2eeProject == null ? false : J2eeProjectManager.isComponentProject((IJ2eeProject)j2eeProject);
        if (dcProject) {
            try {
                IProjectNature nature = project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
                DCProject casted = (DCProject)nature;
                return !casted.isLocal();
            }
            catch (CoreException e) {
                TRACER.error(METHOD, "Can not determine if DC-Project is a Local-DC-Project. As a fallback, the assumption is that it is not a Local-DC-Project. Error-Details: " + e.toString(), (Throwable)e);
                return true;
            }
        }
        return dcProject;
    }

    private boolean checkNameReservation() throws MalformedURLException, CommunicationFailureException {
        String name = this._mainWizardPage.getFullAliasName();
        this._nameAllocator = NameServerUtil.getNameAllocator((IProject)this._project);
        if (DBPoolPropertySetter.checkNameReservation(this._nameAllocator, name)) {
            boolean yes = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Alias name reservation", (String)("The alias name " + name + " is already reserved. However, you can use this alias-name in your application, too. Do you really want to proceed?"));
            return yes;
        }
        if (!name.equals("TMP/TEST")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Alias name reservation", (String)("The alias name " + name + " is not yet reserved. It will be reserved, as soon as you add it to your DTR-activity."));
        }
        return true;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.sap.ide.eclipse.DBPoolAliasWizard", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

