/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapwar.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.tssap.j2ee.model.ext.SapWarSemanticChecker;
import com.tssap.j2ee.model.ext.web.dd.IName;
import com.tssap.j2ee.model.ext.web.dd.IServerComponentRef;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UISapWarServerComponentRef
extends EditableDefaultObjectEditorComponent {
    private static final String[] ALL_TYPES = SapWarSemanticChecker.ALLOWED_REFERENCE_TYPES;
    private Text _nameTextField;
    private Combo _typeComboBox;
    private Text _jndiNameTextField;
    private Text _descriptionTextField;
    private boolean _modifyCallbackActive = true;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, true, true));
        pane.addTextLabel("Application local JNDI name");
        this._nameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Server component type");
        this._typeComboBox = pane.addComboBox(ALL_TYPES, "", true, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Server component JNDI name");
        this._jndiNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Description");
        this._descriptionTextField = pane.addTextPane("", false, true, pane.createGridLayoutData(4, 4, true, true, 2, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this._nameTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this._typeComboBox.addModifyListener(this.getModifyAdapterSingleton());
        this._jndiNameTextField.addModifyListener(this.getModifyAdapterSingleton());
        this._descriptionTextField.addModifyListener(this.getModifyAdapterSingleton());
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getServerComponentRef() != null) {
            this.refreshNameFromUI();
            String value = this._jndiNameTextField.getText();
            this.getServerComponentRef().getJndiName().setValue(value);
            value = this._descriptionTextField.getText();
            this.getServerComponentRef().getDescription().setValue(value);
            value = this._typeComboBox.getText();
            this.getServerComponentRef().getType().setValue(value);
        }
    }

    private void refreshNameFromUI() {
        if (this.getServerComponentRef() != null) {
            IName element = this.getServerComponentRef().getName();
            String value = this._nameTextField.getText();
            element.setValue(value);
            this.setTitle(value);
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this._modifyCallbackActive = false;
            if (this.getServerComponentRef() != null) {
                String name = this.getServerComponentRef().getName().getValue();
                this._nameTextField.setText(name);
                this._typeComboBox.setText(this.getServerComponentRef().getType().getValue());
                this._jndiNameTextField.setText(this.getServerComponentRef().getJndiName().getValue());
                this._descriptionTextField.setText(this.getServerComponentRef().getDescription().getValue());
                this.setTitle(name);
            }
            Object var3_2 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
    }

    private IServerComponentRef getServerComponentRef() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        IServerComponentRef result = null;
        if (value instanceof IServerComponentRef) {
            result = (IServerComponentRef)value;
        }
        return result;
    }

    protected void handleNameModifyEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        this.refreshNameFromUI();
        super.handleEvent();
    }

    protected void handleEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UISapWarServerComponentRef.this.handleNameModifyEvent();
        }
    }
}

