/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapwar.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.dialog.StringChooserDialog;
import com.sap.ide.eclipse.j2ee.model.ui.sapwar.IWebAppHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapwar.IWebJ2eeEngineHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapwar.internal.ReferencesContentProvider;
import com.sap.ide.eclipse.j2ee.model.ui.sapwar.internal.ReferencesLabelProvider;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.SapWarDefaultFactory;
import com.tssap.j2ee.model.ext.web.dd.IEjbRef;
import com.tssap.j2ee.model.ext.web.dd.IResourceRef;
import com.tssap.j2ee.model.ext.web.dd.IServerComponentRef;
import com.tssap.j2ee.model.ext.web.dd.IWebJ2eeEngine;
import com.tssap.j2ee.model.web.dd.IEjbLocalRef;
import com.tssap.j2ee.model.web.dd.IResourceEnvRef;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import java.util.ArrayList;

public class ReferencesAddRemoveCallback
implements IAddRemoveCallback {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$sapwar$internal$ReferencesAddRemoveCallback == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$sapwar$internal$ReferencesAddRemoveCallback = ReferencesAddRemoveCallback.class$("com.sap.ide.eclipse.j2ee.model.ui.sapwar.internal.ReferencesAddRemoveCallback")) : class$com$sap$ide$eclipse$j2ee$model$ui$sapwar$internal$ReferencesAddRemoveCallback));
    private IWebJ2eeEngineHolder _holder;
    private IWebAppHolder _webAppHolder;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$sapwar$internal$ReferencesAddRemoveCallback;

    public ReferencesAddRemoveCallback(IWebAppHolder webAppHolder, IWebJ2eeEngineHolder holder) {
        this._holder = holder;
        this._webAppHolder = webAppHolder;
    }

    public boolean canAddElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        if (parentHolder == null) {
            return false;
        }
        Object value = parentHolder.getValue();
        boolean result = false;
        if (value == ReferencesContentProvider.FOLDER_SERVER_COMPONENT_REF) {
            result = true;
        } else if (value == ReferencesContentProvider.FOLDER_EJB_REF) {
            result = true;
        } else if (value == ReferencesContentProvider.FOLDER_EJB_LOCAL_REF) {
            result = true;
        } else if (value == ReferencesContentProvider.FOLDER_RESOURCE_REF) {
            result = true;
        } else if (value == ReferencesContentProvider.FOLDER_RESOURCE_ENV_REF) {
            result = true;
        }
        return result;
    }

    public Object addElement(Object currentSelection) {
        ParentHolder parentHolder;
        String METHOD = "addElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        if ((parentHolder = (ParentHolder)currentSelection) == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        ParentHolder result = null;
        if (this.getWebJ2eeEngine() != null) {
            if (value == ReferencesContentProvider.FOLDER_SERVER_COMPONENT_REF) {
                try {
                    IServerComponentRef ref = SapWarDefaultFactory.createServerComponentRef((IWebJ2eeEngine)this.getWebJ2eeEngine());
                    result = this.createParentHolder(parentHolder, ref);
                }
                catch (J2eeCreateException e) {
                    TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                }
            }
            if (value == ReferencesContentProvider.FOLDER_EJB_REF) {
                result = this.createParentHolder(parentHolder, this.addEjbRef());
            }
            if (value == ReferencesContentProvider.FOLDER_EJB_LOCAL_REF) {
                result = this.createParentHolder(parentHolder, this.addEjbLocalRef());
            }
            if (value == ReferencesContentProvider.FOLDER_RESOURCE_REF) {
                result = this.createParentHolder(parentHolder, this.addResRef());
            }
            if (value == ReferencesContentProvider.FOLDER_RESOURCE_ENV_REF) {
                result = this.createParentHolder(parentHolder, this.addResEnvRef());
            }
        }
        return result;
    }

    private ParentHolder createParentHolder(ParentHolder parentHolder, Object wrapped) {
        if (wrapped == null) {
            return null;
        }
        return new ParentHolder(parentHolder, wrapped);
    }

    public boolean canRemoveElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        if (parentHolder == null) {
            return false;
        }
        Object value = parentHolder.getValue();
        boolean result = false;
        if (value instanceof IServerComponentRef) {
            result = true;
        }
        if (value instanceof IEjbRef) {
            result = true;
        }
        if (value instanceof com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef) {
            result = true;
        }
        if (value instanceof IResourceRef) {
            result = true;
        }
        if (value instanceof com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef) {
            result = true;
        }
        return result;
    }

    public boolean removeElement(Object currentSelection) {
        ParentHolder parentHolder;
        String METHOD = "removeElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        if ((parentHolder = (ParentHolder)currentSelection) == null) {
            return false;
        }
        Object value = parentHolder.getValue();
        boolean result = false;
        if (this.getWebJ2eeEngine() != null) {
            if (value instanceof IServerComponentRef) {
                this.getWebJ2eeEngine().removeServerComponentRef((IServerComponentRef)value);
                result = true;
            }
            if (value instanceof IEjbRef) {
                this.getWebJ2eeEngine().removeEjbRef((IEjbRef)value);
                result = true;
            }
            if (value instanceof com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef) {
                this.getWebJ2eeEngine().removeEjbLocalRef((com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef)value);
                result = true;
            }
            if (value instanceof IResourceRef) {
                this.getWebJ2eeEngine().removeResourceRef((IResourceRef)value);
                result = true;
            }
            if (value instanceof com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef) {
                this.getWebJ2eeEngine().removeResourceEnvRef((com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef)value);
                result = true;
            }
        }
        return result;
    }

    private IWebJ2eeEngine getWebJ2eeEngine() {
        if (this._holder != null) {
            return this._holder.getWebJ2eeEngine();
        }
        return null;
    }

    private IWebApp getWebApp() {
        return this._webAppHolder.getWebApp();
    }

    private IEjbRef addEjbRef() {
        IWebApp webApp = this.getWebApp();
        IWebJ2eeEngine webJ2eeEngine = this.getWebJ2eeEngine();
        if (webApp != null && webJ2eeEngine != null) {
            IEjbRef[] destEjbRef = webJ2eeEngine.getEjbRefs();
            com.tssap.j2ee.model.web.dd.IEjbRef[] sourceEjbRef = webApp.getEjbRefs();
            ArrayList<String> destList = new ArrayList<String>();
            int i = 0;
            while (i < destEjbRef.length) {
                destList.add(destEjbRef[i].getEjbRefName().getValue());
                ++i;
            }
            String[] destNames = new String[destList.size()];
            destList.toArray(destNames);
            ArrayList<String> sourceList = new ArrayList<String>();
            int i2 = 0;
            while (i2 < sourceEjbRef.length) {
                sourceList.add(sourceEjbRef[i2].getEjbRefName().getValue());
                ++i2;
            }
            String[] sourceNames = new String[sourceList.size()];
            sourceList.toArray(sourceNames);
            String[] result = StringChooserDialog.openDialog(sourceNames, destNames, ReferencesLabelProvider.IMAGE_EJB_REF, "ejb-refs", "web.xml");
            IEjbRef ejbRef = this.handleEjbSelection(webJ2eeEngine, destNames, result);
            return ejbRef;
        }
        return null;
    }

    private IEjbRef handleEjbSelection(IWebJ2eeEngine webJ2eeEngine, String[] before, String[] added) {
        String METHOD = "handleSelection()";
        IEjbRef ref = null;
        if (added == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < added.length) {
                ref = SapWarDefaultFactory.createEjbRef((IWebJ2eeEngine)webJ2eeEngine, (String)added[i]);
                ++i;
            }
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Can not create element: " + e.toString(), (Throwable)e);
        }
        return ref;
    }

    private com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef addEjbLocalRef() {
        IWebApp webApp = this.getWebApp();
        IWebJ2eeEngine webJ2eeEngine = this.getWebJ2eeEngine();
        if (webApp != null && webJ2eeEngine != null) {
            com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef[] destEjbLocalRef = webJ2eeEngine.getEjbLocalRefs();
            IEjbLocalRef[] sourceEjbLocalRef = webApp.getEjbLocalRefs();
            ArrayList<String> destList = new ArrayList<String>();
            int i = 0;
            while (i < destEjbLocalRef.length) {
                destList.add(destEjbLocalRef[i].getEjbRefName().getValue());
                ++i;
            }
            String[] destNames = new String[destList.size()];
            destList.toArray(destNames);
            ArrayList<String> sourceList = new ArrayList<String>();
            int i2 = 0;
            while (i2 < sourceEjbLocalRef.length) {
                sourceList.add(sourceEjbLocalRef[i2].getEjbRefName().getValue());
                ++i2;
            }
            String[] sourceNames = new String[sourceList.size()];
            sourceList.toArray(sourceNames);
            String[] result = StringChooserDialog.openDialog(sourceNames, destNames, ReferencesLabelProvider.IMAGE_EJB_LOCAL_REF, "ejb-local-refs", "web.xml");
            com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef ejbLocalRef = this.handleEjbLocalSelection(webJ2eeEngine, destNames, result);
            return ejbLocalRef;
        }
        return null;
    }

    private com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef handleEjbLocalSelection(IWebJ2eeEngine webJ2eeEngine, String[] before, String[] added) {
        String METHOD = "handleSelection()";
        com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef localRef = null;
        if (added == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < added.length) {
                localRef = SapWarDefaultFactory.createEjbLocalRef((IWebJ2eeEngine)webJ2eeEngine, (String)added[i]);
                ++i;
            }
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Can not create element: " + e.toString(), (Throwable)e);
        }
        return localRef;
    }

    private IResourceRef addResRef() {
        IWebApp webApp = this.getWebApp();
        IWebJ2eeEngine webJ2eeEngine = this.getWebJ2eeEngine();
        if (webApp != null && webJ2eeEngine != null) {
            IResourceRef[] destResourceRef = webJ2eeEngine.getResourceRefs();
            com.tssap.j2ee.model.web.dd.IResourceRef[] sourceResourceRef = webApp.getResourceRefs();
            ArrayList<String> destList = new ArrayList<String>();
            int i = 0;
            while (i < destResourceRef.length) {
                destList.add(destResourceRef[i].getResRefName().getValue());
                ++i;
            }
            String[] destNames = new String[destList.size()];
            destList.toArray(destNames);
            ArrayList<String> sourceList = new ArrayList<String>();
            int i2 = 0;
            while (i2 < sourceResourceRef.length) {
                sourceList.add(sourceResourceRef[i2].getResRefName().getValue());
                ++i2;
            }
            String[] sourceNames = new String[sourceList.size()];
            sourceList.toArray(sourceNames);
            String[] result = StringChooserDialog.openDialog(sourceNames, destNames, ReferencesLabelProvider.IMAGE_RESOURCE_REF, "resource-refs", "web.xml");
            IResourceRef resRef = this.handleResRefSelection(webJ2eeEngine, destNames, result);
            return resRef;
        }
        return null;
    }

    private IResourceRef handleResRefSelection(IWebJ2eeEngine webJ2eeEngine, String[] before, String[] added) {
        String METHOD = "handleSelection()";
        IResourceRef resRef = null;
        if (added == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < added.length) {
                resRef = SapWarDefaultFactory.createResourceRef((IWebJ2eeEngine)webJ2eeEngine, (String)added[i]);
                ++i;
            }
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Can not create element: " + e.toString(), (Throwable)e);
        }
        return resRef;
    }

    private com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef addResEnvRef() {
        IWebApp webApp = this.getWebApp();
        IWebJ2eeEngine webJ2eeEngine = this.getWebJ2eeEngine();
        if (webApp != null && webJ2eeEngine != null) {
            com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef[] destResourceEnvRef = webJ2eeEngine.getResourceEnvRefs();
            IResourceEnvRef[] sourceResourceEnvRef = webApp.getResourceEnvRefs();
            ArrayList<String> destList = new ArrayList<String>();
            int i = 0;
            while (i < destResourceEnvRef.length) {
                destList.add(destResourceEnvRef[i].getResourceEnvRefName().getValue());
                ++i;
            }
            String[] destNames = new String[destList.size()];
            destList.toArray(destNames);
            ArrayList<String> sourceList = new ArrayList<String>();
            int i2 = 0;
            while (i2 < sourceResourceEnvRef.length) {
                sourceList.add(sourceResourceEnvRef[i2].getResourceEnvRefName().getValue());
                ++i2;
            }
            String[] sourceNames = new String[sourceList.size()];
            sourceList.toArray(sourceNames);
            String[] result = StringChooserDialog.openDialog(sourceNames, destNames, ReferencesLabelProvider.IMAGE_RESOURCE_ENV_REF, "resource-env-refs", "web.xml");
            com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef envRef = this.handleEnvRefSelection(webJ2eeEngine, destNames, result);
            return envRef;
        }
        return null;
    }

    private com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef handleEnvRefSelection(IWebJ2eeEngine webJ2eeEngine, String[] before, String[] added) {
        String METHOD = "handleSelection()";
        com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef envRef = null;
        if (added == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < added.length) {
                envRef = SapWarDefaultFactory.createResourceEnvRef((IWebJ2eeEngine)webJ2eeEngine, (String)added[i]);
                ++i;
            }
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Can not create element: " + e.toString(), (Throwable)e);
        }
        return envRef;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

