/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapsda.internal;

import com.sap.ide.eclipse.component.core.DCProject;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.j2ee.model.ui.IProjectHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapsda.ISDAHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapsda.ISapSDAEditor;
import com.sap.ide.eclipse.j2ee.model.ui.sapsda.internal.SapSDAEditorPage;
import com.sap.tc.complib.ComponentType;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ext.sda.dd.ISoftwareType;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SapSDAGeneralPage
extends SapSDAEditorPage
implements IModifiedCallback,
ISDAHolder {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$sapsda$internal$SapSDAGeneralPage == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$sapsda$internal$SapSDAGeneralPage = SapSDAGeneralPage.class$("com.sap.ide.eclipse.j2ee.model.ui.sapsda.internal.SapSDAGeneralPage")) : class$com$sap$ide$eclipse$j2ee$model$ui$sapsda$internal$SapSDAGeneralPage));
    public static final String DC_TYPE = "J2EE Server Component";
    public static final String DC_SUBTYPE_INTERFACE = "Interface";
    public static final String[] LIBRARY_SOFTWARE_TYPES = new String[]{"library", "primary-library"};
    public static final String[] INTERFACE_SOFTWARE_TYPES = new String[]{"primary-interface"};
    public static final String[] SERVICE_SOFTWARE_TYPES = new String[]{"primary-service"};
    private boolean _isModListenerActive = false;
    private IProjectHolder _projectHolder;
    private Combo _softwareTypeCombo;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$sapsda$internal$SapSDAGeneralPage;

    public SapSDAGeneralPage(Composite parent, ISapSDAEditor editor, IProjectHolder projectHolder) {
        super(parent, editor, 1);
        this._projectHolder = projectHolder;
    }

    public String getPageName() {
        return "General";
    }

    public Control createControls(IGridLayoutPane grid) {
        IGridLayoutPane pane = grid.addGridLayoutPane(2, false, grid.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Software type");
        this._softwareTypeCombo = pane.addComboBox(new String[0], "", true, pane.createGridLayoutData(4, 4, true, true, 1, 1));
        return grid.getComposite();
    }

    protected void decorateControls() {
        this._softwareTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SapSDAGeneralPage.this.dataModified(true);
            }
        });
    }

    protected void initControlsWithData() {
        try {
            this._isModListenerActive = false;
            this.initCombo();
            ISoftwareType softwareType = this.getSDA().getSoftwareType();
            this._softwareTypeCombo.setText(softwareType.getValue());
            Object var3_2 = null;
            this._isModListenerActive = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._isModListenerActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
    }

    protected void updateDataFromControls() {
        String METHOD = "updateDataFromControls()";
        if (TRACER.debug()) {
            TRACER.debug(METHOD, "");
        }
        String value = this._softwareTypeCombo.getText();
        ISoftwareType softwareType = this.getSDA().getSoftwareType();
        softwareType.setValue(value);
    }

    private void initCombo() {
        String[] softwareTypes = this.isServiceProject() ? SERVICE_SOFTWARE_TYPES : (this.isInterfaceProject() ? INTERFACE_SOFTWARE_TYPES : LIBRARY_SOFTWARE_TYPES);
        this._softwareTypeCombo.setItems(softwareTypes);
    }

    private boolean isServiceProject() {
        return J2eeProjectManager.getServiceProject((String)this._projectHolder.getProject().getName()) != null;
    }

    private boolean isInterfaceProject() {
        DCProject dcProject = DCProjectUtil.getDCProject((IProject)this._projectHolder.getProject());
        if (dcProject != null) {
            try {
                ComponentType type = dcProject.getDCNode().getDevelopmentComponent(false).getComponentType();
                if (type.getType().equals(DC_TYPE) && type.getSubType().equals(DC_SUBTYPE_INTERFACE)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void dataModified(boolean modified) {
        if (this._isModListenerActive) {
            this.getEditor().setDirtyFlag(modified);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

