/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplog.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.tssap.j2ee.model.ext.log.dd.ILogFormatter;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UISapLogFormatter
extends EditableDefaultObjectEditorComponent {
    private static final String[] LOG_FORMATTER_TYPES = new String[]{"ListFormatter", "TraceFormatter", "XMLFormatter"};
    private Text formNameTextField;
    private Text patternTextField;
    private Combo formatterTypeTextField;
    private boolean modifyCallbackActive = true;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Log Formatter Name");
        this.formNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Log Formatter Pattern");
        this.patternTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Reference target type");
        this.formatterTypeTextField = pane.addComboBox(LOG_FORMATTER_TYPES, "", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this.formNameTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.patternTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.formatterTypeTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getLogFormatter() != null) {
            this.refreshFormatterFromUI();
        }
    }

    private void refreshFormatterFromUI() {
        if (this.getLogFormatter() != null) {
            String value = this.formNameTextField.getText();
            this.getLogFormatter().setAttribName(value);
            this.setTitle(value);
            value = this.formatterTypeTextField.getText();
            this.getLogFormatter().setAttribType(value);
            value = this.patternTextField.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogFormatter().setAttribPattern(value);
            } else {
                this.getLogFormatter().removeAttribPattern();
            }
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this.modifyCallbackActive = false;
            if (this.getLogFormatter() != null) {
                String name = this.getLogFormatter().getAttribName();
                this.formNameTextField.setText(name);
                this.setTitle(name);
                String pattern = this.getLogFormatter().getAttribPattern();
                this.patternTextField.setText(pattern);
                String type = this.getLogFormatter().getAttribType();
                this.formatterTypeTextField.setText(type);
            }
            Object var5_4 = null;
            this.modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
    }

    private ILogFormatter getLogFormatter() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        ILogFormatter result = null;
        if (value instanceof ILogFormatter) {
            result = (ILogFormatter)value;
        }
        return result;
    }

    protected void handleFormatterModifyEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        this.refreshFormatterFromUI();
        super.handleEvent();
    }

    protected void handleEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UISapLogFormatter.this.handleFormatterModifyEvent();
        }
    }
}

