/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplog.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplog.ILogConfigurationHolder;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.log.dd.IAnonymousFormatter;
import com.tssap.j2ee.model.ext.log.dd.IAssociatedDestinations;
import com.tssap.j2ee.model.ext.log.dd.IDestinationRef;
import com.tssap.j2ee.model.ext.log.dd.IFormatterRef;
import com.tssap.j2ee.model.ext.log.dd.ILogConfiguration;
import com.tssap.j2ee.model.ext.log.dd.ILogController;
import com.tssap.j2ee.model.ext.log.dd.ILogControllers;
import com.tssap.j2ee.model.ext.log.dd.ILogDestination;
import com.tssap.j2ee.model.ext.log.dd.ILogFormatter;
import com.tssap.j2ee.model.ext.log.dd.ILogFormatters;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UISapLogDestination
extends EditableDefaultObjectEditorComponent {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$UISapLogDestination == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$UISapLogDestination = UISapLogDestination.class$("com.sap.ide.eclipse.j2ee.model.ui.saplog.internal.UISapLogDestination")) : class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$UISapLogDestination));
    private static final String[] DESTINATION_TYPES = new String[]{"FileLog", "ConsoleLog"};
    private static final String[] SEVERITY_TYPES = new String[]{"", "ALL", "DEBUG", "PATH", "INFO", "WARNING", "ERROR", "FATAL", "NONE"};
    private static final String[] ANONYMOUS_TYPES = new String[]{"ListFormatter", "TraceFormatter", "XMLFormatter"};
    private static final String DEFAULT_ANONYMOUS_TYPE = "ListFormatter";
    private Text destinationNameTextField;
    private Combo destinationTypeTextField;
    private Text patternTextField;
    private Text encodingNameTextField;
    private Combo severityTextFiled;
    private Text limitTextFiled;
    private Text countTextFiled;
    private Button formatterRefRadioButton;
    private Combo formatterRefTextField;
    private Button anonymousRadioButton;
    private Combo anonymousTextField;
    private Button withoutFormatterRadioButton;
    private boolean _modifyCallbackActive = true;
    private ILogConfigurationHolder holder;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$UISapLogDestination;

    public UISapLogDestination(ILogConfigurationHolder holder) {
        this.holder = holder;
    }

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(4, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Destination name");
        this.destinationNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Type");
        this.destinationTypeTextField = pane.addComboBox(DESTINATION_TYPES, "", true, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Pattern");
        this.patternTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Encoding");
        this.encodingNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Severity");
        this.severityTextFiled = pane.addComboBox(SEVERITY_TYPES, "", true, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Limit");
        this.limitTextFiled = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Count");
        this.countTextFiled = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        IGridLayoutPane formatterPane = userArea.addGridLayoutPane("Formatter", 1, false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.withoutFormatterRadioButton = formatterPane.addRadioButton("Without formatter", formatterPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.formatterRefRadioButton = formatterPane.addRadioButton("Formatter Reference", formatterPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.formatterRefTextField = formatterPane.addComboBox(this.getLogFormatters(), "", true, formatterPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.anonymousRadioButton = formatterPane.addRadioButton("Anonymous Formatter", formatterPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.anonymousTextField = formatterPane.addComboBox(ANONYMOUS_TYPES, "", true, formatterPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this.destinationNameTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.destinationTypeTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.patternTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.encodingNameTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.severityTextFiled.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.limitTextFiled.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.countTextFiled.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.anonymousTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.formatterRefTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.formatterRefRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter());
        this.anonymousRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter());
        this.withoutFormatterRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter());
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getLogDestination() != null) {
            this.refreshDestinationFromUI();
        }
    }

    private void refreshDestinationFromUI() {
        String METHOD = "refreshTreeValuesFromUI()";
        if (this.getLogDestination() != null) {
            String value = this.destinationNameTextField.getText();
            String oldValue = this.getLogDestination().getAttribName();
            this.getLogDestination().setAttribName(value);
            this.renameLogDestination(oldValue, value);
            this.setTitle(value);
            value = this.destinationTypeTextField.getText();
            this.getLogDestination().setAttribType(value);
            value = this.patternTextField.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogDestination().setAttribPattern(value);
            } else {
                this.getLogDestination().removeAttribPattern();
            }
            value = this.encodingNameTextField.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogDestination().setAttribEncoding(value);
            } else {
                this.getLogDestination().removeAttribEncoding();
            }
            value = this.severityTextFiled.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogDestination().setAttribEffectiveSeverity(value);
            } else {
                this.getLogDestination().removeAttribEffectiveSeverity();
            }
            value = this.limitTextFiled.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogDestination().setAttribLimit(value);
            } else {
                this.getLogDestination().removeAttribLimit();
            }
            value = this.countTextFiled.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogDestination().setAttribCount(value);
            } else {
                this.getLogDestination().removeAttribCount();
            }
            if (this.withoutFormatterRadioButton.getSelection()) {
                this.getLogDestination().removeAnonymousFormatter();
                this.getLogDestination().removeFormatterRef();
            } else if (this.formatterRefRadioButton.getSelection()) {
                this.getLogDestination().removeAnonymousFormatter();
                value = this.formatterRefTextField.getText();
                if (value != null && value.trim().length() != 0) {
                    IFormatterRef formatterRef = this.getLogDestination().getFormatterRef();
                    try {
                        if (formatterRef == null) {
                            formatterRef = this.getLogDestination().createFormatterRef(null);
                        }
                        formatterRef.setAttribName(value);
                    }
                    catch (J2eeCreateException e) {
                        TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                    }
                }
            } else {
                this.getLogDestination().removeFormatterRef();
                value = this.anonymousTextField.getText();
                if (value != null && value.trim().length() != 0) {
                    IAnonymousFormatter anonimFormatter = this.getLogDestination().getAnonymousFormatter();
                    try {
                        if (anonimFormatter == null) {
                            anonimFormatter = this.getLogDestination().createAnonymousFormatter(null);
                        }
                        anonimFormatter.setAttribType(value);
                    }
                    catch (J2eeCreateException e) {
                        TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this._modifyCallbackActive = false;
            if (this.getLogDestination() != null) {
                this.destinationNameTextField.setText(this.getLogDestination().getAttribName());
                this.setTitle(this.getLogDestination().getAttribName());
                this.destinationTypeTextField.setText(this.getLogDestination().getAttribType());
                this.patternTextField.setText(this.getLogDestination().getAttribPattern());
                this.encodingNameTextField.setText(this.getLogDestination().getAttribEncoding());
                this.severityTextFiled.setText(this.getLogDestination().getAttribEffectiveSeverity());
                this.limitTextFiled.setText(this.getLogDestination().getAttribLimit());
                this.countTextFiled.setText(this.getLogDestination().getAttribCount());
                this.formatterRefRadioButton.setSelection(this.getLogDestination().getFormatterRef() != null);
                this.anonymousRadioButton.setSelection(this.getLogDestination().getAnonymousFormatter() != null);
                this.withoutFormatterRadioButton.setSelection(!this.formatterRefRadioButton.getSelection() && !this.anonymousRadioButton.getSelection());
                this.enableRadioButtons();
                this.updateSpecificEditableBehavior();
                this.setTitle(this.getLogDestination().getAttribName());
            }
            Object var2_1 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        this.formatterRefRadioButton.setEnabled(this.isEditable() && this.getLogFormatters().length != 0);
        this.formatterRefTextField.setEnabled(this.isEditable() && this.formatterRefRadioButton.getSelection());
        this.anonymousTextField.setEnabled(this.isEditable() && this.anonymousRadioButton.getSelection());
    }

    private void enableRadioButtons() {
        boolean oldModifyCallbackActive = this._modifyCallbackActive;
        try {
            this._modifyCallbackActive = false;
            if (this.formatterRefRadioButton.getSelection()) {
                this.formatterRefTextField.setItems(this.getLogFormatters());
                this.formatterRefTextField.setText(this.getLogDestination().getFormatterRef().getAttribName());
            } else {
                this.formatterRefTextField.deselectAll();
            }
            if (this.anonymousRadioButton.getSelection()) {
                this.anonymousTextField.setText(this.getLogDestination().getAnonymousFormatter().getAttribType());
            } else {
                this.anonymousTextField.deselectAll();
            }
            this.updateSpecificEditableBehavior();
            Object var3_2 = null;
            this._modifyCallbackActive = oldModifyCallbackActive;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._modifyCallbackActive = oldModifyCallbackActive;
            throw throwable;
        }
    }

    private ILogDestination getLogDestination() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        ILogDestination result = null;
        if (value instanceof ILogDestination) {
            result = (ILogDestination)value;
        }
        return result;
    }

    protected void handleNameModifyEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        this.refreshDestinationFromUI();
        super.handleEvent();
    }

    private ILogConfiguration getLogConfiguration() {
        return this.holder.getLogConfiguration();
    }

    private String[] getLogFormatters() {
        ILogFormatter[] formatter;
        ILogFormatters formatters;
        if (this.getLogConfiguration() != null && (formatters = this.getLogConfiguration().getLogFormatters()) != null && (formatter = formatters.getLogFormatters()) != null) {
            String[] formatterNames = new String[formatter.length];
            int i = 0;
            while (i < formatter.length) {
                formatterNames[i] = formatter[i].getAttribName();
                ++i;
            }
            return formatterNames;
        }
        return new String[0];
    }

    private void renameLogDestination(String oldName, String newName) {
        ILogController[] controller;
        ILogControllers controllers;
        if (this.getLogConfiguration() != null && (controllers = this.getLogConfiguration().getLogControllers()) != null && (controller = controllers.getLogControllers()) != null) {
            int i = 0;
            while (i < controller.length) {
                IDestinationRef[] refs;
                IAssociatedDestinations dest = controller[i].getAssociatedDestinations();
                if (dest != null && (refs = dest.getDestinationRefs()) != null) {
                    int j = 0;
                    if (j < refs.length) {
                        if (refs[j].getAttribName().equals(oldName)) {
                            refs[j].setAttribName(newName);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void handleEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SelectionAdapter
    implements SelectionListener {
        private SelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            String METHOD = "widgetDefaultSelected()";
            if (!UISapLogDestination.this._modifyCallbackActive) {
                return;
            }
            Button source = (Button)evt.getSource();
            if (!source.getSelection()) {
                return;
            }
            try {
                if (UISapLogDestination.this.getLogDestination() != null) {
                    if (UISapLogDestination.this.withoutFormatterRadioButton.getSelection()) {
                        UISapLogDestination.this.getLogDestination().removeAnonymousFormatter();
                        UISapLogDestination.this.getLogDestination().removeFormatterRef();
                    } else if (UISapLogDestination.this.formatterRefRadioButton.getSelection()) {
                        UISapLogDestination.this.getLogDestination().removeAnonymousFormatter();
                        String[] formatters = UISapLogDestination.this.getLogFormatters();
                        UISapLogDestination.this.getLogDestination().createFormatterRef(null).setAttribName(formatters[0]);
                    } else {
                        UISapLogDestination.this.getLogDestination().removeFormatterRef();
                        UISapLogDestination.this.getLogDestination().createAnonymousFormatter(null).setAttribType(UISapLogDestination.DEFAULT_ANONYMOUS_TYPE);
                    }
                    UISapLogDestination.this.enableRadioButtons();
                }
            }
            catch (J2eeCreateException e) {
                TRACER.error("widgetDefaultSelected()", "Element could not be created: " + e.toString(), (Throwable)e);
            }
            UISapLogDestination.this.handleEvent();
        }

        public void widgetSelected(SelectionEvent evt) {
            this.widgetDefaultSelected(evt);
        }
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UISapLogDestination.this.handleNameModifyEvent();
        }
    }
}

