/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplog.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.log.dd.ILogController;
import com.tssap.j2ee.model.ext.log.dd.IRelativeSeverity;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UISapLogController
extends EditableDefaultObjectEditorComponent {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$UISapLogController == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$UISapLogController = UISapLogController.class$("com.sap.ide.eclipse.j2ee.model.ui.saplog.internal.UISapLogController")) : class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$UISapLogController));
    private static final String[] SEVERITY_TYPES = new String[]{"", "ALL", "DEBUG", "PATH", "INFO", "WARNING", "ERROR", "FATAL", "NONE"};
    private static final String[] RELATIVE_SEVERITY_TYPES = new String[]{"ALL", "DEBUG", "PATH", "INFO", "WARNING", "ERROR", "FATAL", "NONE"};
    private static final String DEFAULT_RELATIVE_SEVERITY_TYPE = "ERROR";
    private Text controllerNameTextField;
    private Text bundleTextField;
    private Combo effSeverityTextField;
    private Combo minSeverityTextField;
    private Combo maxSeverityTextField;
    private Text relativeSeverityTextField;
    private Combo relativeSevValueTextField;
    private boolean modifyCallbackActive = true;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$UISapLogController;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(4, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Controller name");
        this.controllerNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Bundle name");
        this.bundleTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Effective severity");
        this.effSeverityTextField = pane.addComboBox(SEVERITY_TYPES, "", true, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Minimum severity");
        this.minSeverityTextField = pane.addComboBox(SEVERITY_TYPES, "", true, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        pane.addTextLabel("Maximum severity");
        this.maxSeverityTextField = pane.addComboBox(SEVERITY_TYPES, "", true, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        IGridLayoutPane severityPane = userArea.addGridLayoutPane("Relative Severity", 1, false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        severityPane.addTextLabel("Relative Severity Name");
        this.relativeSeverityTextField = severityPane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        severityPane.addTextLabel("Relative Severity Value");
        this.relativeSevValueTextField = severityPane.addComboBox(RELATIVE_SEVERITY_TYPES, "", true, pane.createGridLayoutData(4, 4, true, false, 3, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this.controllerNameTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.bundleTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.effSeverityTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.minSeverityTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.maxSeverityTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.relativeSeverityTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.relativeSevValueTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getLogController() != null) {
            this.refreshControllerFromUI();
        }
    }

    private void refreshControllerFromUI() {
        String METHOD = "refreshTreeValuesFromUI()";
        if (this.getLogController() != null) {
            String value = this.controllerNameTextField.getText();
            this.getLogController().setAttribName(value);
            this.setTitle(value);
            value = this.bundleTextField.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogController().setAttribBundleName(value);
            } else {
                this.getLogController().removeAttribBundleName();
            }
            value = this.effSeverityTextField.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogController().setAttribEffectiveSeverity(value);
            } else {
                this.getLogController().removeAttribEffectiveSeverity();
            }
            value = this.minSeverityTextField.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogController().setAttribMinimumSeverity(value);
            } else {
                this.getLogController().removeAttribMinimumSeverity();
            }
            value = this.maxSeverityTextField.getText();
            if (value != null && value.trim().length() != 0) {
                this.getLogController().setAttribMaximumSeverity(value);
            } else {
                this.getLogController().removeAttribMaximumSeverity();
            }
            IRelativeSeverity severity = this.getLogController().getRelativeSeverity();
            String valueR = this.relativeSeverityTextField.getText();
            String valueT = this.relativeSevValueTextField.getText();
            if (valueR == null && valueT == null || valueR != null && valueR.equals("") && valueT != null && valueT.equals("")) {
                this.getLogController().removeRelativeSeverity();
            }
            if (valueR != null && !valueR.equals("")) {
                if (severity == null) {
                    try {
                        severity = this.getLogController().createRelativeSeverity(null);
                    }
                    catch (J2eeCreateException e) {
                        TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                    }
                }
                severity.setAttribRelativeController(valueR);
            } else if (severity != null) {
                severity.removeAttribRelativeController();
            }
            if (valueT != null && !valueT.equals("")) {
                if (severity == null) {
                    try {
                        severity = this.getLogController().createRelativeSeverity(null);
                    }
                    catch (J2eeCreateException e) {
                        TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                    }
                }
                severity.setAttribValue(valueT);
            } else if (severity != null) {
                severity.removeAttribValue();
            }
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this.modifyCallbackActive = false;
            if (this.getLogController() != null) {
                this.controllerNameTextField.setText(this.getLogController().getAttribName());
                this.setTitle(this.getLogController().getAttribName());
                this.bundleTextField.setText(this.getLogController().getAttribBundleName());
                this.effSeverityTextField.setText(this.getLogController().getAttribEffectiveSeverity());
                this.minSeverityTextField.setText(this.getLogController().getAttribMinimumSeverity());
                this.maxSeverityTextField.setText(this.getLogController().getAttribMaximumSeverity());
                this.relativeSeverityTextField.setText(this.getLogController().getRelativeSeverity() != null ? this.getLogController().getRelativeSeverity().getAttribRelativeController() : "");
                this.relativeSevValueTextField.setText(this.getLogController().getRelativeSeverity() != null ? this.getLogController().getRelativeSeverity().getAttribValue() : "");
                this.enableRelativeSeverity();
            }
            Object var2_1 = null;
            this.modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        boolean enable = this.relativeSeverityTextField.getText().trim().length() != 0;
        this.relativeSevValueTextField.setEnabled(this.isEditable() && enable);
    }

    private void enableRelativeSeverity() {
        boolean oldModifyCallbackActive = this.modifyCallbackActive;
        try {
            boolean enable;
            this.modifyCallbackActive = false;
            this.updateSpecificEditableBehavior();
            boolean bl = enable = this.relativeSeverityTextField.getText().trim().length() != 0;
            if (enable) {
                boolean emptyText;
                boolean bl2 = emptyText = this.relativeSevValueTextField.getText().trim().length() == 0;
                if (emptyText) {
                    this.relativeSevValueTextField.setText(DEFAULT_RELATIVE_SEVERITY_TYPE);
                }
            } else {
                this.relativeSevValueTextField.deselectAll();
            }
            Object var5_4 = null;
            this.modifyCallbackActive = oldModifyCallbackActive;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.modifyCallbackActive = oldModifyCallbackActive;
            throw throwable;
        }
    }

    private ILogController getLogController() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        ILogController result = null;
        if (value instanceof ILogController) {
            result = (ILogController)value;
        }
        return result;
    }

    protected void handleNameModifyEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        this.enableRelativeSeverity();
        this.refreshControllerFromUI();
        super.handleEvent();
    }

    protected void handleEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UISapLogController.this.handleNameModifyEvent();
        }
    }
}

