/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplog.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplog.ILogConfigurationHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplog.internal.DestinationContentProvider;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.SapLogConfigurationDefaultFactory;
import com.tssap.j2ee.model.ext.log.dd.IAssociatedDestinations;
import com.tssap.j2ee.model.ext.log.dd.IDestinationRef;
import com.tssap.j2ee.model.ext.log.dd.ILogConfiguration;
import com.tssap.j2ee.model.ext.log.dd.ILogController;
import com.tssap.j2ee.model.ext.log.dd.ILogControllers;
import com.tssap.j2ee.model.ext.log.dd.ILogDestination;
import com.tssap.j2ee.model.ext.log.dd.ILogDestinations;
import com.tssap.j2ee.model.ext.log.dd.ILogFilter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;

public class DestinationAddRemoveCallback
implements IAddRemoveCallback {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$DestinationAddRemoveCallback == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$DestinationAddRemoveCallback = DestinationAddRemoveCallback.class$("com.sap.ide.eclipse.j2ee.model.ui.saplog.internal.DestinationAddRemoveCallback")) : class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$DestinationAddRemoveCallback));
    private ILogConfigurationHolder holder;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$DestinationAddRemoveCallback;

    public DestinationAddRemoveCallback(ILogConfigurationHolder holder) {
        this.holder = holder;
    }

    public boolean canAddElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value == DestinationContentProvider.FOLDER_DESTINATIONS) {
            result = true;
        } else if (value instanceof ILogDestination) {
            result = true;
        }
        return result;
    }

    public Object addElement(Object currentSelection) {
        String METHOD = "addElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        ParentHolder result = null;
        if (this.getLogConfiguration() != null) {
            if (value == DestinationContentProvider.FOLDER_DESTINATIONS) {
                try {
                    ILogDestinations logDestinations = this.getLogDestinations();
                    if (logDestinations == null) {
                        logDestinations = this.getLogConfiguration().createLogDestinations(null);
                    }
                    ILogDestination destination = SapLogConfigurationDefaultFactory.createDestination((ILogDestinations)logDestinations);
                    result = new ParentHolder(parentHolder, destination);
                }
                catch (J2eeCreateException e) {
                    TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                }
            } else if (value instanceof ILogDestination) {
                try {
                    ILogDestination destination = (ILogDestination)value;
                    ILogFilter logFilter = SapLogConfigurationDefaultFactory.createLogFilter((ILogDestination)destination);
                    result = new ParentHolder(parentHolder, logFilter);
                }
                catch (J2eeCreateException e) {
                    TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public boolean canRemoveElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value instanceof ILogDestination) {
            result = true;
        }
        if (value instanceof ILogFilter) {
            result = true;
        }
        return result;
    }

    public boolean removeElement(Object currentSelection) {
        String METHOD = "removeElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        if (value instanceof ILogDestination && this.getLogDestinations() != null) {
            this.removeReferencedDestination(this.getLogConfiguration(), (ILogDestination)value);
            SapLogConfigurationDefaultFactory.removeDestinationAndEmptyParents((ILogConfiguration)this.getLogConfiguration(), (ILogDestination)((ILogDestination)value));
            return true;
        }
        if (value instanceof ILogFilter && this.getLogDestinations() != null) {
            ILogFilter logFilter = (ILogFilter)value;
            ILogDestination destination = (ILogDestination)parentHolder.getParent().getValue();
            if (destination != null) {
                SapLogConfigurationDefaultFactory.removeLogFilterAndEmptyParents((ILogConfiguration)this.getLogConfiguration(), (ILogDestination)destination, (ILogFilter)logFilter);
            }
            return true;
        }
        return false;
    }

    private ILogConfiguration getLogConfiguration() {
        if (this.holder != null) {
            return this.holder.getLogConfiguration();
        }
        return null;
    }

    public ILogDestinations getLogDestinations() {
        if (this.getLogConfiguration() != null) {
            return this.getLogConfiguration().getLogDestinations();
        }
        return null;
    }

    public void removeReferencedDestination(ILogConfiguration conf, ILogDestination destination) {
        ILogController[] cont;
        ILogControllers controllers = conf.getLogControllers();
        if (controllers != null && (cont = controllers.getLogControllers()) != null) {
            int i = 0;
            while (i < cont.length) {
                IDestinationRef[] destRefs;
                IAssociatedDestinations dest;
                if (cont[i] != null && (dest = cont[i].getAssociatedDestinations()) != null && (destRefs = dest.getDestinationRefs()) != null) {
                    int j = 0;
                    while (j < destRefs.length) {
                        if (destRefs[j] != null && destRefs[j].getAttribName().equals(destination.getAttribName())) {
                            SapLogConfigurationDefaultFactory.removeDestinationRefAndEmptyParents((ILogController)cont[i], (IDestinationRef)destRefs[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

