/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplog.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.dialog.StringChooserDialog;
import com.sap.ide.eclipse.j2ee.model.ui.saplog.ILogConfigurationHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplog.internal.ControllerContentProvider;
import com.sap.ide.eclipse.j2ee.model.ui.saplog.internal.ControllerLabelProvider;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.SapLogConfigurationDefaultFactory;
import com.tssap.j2ee.model.ext.log.dd.IAnonymousDestination;
import com.tssap.j2ee.model.ext.log.dd.IDestinationRef;
import com.tssap.j2ee.model.ext.log.dd.ILogConfiguration;
import com.tssap.j2ee.model.ext.log.dd.ILogController;
import com.tssap.j2ee.model.ext.log.dd.ILogControllers;
import com.tssap.j2ee.model.ext.log.dd.ILogDestination;
import com.tssap.j2ee.model.ext.log.dd.ILogDestinations;
import com.tssap.j2ee.model.ext.log.dd.ILogFilter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import java.util.ArrayList;

public class ControllerAddRemoveCallback
implements IAddRemoveCallback {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$ControllerAddRemoveCallback == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$ControllerAddRemoveCallback = ControllerAddRemoveCallback.class$("com.sap.ide.eclipse.j2ee.model.ui.saplog.internal.ControllerAddRemoveCallback")) : class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$ControllerAddRemoveCallback));
    private ILogConfigurationHolder holder;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$saplog$internal$ControllerAddRemoveCallback;

    public ControllerAddRemoveCallback(ILogConfigurationHolder holder) {
        this.holder = holder;
    }

    public boolean canAddElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value == ControllerContentProvider.FOLDER_CONTROLLERS) {
            result = true;
        } else if (value instanceof ControllerContentProvider.LogFiltersFolder) {
            result = true;
        } else if (value instanceof ControllerContentProvider.DestinationRefFolder) {
            result = true;
        } else if (value instanceof ControllerContentProvider.AnonymousDestFolder) {
            result = true;
        }
        return result;
    }

    public Object addElement(Object currentSelection) {
        String METHOD = "addElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        ParentHolder result = null;
        if (this.getLogConfiguration() != null) {
            if (value == ControllerContentProvider.FOLDER_CONTROLLERS) {
                try {
                    ILogControllers logControllers = this.getLogControllers();
                    if (logControllers == null) {
                        logControllers = this.getLogConfiguration().createLogControllers(null);
                    }
                    ILogController controller = SapLogConfigurationDefaultFactory.createController((ILogControllers)logControllers);
                    result = new ParentHolder(parentHolder, controller);
                }
                catch (J2eeCreateException e) {
                    TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                }
            } else if (value instanceof ControllerContentProvider.LogFiltersFolder) {
                try {
                    ControllerContentProvider.LogFiltersFolder controller = (ControllerContentProvider.LogFiltersFolder)value;
                    ILogFilter logFilter = SapLogConfigurationDefaultFactory.createLogFilter((ILogController)controller.getLogController());
                    result = new ParentHolder(parentHolder, logFilter);
                }
                catch (J2eeCreateException e) {
                    TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                }
            } else if (value instanceof ControllerContentProvider.DestinationRefFolder) {
                ControllerContentProvider.DestinationRefFolder controller = (ControllerContentProvider.DestinationRefFolder)value;
                IDestinationRef destRefs = this.getDestinationRef(controller.getLogController());
                result = new ParentHolder(parentHolder, destRefs);
            } else if (value instanceof ControllerContentProvider.AnonymousDestFolder) {
                try {
                    ControllerContentProvider.AnonymousDestFolder controller = (ControllerContentProvider.AnonymousDestFolder)value;
                    IAnonymousDestination destination = SapLogConfigurationDefaultFactory.createAnonymousDestination((ILogController)controller.getLogController());
                    result = new ParentHolder(parentHolder, destination);
                }
                catch (J2eeCreateException e) {
                    TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public boolean canRemoveElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value instanceof ILogController) {
            result = true;
        }
        if (value instanceof ILogFilter) {
            result = true;
        }
        if (value instanceof IAnonymousDestination) {
            result = true;
        }
        if (value instanceof IDestinationRef) {
            result = true;
        }
        return result;
    }

    public boolean removeElement(Object currentSelection) {
        String METHOD = "removeElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        if (this.getLogControllers() != null) {
            if (value instanceof ILogController) {
                SapLogConfigurationDefaultFactory.removeControllerAndEmptyParents((ILogConfiguration)this.getLogConfiguration(), (ILogController)((ILogController)value));
                return true;
            }
            if (value instanceof ILogFilter) {
                if (parentHolder.getParent().getValue() instanceof ControllerContentProvider.LogFiltersFolder) {
                    ControllerContentProvider.LogFiltersFolder folder = (ControllerContentProvider.LogFiltersFolder)parentHolder.getParent().getValue();
                    ILogFilter logFilter = (ILogFilter)value;
                    folder.removeTreeNode(parentHolder);
                    ILogController controller = folder.getLogController();
                    if (controller != null) {
                        SapLogConfigurationDefaultFactory.removeLogFilterAndEmptyParents((ILogController)controller, (ILogFilter)logFilter);
                    }
                    return true;
                }
            } else if (value instanceof IDestinationRef) {
                if (parentHolder.getParent().getValue() instanceof ControllerContentProvider.DestinationRefFolder) {
                    ControllerContentProvider.DestinationRefFolder folder = (ControllerContentProvider.DestinationRefFolder)parentHolder.getParent().getValue();
                    IDestinationRef destRef = (IDestinationRef)value;
                    folder.removeTreeNode(parentHolder);
                    ILogController controller = folder.getLogController();
                    if (controller != null) {
                        SapLogConfigurationDefaultFactory.removeDestinationRefAndEmptyParents((ILogController)controller, (IDestinationRef)destRef);
                    }
                    return true;
                }
            } else if (value instanceof IAnonymousDestination && parentHolder.getParent().getValue() instanceof ControllerContentProvider.AnonymousDestFolder) {
                ControllerContentProvider.AnonymousDestFolder folder = (ControllerContentProvider.AnonymousDestFolder)parentHolder.getParent().getValue();
                IAnonymousDestination dest = (IAnonymousDestination)value;
                folder.removeTreeNode(parentHolder);
                ILogController controller = folder.getLogController();
                if (controller != null) {
                    SapLogConfigurationDefaultFactory.removeAnonymousDestAndEmptyParents((ILogController)controller, (IAnonymousDestination)dest);
                }
                return true;
            }
        }
        return false;
    }

    private ILogConfiguration getLogConfiguration() {
        if (this.holder != null) {
            return this.holder.getLogConfiguration();
        }
        return null;
    }

    public ILogControllers getLogControllers() {
        if (this.getLogConfiguration() != null) {
            return this.getLogConfiguration().getLogControllers();
        }
        return null;
    }

    private IDestinationRef getDestinationRef(ILogController logController) {
        IDestinationRef[] selectedDest = null;
        ILogDestination[] destination = null;
        if (this.getLogConfiguration() != null) {
            ILogDestinations destinations = this.getLogConfiguration().getLogDestinations();
            if (destinations != null) {
                destination = destinations.getLogDestinations();
                if (logController != null && logController.getAssociatedDestinations() != null) {
                    selectedDest = logController.getAssociatedDestinations().getDestinationRefs();
                }
            }
            ArrayList<String> destList = new ArrayList<String>();
            if (destination != null) {
                int i = 0;
                while (i < destination.length) {
                    destList.add(destination[i].getAttribName());
                    ++i;
                }
            }
            String[] destNames = new String[destList.size()];
            destList.toArray(destNames);
            ArrayList<String> sourceList = new ArrayList<String>();
            if (selectedDest != null) {
                int i = 0;
                while (i < selectedDest.length) {
                    sourceList.add(selectedDest[i].getAttribName());
                    ++i;
                }
            }
            String[] sourceNames = new String[sourceList.size()];
            sourceList.toArray(sourceNames);
            String[] result = StringChooserDialog.openDialog(destNames, sourceNames, ControllerLabelProvider.IMAGE_DEST_REF, "Log Destinations");
            IDestinationRef destRef = this.handleDestRefSelection(logController, sourceNames, result);
            return destRef;
        }
        return null;
    }

    private IDestinationRef handleDestRefSelection(ILogController logController, String[] before, String[] added) {
        String METHOD = "handleSelection()";
        IDestinationRef destRef = null;
        if (added == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < added.length) {
                destRef = SapLogConfigurationDefaultFactory.createDestinationRef((ILogController)logController);
                destRef.setAttribName(added[i]);
                ++i;
            }
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
        }
        return destRef;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

