/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IReferenceComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IReferenceComponentAdapter;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.ReferenceComponent;
import com.tssap.j2ee.model.ext.library.dd.IReference;
import com.tssap.util.ui.pane.IGridLayoutPane;

public class UISapLibraryReference
extends EditableDefaultObjectEditorComponent
implements IReferenceComponentAdapter {
    private static final String[] REFERENCE_TYPES = new String[]{"weak"};
    private static final String[] REFERENCE_TARGET_TYPES = new String[]{"interface", "library", "service"};
    private IReferenceComponent _referenceComponent;
    private boolean _modifyCallbackActive = true;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, true));
        this._referenceComponent = new ReferenceComponent(this, REFERENCE_TYPES, REFERENCE_TARGET_TYPES);
        this._referenceComponent.createPartControl(pane);
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getReference() != null) {
            this.refreshReferenceNameFromUI();
            String value = this._referenceComponent.getAttribProviderName();
            if (value != null && value.trim().length() != 0) {
                this.getReference().setAttribProviderName(value);
            } else {
                this.getReference().removeAttribProviderName();
            }
        }
    }

    private void refreshReferenceNameFromUI() {
        if (this.getReference() != null) {
            String value = this._referenceComponent.getReferenceTarget();
            this.getReference().setValue(value);
            this.setTitle(value);
            value = this._referenceComponent.getAttribReferenceType();
            this.getReference().setAttribStrength(value);
            value = this._referenceComponent.getAttribTargetType();
            this.getReference().setAttribType(value);
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this._modifyCallbackActive = false;
            if (this.getReference() != null) {
                this.setTitle(this.getReference().getValue());
                this._referenceComponent.refresh();
            }
            Object var2_1 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        this._referenceComponent.setEditable(this.isEditable());
    }

    public String getAttribProviderName() {
        if (this.getReference() != null) {
            return this.getReference().getAttribProviderName();
        }
        return null;
    }

    public String getAttribTargetType() {
        if (this.getReference() != null) {
            return this.getReference().getAttribType();
        }
        return null;
    }

    public String getReferenceTarget() {
        if (this.getReference() != null) {
            return this.getReference().getValue();
        }
        return null;
    }

    public String getAttribReferenceType() {
        if (this.getReference() != null) {
            return this.getReference().getAttribStrength();
        }
        return null;
    }

    public void referenceChanged() {
        this.handleEvent();
        this.refreshReferenceNameFromUI();
    }

    private IReference getReference() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        IReference result = null;
        if (value instanceof IReference) {
            result = (IReference)value;
        }
        return result;
    }

    protected void handleEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }
}

