/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.SapLibraryJarsPage;
import com.tssap.j2ee.model.ext.library.dd.IJarName;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Text;

public class UISapLibraryJar
extends EditableDefaultObjectEditorComponent {
    private Text _jarNameTextField;
    private SapLibraryJarsPage _page;

    public UISapLibraryJar(SapLibraryJarsPage page) {
        this._page = page;
    }

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Filename (relative)");
        this._jarNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        this._jarNameTextField.setEnabled(false);
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        if (this.getJarName() != null) {
            String value = this.getJarName().getValue();
            this.setTitle(value);
            IFile file = (IFile)this._page.getJarfiles().get(value);
            if (file == null) {
                this._jarNameTextField.setText("Error: there is no entry in the .tssapinfo for the jar '" + value + "'");
            } else {
                this._jarNameTextField.setText(file.getFullPath().toString());
            }
        }
    }

    protected void updateSpecificEditableBehavior() {
        if (this.isEditable()) {
            // empty if block
        }
        this._jarNameTextField.setEditable(false);
    }

    private IJarName getJarName() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        IJarName result = null;
        if (value instanceof IJarName) {
            result = (IJarName)value;
        }
        return result;
    }
}

