/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplibrary.IProviderDescriptorHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.ReferencesContentProvider;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.SapLibraryDefaultFactory;
import com.tssap.j2ee.model.ext.library.dd.IProviderDescriptor;
import com.tssap.j2ee.model.ext.library.dd.IReference;
import com.tssap.j2ee.model.ext.library.dd.IReferences;
import com.tssap.tools.addlib.AddLibManager;
import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibDefinition;
import com.tssap.tools.addlib.IAddLibManager;
import com.tssap.tools.addlib.internal.AddLibDefinition;
import com.tssap.tools.ui.addlib.dialog.AddLibSelectionDialog;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ReferencesAddRemoveCallback
implements IAddRemoveCallback {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$ReferencesAddRemoveCallback == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$ReferencesAddRemoveCallback = ReferencesAddRemoveCallback.class$("com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.ReferencesAddRemoveCallback")) : class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$ReferencesAddRemoveCallback));
    private static final IReference[] EMPTY_REFERENCE_ARRAY = new IReference[0];
    public static final char PROVIDER_SEPARATOR = '/';
    private IProviderDescriptorHolder _holder;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$ReferencesAddRemoveCallback;

    public ReferencesAddRemoveCallback(IProviderDescriptorHolder holder) {
        this._holder = holder;
    }

    public boolean canAddElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value == ReferencesContentProvider.FOLDER_REFERENCES) {
            result = true;
        }
        return result;
    }

    public Object addElement(Object currentSelection) {
        IReference[] addedReferences;
        String METHOD = "addElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        ParentHolder result = null;
        if (this.getProviderDescriptor() != null && value == ReferencesContentProvider.FOLDER_REFERENCES && (addedReferences = this.openAddReferences()) != null && addedReferences.length > 0) {
            result = new ParentHolder(parentHolder, addedReferences[0]);
        }
        return result;
    }

    private IReference[] openAddReferences() {
        String METHOD = "openAddReferences()";
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog msgDiag = new MessageDialog(currentShell, "Please choose", null, "Do you want to create a new reference or select from known libraries", 3, new String[]{"Create new", "Select library/interface/service"}, 1);
        int addNew = msgDiag.open();
        try {
            IReferences refs;
            IReference[] ret = null;
            if (addNew == 0) {
                ret = new IReference[]{SapLibraryDefaultFactory.createReference((IProviderDescriptor)this.getProviderDescriptor())};
            } else if (addNew == 1 && (refs = this.getProviderDescriptor().getReferences()) != null) {
                IReference[] currentRefs = refs.getReferences();
                AddLibDefinition[] currentAddLibs = new AddLibDefinition[currentRefs.length];
                int i = 0;
                while (i < currentRefs.length) {
                    currentAddLibs[i] = new AddLibDefinition(currentRefs[i].getAttribProviderName(), currentRefs[i].getValue());
                    ++i;
                }
                IAddLib[] selectedAddLibs = AddLibSelectionDialog.openSelection((Shell)currentShell, (IAddLibManager)AddLibManager.getManager(), (IAddLibDefinition[])currentAddLibs, (IAddLibDefinition[])currentAddLibs, (boolean)false);
                if (selectedAddLibs != null && selectedAddLibs.length > 0) {
                    ArrayList<IReference> retList = new ArrayList<IReference>();
                    int i2 = 0;
                    while (i2 < selectedAddLibs.length) {
                        boolean isCurrentlyUsed = false;
                        int j = 0;
                        while (j < currentAddLibs.length && !isCurrentlyUsed) {
                            if (currentAddLibs[j].matches((IAddLibDefinition)selectedAddLibs[i2])) {
                                isCurrentlyUsed = true;
                            }
                            ++j;
                        }
                        if (!isCurrentlyUsed) {
                            IReference newRef = SapLibraryDefaultFactory.createReference((IProviderDescriptor)this.getProviderDescriptor());
                            newRef.setValue(selectedAddLibs[i2].getName());
                            newRef.setAttribProviderName(selectedAddLibs[i2].getVendor());
                            if (selectedAddLibs[i2].getSubType() == 2) {
                                newRef.setAttribType("library");
                            } else if (selectedAddLibs[i2].getSubType() == 3) {
                                newRef.setAttribType("interface");
                            } else if (selectedAddLibs[i2].getSubType() == 4) {
                                newRef.setAttribType("service");
                            }
                            retList.add(newRef);
                        }
                        ++i2;
                    }
                    ret = retList.toArray(new IReference[retList.size()]);
                }
            }
            return ret;
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
            return EMPTY_REFERENCE_ARRAY;
        }
    }

    public boolean canRemoveElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value instanceof IReference) {
            result = true;
        }
        return result;
    }

    public boolean removeElement(Object currentSelection) {
        String METHOD = "removeElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value instanceof IReference && this.getProviderDescriptor() != null) {
            SapLibraryDefaultFactory.removeReferenceAndEmptyParents((IProviderDescriptor)this.getProviderDescriptor(), (IReference)((IReference)value));
            result = true;
        }
        return result;
    }

    private IProviderDescriptor getProviderDescriptor() {
        if (this._holder != null) {
            return this._holder.getProviderDescriptor();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

