/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal;

import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.util.core.IFilter;
import com.tssap.util.projectinfo.ProjectInfo;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.FilteredTreeContentProvider;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import com.tssap.util.ui.dialog.UserDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LibProjectInfoUtil {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$LibProjectInfoUtil == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$LibProjectInfoUtil = LibProjectInfoUtil.class$("com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.LibProjectInfoUtil")) : class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$LibProjectInfoUtil));
    private static final String SELECTION_DIAG_TITLE = "Select jars";
    private static final String SELECTION_DIAG_MSG = "Select jars to reference. Jars must be located in the workspace";
    private static final String REFERENCE_JARS_PROPERTY = "Library_Referenced_jars";
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$LibProjectInfoUtil;

    public static IFile[] selectAdditionalJarFiles(Shell shell, IProject project, IFile[] alreadySelected) {
        ArrayList<Object> tmpList = new ArrayList<Object>();
        if (LibProjectInfoUtil.isLibraryProject(project)) {
            StructuredObjectSelectionDialog sosd = new StructuredObjectSelectionDialog(shell, SELECTION_DIAG_TITLE, SELECTION_DIAG_MSG);
            FilteredTreeContentProvider tcp = new FilteredTreeContentProvider((ITreeContentProvider)new WorkbenchContentProvider(), (IFilter)new MyJarFileFilter(alreadySelected));
            sosd.setTreeInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            sosd.setLabelProvider((ILabelProvider)new WorkbenchLabelProvider());
            sosd.openDialog((ITreeContentProvider)tcp, true, 1);
            if (sosd.getReturnCode() == 0) {
                Object[] result = sosd.getResult();
                int i = 0;
                while (i < result.length) {
                    if (result[i] instanceof IFile) {
                        tmpList.add(result[i]);
                    }
                    ++i;
                }
            }
        }
        return tmpList.toArray(new IFile[tmpList.size()]);
    }

    public static void saveReferenceJars(IProject project, IFile[] refJars) {
        if (LibProjectInfoUtil.isLibraryProject(project) && refJars != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < refJars.length) {
                buf.append(refJars[i].getFullPath());
                if (i < refJars.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            if (!ProjectInfo.setProperty((IProject)project, (String)REFERENCE_JARS_PROPERTY, (String)buf.toString())) {
                ProjectInfo.SaveFailedReason reason = ProjectInfo.getLastSaveFailedReason();
                String reasonmsg = reason.isReadOnly() ? "The project property file .tssapinfo is read only" : (reason.getException() != null ? "Error writing project property file: " + reason.getException().getMessage() : "");
                UserDialog.openError((Shell)UIPlugin.getShell(), (String)"Error saving project properties", (String)reasonmsg);
            }
            LibProjectInfoUtil.updateClasspath(project);
        }
    }

    public static IPath[] getReferenceJarsRelative(IProject project) {
        ArrayList<Path> retList = new ArrayList<Path>();
        String referencedJars = ProjectInfo.getProperty((IProject)project, (String)REFERENCE_JARS_PROPERTY);
        if (referencedJars != null) {
            StringTokenizer st = new StringTokenizer(referencedJars, ",");
            while (st.hasMoreTokens()) {
                String pathStr = st.nextToken().trim();
                Path path = new Path(pathStr);
                retList.add(path);
            }
        }
        return retList.toArray(new IPath[retList.size()]);
    }

    public static IFile[] getReferenceJars(IProject project) {
        ArrayList<IFile> retList = new ArrayList<IFile>();
        IPath[] path = LibProjectInfoUtil.getReferenceJarsRelative(project);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < path.length) {
            try {
                IFile libFile = wsRoot.getFile(path[i]);
                retList.add(libFile);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            ++i;
        }
        return retList.toArray(new IFile[retList.size()]);
    }

    public static boolean isLibraryProject(IProject myProject) {
        if (myProject == null || !myProject.isAccessible()) {
            return false;
        }
        try {
            return myProject.hasNature("com.tssap.j2ee.library.libraryNature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static void updateClasspath(IProject project) {
        String METHOD = "updateClasspath(project)";
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath[] path = LibProjectInfoUtil.getReferenceJarsRelative(project);
            ArrayList<IClasspathEntry> newEntriesList = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            int i = 0;
            while (i < oldEntries.length) {
                if (oldEntries[i].getEntryKind() != 1) {
                    newEntriesList.add(oldEntries[i]);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < path.length) {
                IClasspathEntry classPathEntry = JavaCore.newLibraryEntry((IPath)path[i2], null, null, (boolean)true);
                newEntriesList.add(classPathEntry);
                ++i2;
            }
            IClasspathEntry[] newEntries = newEntriesList.toArray(new IClasspathEntry[newEntriesList.size()]);
            javaProject.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            String errorMessage = "The classpath of the project " + project.getName() + " can not be updated. Reason: " + e.getMessage();
            UserDialog.openError((Shell)UIPlugin.getShell(), (String)"Error updating classpath", (String)errorMessage);
            TRACER.error(METHOD, errorMessage, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MyJarFileFilter
    implements IFilter {
        private MyArchiveFinder archiveFinder;
        String[] _extFilter = new String[]{"jar"};
        List hiddenFiles;

        public MyJarFileFilter(IFile[] hiddenFiles) {
            this.archiveFinder = new MyArchiveFinder();
            this.hiddenFiles = new ArrayList();
            if (hiddenFiles != null) {
                this.hiddenFiles.addAll(Arrays.asList(hiddenFiles));
            }
        }

        public boolean accept(Object o) {
            boolean ret = false;
            this.archiveFinder.setContainsArchive(false);
            if (o instanceof IResource) {
                try {
                    ((IResource)o).accept((IResourceVisitor)this.archiveFinder);
                    ret = this.archiveFinder.isContainsArchive();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return ret;
        }

        private class MyArchiveFinder
        implements IResourceVisitor {
            boolean containsArchive;

            private MyArchiveFinder() {
            }

            private boolean isArchiveFile(Object object) {
                IFile f;
                boolean ret = false;
                if (object instanceof IFile && this.checkExtension((f = (IFile)object).getProjectRelativePath().getFileExtension()) && !MyJarFileFilter.this.hiddenFiles.contains(object)) {
                    ret = true;
                }
                return ret;
            }

            private boolean checkExtension(String ext) {
                boolean ret = false;
                int i = 0;
                while (i < MyJarFileFilter.this._extFilter.length && !ret) {
                    if (MyJarFileFilter.this._extFilter[i].equalsIgnoreCase(ext)) {
                        ret = true;
                    }
                    ++i;
                }
                return ret;
            }

            public boolean isContainsArchive() {
                return this.containsArchive;
            }

            public void setContainsArchive(boolean b) {
                this.containsArchive = b;
            }

            public boolean visit(IResource resource) throws CoreException {
                if (this.isArchiveFile(resource)) {
                    this.containsArchive = true;
                }
                return !this.containsArchive;
            }
        }
    }
}

