/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal;

import com.sap.ide.eclipse.j2ee.model.ui.IProjectHolder;
import com.sap.ide.eclipse.j2ee.model.ui.J2EEModelUIPlugin;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplibrary.IProviderDescriptorHolder;
import com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.JarsContentProvider;
import com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.LibProjectInfoUtil;
import com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.SapLibraryJarsPage;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.library.dd.IJarName;
import com.tssap.j2ee.model.ext.library.dd.IJars;
import com.tssap.j2ee.model.ext.library.dd.IProviderDescriptor;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class JarsAddRemoveCallback
implements IAddRemoveCallback {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$JarsAddRemoveCallback == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$JarsAddRemoveCallback = JarsAddRemoveCallback.class$("com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.JarsAddRemoveCallback")) : class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$JarsAddRemoveCallback));
    private IProviderDescriptorHolder _holder;
    private IProjectHolder _project;
    private SapLibraryJarsPage _page;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$saplibrary$internal$JarsAddRemoveCallback;

    public JarsAddRemoveCallback(SapLibraryJarsPage page) {
        this._holder = page;
        this._project = page;
        this._page = page;
    }

    public boolean canAddElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value == JarsContentProvider.FOLDER_JARS) {
            result = true;
        }
        return result;
    }

    public Object addElement(Object currentSelection) {
        Object value;
        String METHOD = "addElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        ParentHolder result = null;
        if (parentHolder != null && (value = parentHolder.getValue()) == JarsContentProvider.FOLDER_JARS) {
            Collection alreadySelectedCollection = this._page.getJarfiles().values();
            IFile[] alreadySelected = alreadySelectedCollection.toArray(new IFile[alreadySelectedCollection.size()]);
            IFile[] selectedFiles = LibProjectInfoUtil.selectAdditionalJarFiles(J2EEModelUIPlugin.getShell(), this._project.getProject(), alreadySelected);
            if (selectedFiles != null && selectedFiles.length != 0) {
                IJars jars = this.getProviderDescriptor().getJars();
                try {
                    IJarName jarName;
                    if (jars == null) {
                        jars = this.getProviderDescriptor().createJars(null);
                    }
                    ArrayList<IJarName> jarNameList = new ArrayList<IJarName>();
                    int i = 0;
                    while (i < selectedFiles.length) {
                        if (this._page.getJarfiles().get(selectedFiles[i].getName()) != null) {
                            MessageDialog.openError((Shell)J2EEModelUIPlugin.getShell(), (String)"Name already exists", (String)("There exists already a jar-file with the name " + selectedFiles[i].getName() + ". It is not possible to add another jar with the same name, even if it is located in a different folder."));
                        } else {
                            jarName = jars.createJarName(null);
                            jarName.setValue(selectedFiles[i].getName());
                            jarNameList.add(jarName);
                            this._page.getJarfiles().put(selectedFiles[i].getName(), selectedFiles[i]);
                        }
                        ++i;
                    }
                    jarName = jarNameList.toArray(new IJarName[jarNameList.size()]);
                    result = this.createParentHolder(parentHolder, jarName);
                }
                catch (J2eeCreateException e) {
                    TRACER.error(METHOD, "Can not create element: " + e.toString(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public boolean canRemoveElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value instanceof IJarName) {
            result = true;
        }
        return result;
    }

    public boolean removeElement(Object currentSelection) {
        String METHOD = "removeElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        if (value instanceof IJarName && this.getProviderDescriptor() != null && this.getProviderDescriptor().getJars() != null) {
            IJarName jarName = (IJarName)value;
            this._page.getJarfiles().remove(jarName.getValue());
            this.getProviderDescriptor().getJars().removeJarName(jarName);
            return true;
        }
        return false;
    }

    private ParentHolder createParentHolder(ParentHolder parentHolder, Object wrapped) {
        if (wrapped == null) {
            return null;
        }
        return new ParentHolder(parentHolder, wrapped);
    }

    private IProviderDescriptor getProviderDescriptor() {
        return this._holder.getProviderDescriptor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

