/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ITableSelectionComponentAdapter;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.TableSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent.TableRelationWrapper;
import com.tssap.j2ee.model.ext.ejbjarpersistent.ITableRelationAdditionalInfo;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IHelpTable;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ITableRelation;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.widgets.Text;

public class UISapEjbJarPersistentTableRelation
extends EditableDefaultObjectEditorComponent
implements ITableSelectionComponentAdapter {
    private static final String HELP_TABLE_HEADER = "Help-table for relations of type " + ITableRelationAdditionalInfo.RELATION_TYPE_TEXTS[3];
    private TableSelectionComponent _tableSelectionComponent;
    private Text _relationTypeTextField;
    private boolean _modifyCallbackActive = true;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(3, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Relation type");
        this._relationTypeTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        userArea.addPlaceholder();
        pane = userArea.addGridLayoutPane(HELP_TABLE_HEADER, 1, false, userArea.createGridLayoutData(4, 4, true, false));
        this._tableSelectionComponent = new TableSelectionComponent(this, null);
        this._tableSelectionComponent.createPartControl(pane);
        this.decorateControls();
    }

    private void decorateControls() {
        this._tableSelectionComponent.addModifyListener(this.getModifyAdapterSingleton());
    }

    public void refreshDataFromUI() {
        IHelpTable helpTable;
        super.refreshDataFromUI();
        if (this.getWrapper() != null && (helpTable = this.getTableRelation().getHelpTable()) != null) {
            String value = this._tableSelectionComponent.getTableName();
            helpTable.setValue(value);
        }
        this.updateSpecificEditableBehavior();
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this._modifyCallbackActive = false;
            if (this.getWrapper() != null) {
                String value = this.getAdditionalInfo().getTitle();
                this.setTitle(value);
                int relationType = this.getAdditionalInfo().getRelationType();
                this._relationTypeTextField.setText(ITableRelationAdditionalInfo.RELATION_TYPE_TEXTS[relationType]);
                IHelpTable helpTable = this.getTableRelation().getHelpTable();
                if (helpTable != null) {
                    this._tableSelectionComponent.refresh();
                }
                this.updateSpecificEditableBehavior();
            }
            Object var5_4 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        if (this.isEditable()) {
            // empty if block
        }
        this._relationTypeTextField.setEditable(false);
        ITableRelation tableRelation = this.getTableRelation();
        if (tableRelation != null) {
            IHelpTable helpTable = tableRelation.getHelpTable();
            this._tableSelectionComponent.setEditable(this.isEditable() && helpTable != null);
        }
    }

    public String getTableName() {
        IHelpTable helpTable;
        if (this.getTableRelation() != null && (helpTable = this.getTableRelation().getHelpTable()) != null) {
            return helpTable.getValue();
        }
        return null;
    }

    public void tableChanged() {
        this.handleEvent();
    }

    protected void handleEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    private ITableRelationAdditionalInfo getAdditionalInfo() {
        TableRelationWrapper wrapper = this.getWrapper();
        if (wrapper == null) {
            return null;
        }
        return wrapper.getAdditionalInfo();
    }

    private ITableRelation getTableRelation() {
        TableRelationWrapper wrapper = this.getWrapper();
        if (wrapper == null) {
            return null;
        }
        return wrapper.getTableRelation();
    }

    private TableRelationWrapper getWrapper() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        TableRelationWrapper result = null;
        if (value instanceof TableRelationWrapper) {
            result = (TableRelationWrapper)value;
        }
        return result;
    }
}

