/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent;

import com.sap.ide.eclipse.j2ee.model.ui.common.ColumnSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IColumnSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IColumnSelectionComponentAdapter;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.TableSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.IPersistentEjbMapHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent.TableRelationWrapper;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent.TableRelationshipRoleWrapper;
import com.sap.sql.catalog.Table;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IEntityBean;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IEntityBeans;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IFkColumn;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IHelpTable;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ITableName;
import com.tssap.util.ui.pane.IGridLayoutPane;

public class UISapEjbJarPersistentFkColumn
extends EditableDefaultObjectEditorComponent
implements IColumnSelectionComponentAdapter {
    public static final String TABLENAME_NOT_FOUND = "<tablename not specified>";
    private IPersistentEjbMapHolder _holder;
    private IColumnSelectionComponent _columnSelectionComponent;
    private boolean _modifyCallbackActive = true;

    public UISapEjbJarPersistentFkColumn(IPersistentEjbMapHolder holder) {
        this._holder = holder;
    }

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, true));
        this._columnSelectionComponent = new ColumnSelectionComponent(this);
        this._columnSelectionComponent.createPartControl(pane);
        pane.addPlaceholder();
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        IFkColumn fkColumn = this.getFkColumn();
        if (fkColumn != null) {
            String value = this._columnSelectionComponent.getColumnName();
            fkColumn.getColumnName().setValue(value == null ? "" : value);
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this._modifyCallbackActive = false;
            if (this.getFkColumn() != null) {
                String value = this.getFkColumn().getPkFieldName().getValue();
                this.setTitle(value);
                this._columnSelectionComponent.refresh();
            }
            Object var3_2 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
    }

    public String getColumnName() {
        if (this.getFkColumn() != null) {
            return this.getFkColumn().getColumnName().getValue();
        }
        return null;
    }

    public Table getTable() {
        String tableName = this.getTableName();
        return TableSelectionComponent.findTable(null, tableName);
    }

    public String getTableName() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        TableRelationshipRoleWrapper tableRelationshipRoleWrapper = (TableRelationshipRoleWrapper)parentHolder.getParent().getValue();
        TableRelationWrapper tableRelationWrapper = (TableRelationWrapper)parentHolder.getParent().getParent().getValue();
        if (tableRelationWrapper.getAdditionalInfo().getRelationType() == 3) {
            IHelpTable helpTable = tableRelationWrapper.getTableRelation().getHelpTable();
            if (helpTable != null) {
                return helpTable.getValue();
            }
        } else {
            String ejbName = tableRelationshipRoleWrapper.getAdditionalInfo().getEjbName();
            IEntityBeans entityBeans = this._holder.getPersistentEjbMap().getEntityBeans();
            if (entityBeans != null) {
                IEntityBean[] entityBean = entityBeans.getEntityBeans();
                int i = 0;
                while (i < entityBean.length) {
                    if (ejbName.equals(entityBean[i].getEjbName().getValue())) {
                        ITableName tableName = entityBean[i].getTableName();
                        return tableName.getValue();
                    }
                    ++i;
                }
            }
        }
        return TABLENAME_NOT_FOUND;
    }

    public void columnChanged() {
        this.handleEvent();
        this.refreshDataFromUI();
    }

    protected void handleEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    private IFkColumn getFkColumn() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        IFkColumn result = null;
        if (value instanceof IFkColumn) {
            result = (IFkColumn)value;
        }
        return result;
    }
}

