/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent;

import com.sap.ide.eclipse.j2ee.model.ui.common.ColumnSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IColumnSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IColumnSelectionComponentAdapter;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.TableSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.IPersistentEjbMapHolder;
import com.sap.sql.catalog.Table;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.SapEjbJarPersistentDefaultFactory;
import com.tssap.j2ee.model.ext.TypeSignatureWrapper;
import com.tssap.j2ee.model.ext.Util;
import com.tssap.j2ee.model.ext.ejbjarpersistent.IEntityBeanAdditionalInfo;
import com.tssap.j2ee.model.ext.ejbjarpersistent.IEntityBeansAdditionalInfo;
import com.tssap.j2ee.model.ext.ejbjarpersistent.IFieldMapAdditionalInfo;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IColumn;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IEntityBean;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IFieldMap;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class UISapEjbJarPersistentFieldMap
extends EditableDefaultObjectEditorComponent
implements IColumnSelectionComponentAdapter {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$persistent$UISapEjbJarPersistentFieldMap == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$persistent$UISapEjbJarPersistentFieldMap = UISapEjbJarPersistentFieldMap.class$("com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent.UISapEjbJarPersistentFieldMap")) : class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$persistent$UISapEjbJarPersistentFieldMap));
    public static final String TEXT_UNKNOWN_FIELDTYPE = "<unknown>";
    public static final String TEXT_ADDITIONAL_NOT_ACCESSIBLE = "Additional informations about this field are not available due to an internal error. Please try again or contact your support.";
    public static final String[] NON_PRIMARYKEY_TYPES = new String[]{"NoKey", "UniqueKey"};
    public static final String[] PRIMARYKEY_TYPES = new String[]{"PrimaryKey"};
    private IPersistentEjbMapHolder _holder;
    private Text _fieldTypeTextField;
    private Button _mapToSingleColumnCheckBoxButton;
    private IColumnSelectionComponent _columnSelectionComponent;
    private Combo _keyTypeCombo;
    private Text _informationTextPane;
    private boolean _modifyCallbackActive = true;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$persistent$UISapEjbJarPersistentFieldMap;

    public UISapEjbJarPersistentFieldMap(IPersistentEjbMapHolder holder) {
        this._holder = holder;
    }

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, true, true));
        pane.addTextLabel("Java type");
        this._fieldTypeTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        pane.addPlaceholder(2, 1);
        this._mapToSingleColumnCheckBoxButton = pane.addCheckBox("Map to single column (only dependent values can choose)", false, pane.createGridLayoutData(1, 2, 2, 1));
        pane.addPlaceholder(2, 1);
        IGridLayoutPane selectionPane = pane.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this._columnSelectionComponent = new ColumnSelectionComponent(this);
        this._columnSelectionComponent.createPartControl(selectionPane);
        pane.addPlaceholder(2, 1);
        pane.addTextLabel("Database column type");
        this._keyTypeCombo = pane.addComboBox(NON_PRIMARYKEY_TYPES, "", true, pane.createGridLayoutData(4, 4, true, false));
        pane.addPlaceholder(2, 1);
        pane.addTextLabel("Additional informations");
        this._informationTextPane = pane.addTextPane("", false, true, pane.createGridLayoutData(4, 4, true, true, 2, 6));
        this.decorateControls();
    }

    private void decorateControls() {
        this._keyTypeCombo.addModifyListener(this.getModifyAdapterSingleton());
        this._mapToSingleColumnCheckBoxButton.addSelectionListener((SelectionListener)new CheckboxListener());
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getFieldMap() != null) {
            String value;
            if (this.getFieldMap().getColumn() != null) {
                value = this._columnSelectionComponent.getColumnName();
                this.getFieldMap().getColumn().getColumnName().setValue(value);
            }
            value = this._keyTypeCombo.getText();
            this.getFieldMap().setAttribKeyType(value);
            this.refreshColumnNameFromUI();
        }
    }

    private void refreshColumnNameFromUI() {
        String METHOD = "refreshColumnNameFromUI()";
        IFieldMap fieldMap = this.getFieldMap();
        if (fieldMap != null) {
            try {
                if (this._mapToSingleColumnCheckBoxButton.getSelection()) {
                    IColumn element = fieldMap.getColumn();
                    if (element == null) {
                        element = SapEjbJarPersistentDefaultFactory.createColumn((IFieldMap)fieldMap, (String)fieldMap.getFieldName().getValue().toUpperCase());
                    } else {
                        String value = this._columnSelectionComponent.getColumnName();
                        element.getColumnName().setValue(value);
                    }
                } else {
                    IFieldMapAdditionalInfo additional = this.getFieldMapAdditionalInfo();
                    if (additional == null) {
                        TRACER.error(METHOD, "Internal error: Can not access the corresponding IFieldMapAdditionalInfo.");
                        return;
                    }
                    String[] dependentValueFields = additional.getDependentValueFields();
                    if (dependentValueFields == null) {
                        TRACER.error(METHOD, "Internal error: corresponding IFieldMapAdditionalInfo has no dependent value fields.");
                        return;
                    }
                    SapEjbJarPersistentDefaultFactory.addOrRemoveDvColumns((IFieldMap)fieldMap, (String[])dependentValueFields);
                }
            }
            catch (J2eeCreateException e) {
                TRACER.error(METHOD, "Can not create element: " + e.toString(), (Throwable)e);
            }
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this._modifyCallbackActive = false;
            if (this.getFieldMap() != null) {
                TypeSignatureWrapper type;
                String value = this.getFieldMap().getFieldName().getValue();
                this.setTitle(value);
                IFieldMapAdditionalInfo additional = this.getFieldMapAdditionalInfo();
                String fieldTypeText = TEXT_UNKNOWN_FIELDTYPE;
                if (additional != null && (type = additional.getType()) != null) {
                    fieldTypeText = type.getReadableFormat();
                }
                this._fieldTypeTextField.setText(fieldTypeText);
                boolean mapToSingleColumn = this.getFieldMap().getColumn() != null;
                this._mapToSingleColumnCheckBoxButton.setSelection(mapToSingleColumn);
                value = this.getFieldMap().getAttribKeyType();
                if (value.equals("PrimaryKey")) {
                    this._keyTypeCombo.setItems(PRIMARYKEY_TYPES);
                } else {
                    this._keyTypeCombo.setItems(NON_PRIMARYKEY_TYPES);
                }
                this._keyTypeCombo.setText(value);
                this.handleMapToSingleColumnCheckboxSelectionChange();
                String infoText = TEXT_ADDITIONAL_NOT_ACCESSIBLE;
                if (additional != null) {
                    infoText = additional.getAnalyzeException() != null ? "ERROR:\nException when analyzing the field. As a fallback only a mapping to a single column is possible. This means, that if you do not want to map this field to multiple columns (only possible for dependent values), you can ignore this problem and continue.\n\nDetails:\n" + additional.getAnalyzeException().toString() + "\n" + Util.getStacktrace((Throwable)additional.getAnalyzeException()) : (additional.isDependentValue() && additional.dependentValueHasNoEmptyConstructor() ? "ERROR:\nThe class of this dependent value has no public empty constructor. Because of this it can only be mapped to a single column" : (additional.isDependentValue() && additional.dependentValueHasNoPublicFields() ? "ERROR:\nThe class of this dependent value has no public fields. Because of this it can only be mapped to a single column" : (additional.getType().getArrayCount() > 0 ? "The java type of this field is an array. Because of this it can only be mapped to a single column" : (!additional.isDependentValue() ? "The java type of this field is not a dependent value. Because of this it can only be mapped to a single column" : "The java type of this field is a dependent value. Because of this it is possible to map every subfield of the dependent value class to an own column."))));
                }
                this._informationTextPane.setText(infoText);
            }
            this.updateSpecificEditableBehavior();
            Object var7_7 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        if (this.isEditable()) {
            // empty if block
        }
        this._fieldTypeTextField.setEditable(false);
        if (this.isEditable()) {
            // empty if block
        }
        this._informationTextPane.setEditable(false);
        this._columnSelectionComponent.setEditable(this.isEditable() && this._mapToSingleColumnCheckBoxButton.getSelection());
        if (this._keyTypeCombo.getText().equals("PrimaryKey")) {
            if (this.isEditable()) {
                // empty if block
            }
            this._keyTypeCombo.setEnabled(false);
        } else {
            this._keyTypeCombo.setEnabled(this.isEditable() && this._mapToSingleColumnCheckBoxButton.getSelection());
        }
        IFieldMapAdditionalInfo additional = this.getFieldMapAdditionalInfo();
        this._mapToSingleColumnCheckBoxButton.setEnabled(this.isEditable() && this.allowMultipleColumns(additional));
    }

    public String getColumnName() {
        if (this.getEntityBean() != null) {
            if (this.getFieldMap().getColumn() != null) {
                return this.getFieldMap().getColumn().getColumnName().getValue();
            }
            return null;
        }
        return null;
    }

    public Table getTable() {
        if (this.getEntityBean() != null) {
            String tableName = this.getTableName();
            return TableSelectionComponent.findTable(null, tableName);
        }
        return null;
    }

    public String getTableName() {
        if (this.getEntityBean() != null) {
            return this.getEntityBean().getTableName().getValue();
        }
        return null;
    }

    public void columnChanged() {
        this.handleEvent();
        this.refreshDataFromUI();
    }

    private IFieldMap getFieldMap() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        IFieldMap result = null;
        if (value instanceof IFieldMap) {
            result = (IFieldMap)value;
        }
        return result;
    }

    private IEntityBean getEntityBean() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null || parentHolder.getParent() == null) {
            return null;
        }
        Object value = parentHolder.getParent().getParent().getValue();
        IEntityBean result = null;
        if (value instanceof IEntityBean) {
            result = (IEntityBean)value;
        }
        return result;
    }

    private boolean allowMultipleColumns(IFieldMapAdditionalInfo additional) {
        boolean result = additional != null && additional.isDependentValue() && !additional.dependentValueHasNoEmptyConstructor() && !additional.dependentValueHasNoPublicFields();
        return result;
    }

    private IFieldMapAdditionalInfo getFieldMapAdditionalInfo() {
        if (this._holder == null || this._holder.getDeltaHandlerResults() == null) {
            return null;
        }
        IEntityBean entityBean = this.getEntityBean();
        IFieldMap fieldMap = this.getFieldMap();
        if (entityBean == null || fieldMap == null) {
            return null;
        }
        IEntityBeansAdditionalInfo entityBeansAdditionalInfo = this._holder.getDeltaHandlerResults().getEntityBeansAdditionalInfo();
        if (entityBeansAdditionalInfo == null) {
            return null;
        }
        IEntityBeanAdditionalInfo entityBeanAdditionalInfo = entityBeansAdditionalInfo.getEntityBean(entityBean.getEjbName().getValue());
        if (entityBeanAdditionalInfo == null) {
            return null;
        }
        IFieldMapAdditionalInfo result = entityBeanAdditionalInfo.getFieldMap(fieldMap.getFieldName().getValue());
        return result;
    }

    private void handleMapToSingleColumnCheckboxSelectionChange() {
        this.updateSpecificEditableBehavior();
        this._columnSelectionComponent.refresh();
    }

    protected void handleEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CheckboxListener
    extends SelectionAdapter {
        private CheckboxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == UISapEjbJarPersistentFieldMap.this._mapToSingleColumnCheckBoxButton) {
                UISapEjbJarPersistentFieldMap.this.refreshColumnNameFromUI();
                UISapEjbJarPersistentFieldMap.this.handleMapToSingleColumnCheckboxSelectionChange();
            }
            UISapEjbJarPersistentFieldMap.this.handleEvent();
        }
    }
}

