/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent;

import com.sap.ide.eclipse.j2ee.model.ui.J2EEModelUIPlugin;
import com.sap.ide.eclipse.j2ee.model.ui.db.GenerateDictionaryTablesDialog;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.IPersistentEjbMapHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.ISapEjbJarPersistentEditor;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent.SapEjbJarPersistentEditorPage;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.SapEjbJarPersistentDefaultFactory;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IDatabaseVendor;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ILocking;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IPersistentEjbMap;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SapEjbJarPersistentGeneralPage
extends SapEjbJarPersistentEditorPage
implements IModifiedCallback,
IPersistentEjbMapHolder {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$persistent$SapEjbJarPersistentGeneralPage == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$persistent$SapEjbJarPersistentGeneralPage = SapEjbJarPersistentGeneralPage.class$("com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent.SapEjbJarPersistentGeneralPage")) : class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$persistent$SapEjbJarPersistentGeneralPage));
    public static final String[] DATABASE_VENDORS = new String[]{"DB2_UDB", "DB2_UDB_AS400", "DB2_UDB_OS390", "MS_SQL_SERVER", "ORACLE", "SAPDB"};
    public static final String DEFAULT_DATABASE_VENDOR = "SAPDB";
    public static final String TYPE_ADMINISTRATIVE = "Administrative";
    public static final String TYPE_TABLE = "Table";
    public static final String TYPE_LOCAL = "Local";
    private boolean _isModListenerActive = false;
    private IGridLayoutPane _mainGrid;
    private Text _dataSourceNameTextField;
    private Button _useDatabaseVendorCheckboxButton;
    private Combo _databaseVendorComboBox;
    private Button _switchOffVerificationCheckboxButton;
    private Button _lockingTypeAdministrativeRadioButton;
    private Button _lockingTypeTableRadioButton;
    private Button _lockingTypeLocalRadioButton;
    private Button _createTablesButton;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$persistent$SapEjbJarPersistentGeneralPage;

    public SapEjbJarPersistentGeneralPage(Composite parent, ISapEjbJarPersistentEditor editor) {
        super(parent, editor, 1);
    }

    public String getPageName() {
        return "General";
    }

    public Control createControls(IGridLayoutPane grid) {
        this._mainGrid = grid;
        grid.addTextLabel("Datasource name");
        this._dataSourceNameTextField = grid.addTextField("", false, grid.createGridLayoutData(4, 4, true, false, 1, 1));
        this._useDatabaseVendorCheckboxButton = grid.addCheckBox("Specify database vendor (optional hint, to allow database-specific handling)", false, grid.createGridLayoutData(1, 2, 1, 1));
        grid.addTextLabel("Database vendor");
        this._databaseVendorComboBox = grid.addComboBox(DATABASE_VENDORS, "", true, grid.createGridLayoutData(4, 4, true, false));
        grid.addPlaceholder();
        this._switchOffVerificationCheckboxButton = grid.addCheckBox("Switch off verification of database-tables at deploy-time", false, grid.createGridLayoutData(1, 2, 1, 1));
        grid.addPlaceholder();
        this._lockingTypeLocalRadioButton = grid.addRadioButton("No automatic locking (except some local simulation)");
        this._lockingTypeTableRadioButton = grid.addRadioButton("Automatic locking");
        this._lockingTypeAdministrativeRadioButton = grid.addRadioButton("Automatic locking, but tables are not defined in the data dictionary (not recommended)");
        grid.addPlaceholder();
        grid.addPlaceholder();
        return grid.getComposite();
    }

    protected void decorateControls() {
        this._dataSourceNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SapEjbJarPersistentGeneralPage.this.dataModified(true);
            }
        });
        this._databaseVendorComboBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SapEjbJarPersistentGeneralPage.this.dataModified(true);
            }
        });
        this._useDatabaseVendorCheckboxButton.addSelectionListener((SelectionListener)new CheckboxListener());
        this._switchOffVerificationCheckboxButton.addSelectionListener((SelectionListener)new CheckboxListener());
        this._lockingTypeAdministrativeRadioButton.addSelectionListener((SelectionListener)new CheckboxListener());
        this._lockingTypeTableRadioButton.addSelectionListener((SelectionListener)new CheckboxListener());
        this._lockingTypeLocalRadioButton.addSelectionListener((SelectionListener)new CheckboxListener());
        if (this._createTablesButton != null) {
            this._createTablesButton.addSelectionListener((SelectionListener)new ButtonPressedListener());
        }
    }

    protected void initControlsWithData() {
        try {
            this._isModListenerActive = false;
            if (this.getPersistentEjbMap() != null) {
                String value = this.getPersistentEjbMap().getDbProperties().getDataSourceName().getValue();
                this._dataSourceNameTextField.setText(value == null ? "" : value);
                IDatabaseVendor databaseVendor = this.getPersistentEjbMap().getDbProperties().getDatabaseVendor();
                this._useDatabaseVendorCheckboxButton.setSelection(databaseVendor != null);
                this.handleUseDatabaseVendorCheckboxSelectionChange();
                boolean selected = this.getPersistentEjbMap().getSwitchOffVerification() != null;
                this._switchOffVerificationCheckboxButton.setSelection(selected);
                this._lockingTypeAdministrativeRadioButton.setSelection(false);
                this._lockingTypeTableRadioButton.setSelection(false);
                this._lockingTypeLocalRadioButton.setSelection(false);
                ILocking locking = this.getPersistentEjbMap().getLocking();
                if (locking == null || locking.getAttribType().equals(TYPE_ADMINISTRATIVE)) {
                    this._lockingTypeAdministrativeRadioButton.setSelection(true);
                } else if (locking.getAttribType().equals(TYPE_LOCAL)) {
                    this._lockingTypeLocalRadioButton.setSelection(true);
                } else if (locking.getAttribType().equals(TYPE_TABLE)) {
                    this._lockingTypeTableRadioButton.setSelection(true);
                }
            }
            Object var6_5 = null;
            this._isModListenerActive = true;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._isModListenerActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        this._databaseVendorComboBox.setEnabled(this.isEditable() && this._useDatabaseVendorCheckboxButton.getSelection());
    }

    protected void updateDataFromControls() {
        String METHOD = "updateDataFromControls()";
        if (TRACER.debug()) {
            TRACER.debug(METHOD, "");
        }
        if (this.getPersistentEjbMap() != null) {
            String value = this._dataSourceNameTextField.getText();
            this.getPersistentEjbMap().getDbProperties().getDataSourceName().setValue(value);
            value = this._databaseVendorComboBox.getText();
            if (!this._useDatabaseVendorCheckboxButton.getSelection()) {
                value = null;
            }
            try {
                SapEjbJarPersistentDefaultFactory.addOrRemoveDatabaseVendor((IPersistentEjbMap)this.getPersistentEjbMap(), (String)value);
            }
            catch (J2eeCreateException e) {
                TRACER.error(METHOD, "Cannot create tag: " + e.toString(), (Throwable)e);
            }
            boolean selected = this._switchOffVerificationCheckboxButton.getSelection();
            try {
                SapEjbJarPersistentDefaultFactory.addOrRemoveSwitchOffVerification((IPersistentEjbMap)this.getPersistentEjbMap(), (boolean)selected);
            }
            catch (J2eeCreateException e) {
                TRACER.error(METHOD, "Cannot create tag: " + e.toString(), (Throwable)e);
            }
            try {
                ILocking locking = this.getPersistentEjbMap().getLocking();
                if (locking == null) {
                    locking = this.getPersistentEjbMap().createLocking(null);
                }
                if (this._lockingTypeLocalRadioButton.getSelection()) {
                    locking.setAttribType(TYPE_LOCAL);
                } else if (this._lockingTypeTableRadioButton.getSelection()) {
                    locking.setAttribType(TYPE_TABLE);
                } else {
                    locking.setAttribType(TYPE_ADMINISTRATIVE);
                }
            }
            catch (J2eeCreateException e) {
                TRACER.error(METHOD, "Cannot create tag: " + e.toString(), (Throwable)e);
            }
        }
    }

    public void dataModified(boolean modified) {
        if (this._isModListenerActive) {
            this.getEditor().setDirtyFlag(modified);
        }
    }

    private void handleUseDatabaseVendorCheckboxSelectionChange() {
        this.updateSpecificEditableBehavior();
        if (this._useDatabaseVendorCheckboxButton.getSelection()) {
            if (this.getPersistentEjbMap() != null) {
                IDatabaseVendor databaseVendor = this.getPersistentEjbMap().getDbProperties().getDatabaseVendor();
                if (databaseVendor == null) {
                    this._databaseVendorComboBox.setText(DEFAULT_DATABASE_VENDOR);
                } else {
                    String value = databaseVendor.getAttribName();
                    this._databaseVendorComboBox.setText(value);
                }
            }
        } else {
            this._databaseVendorComboBox.deselectAll();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CheckboxListener
    extends SelectionAdapter {
        private CheckboxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == SapEjbJarPersistentGeneralPage.this._useDatabaseVendorCheckboxButton) {
                SapEjbJarPersistentGeneralPage.this.handleUseDatabaseVendorCheckboxSelectionChange();
            }
            SapEjbJarPersistentGeneralPage.this.dataModified(true);
        }
    }

    private class ButtonPressedListener
    extends SelectionAdapter {
        private ButtonPressedListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == SapEjbJarPersistentGeneralPage.this._createTablesButton) {
                boolean proceed = MessageDialog.openQuestion((Shell)J2EEModelUIPlugin.getShell(), (String)"Proceed with BETA functionality?", (String)"This is an unsupported BETA functionality. You must not use it in productive environments. It will only create templates, which you have to check for correctness afterwards. Do you really want to proceed?");
                if (!proceed) {
                    return;
                }
                GenerateDictionaryTablesDialog dialog = new GenerateDictionaryTablesDialog(SapEjbJarPersistentGeneralPage.this.getPersistentEjbMap(), SapEjbJarPersistentGeneralPage.this.getDeltaHandlerResults());
                dialog.open();
            }
        }
    }
}

