/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent;

import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.IPersistentEjbMapHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent.TableRelationWrapper;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.persistent.TableRelationshipRoleWrapper;
import com.tssap.j2ee.model.ext.ejbjarpersistent.ITableRelationAdditionalInfo;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IPersistentEjbMap;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ITableRelation;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ITableRelationshipRole;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RelationshipsContentProvider
implements ITreeContentProvider {
    private static final ParentHolder[] EMPTY_PARENTHOLDER_ARRAY = new ParentHolder[0];
    private static final ITableRelation[] EMPTY_RELATION_ARRAY = new ITableRelation[0];
    private IPersistentEjbMap _persistentEjbMap;
    private IPersistentEjbMapHolder _holder;

    public RelationshipsContentProvider(IPersistentEjbMapHolder holder) {
        this._holder = holder;
    }

    public Object[] getChildren(Object parentElement) {
        ParentHolder parentHolder = (ParentHolder)parentElement;
        Object value = parentHolder.getValue();
        if (value instanceof TableRelationWrapper) {
            TableRelationWrapper wrapper = (TableRelationWrapper)value;
            ITableRelationshipRole[] role = wrapper.getTableRelation().getTableRelationshipRoles();
            if (!wrapper.getAdditionalInfo().getLeft().matchRole(role[0])) {
                throw new RuntimeException("Additional info[0] does not match ITableRelationshipRole " + role[0]);
            }
            if (!wrapper.getAdditionalInfo().getRight().matchRole(role[1])) {
                throw new RuntimeException("Additional info[1] does not match ITableRelationshipRole " + role[1]);
            }
            Object[] result = new TableRelationshipRoleWrapper[]{new TableRelationshipRoleWrapper(role[0], wrapper.getAdditionalInfo().getLeft()), new TableRelationshipRoleWrapper(role[1], wrapper.getAdditionalInfo().getRight())};
            return ParentHolder.wrapObjects(parentHolder, result);
        }
        if (value instanceof TableRelationshipRoleWrapper) {
            TableRelationshipRoleWrapper wrapper = (TableRelationshipRoleWrapper)value;
            Object[] result = wrapper.getTableRelationshipRole().getFkColumns();
            return ParentHolder.wrapObjects(parentHolder, result);
        }
        return EMPTY_PARENTHOLDER_ARRAY;
    }

    public Object getParent(Object element) {
        ParentHolder parentHolder = (ParentHolder)element;
        return parentHolder.getParent();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        ITableRelation[] relation = this.getRelationships();
        Object[] result = new TableRelationWrapper[relation.length];
        int i = 0;
        while (i < relation.length) {
            ITableRelationAdditionalInfo additional = this._holder.getDeltaHandlerResults().getRelationshipsAdditionalInfo().findMatchingRelation(relation[i]);
            if (additional == null) {
                throw new RuntimeException("No additional info found for the ITableRelation " + relation[i]);
            }
            result[i] = new TableRelationWrapper(relation[i], additional);
            ++i;
        }
        return ParentHolder.wrapObjects(null, result);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IPersistentEjbMap) {
            this._persistentEjbMap = (IPersistentEjbMap)newInput;
        }
    }

    private ITableRelation[] getRelationships() {
        if (this._persistentEjbMap != null && this._persistentEjbMap.getRelationships() != null) {
            return this._persistentEjbMap.getRelationships().getTableRelations();
        }
        return EMPTY_RELATION_ARRAY;
    }
}

