/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description.IsolationMethodChooserResult;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ejb.IBusinessMethod;
import com.tssap.j2ee.model.ext.ejbjar.dd.IMethod;
import com.tssap.j2ee.model.ext.ejbjar.dd.IMethodIntf;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;

public class UISapEjbJarDescriptionIsolationMethod
extends EditableDefaultObjectEditorComponent {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$description$UISapEjbJarDescriptionIsolationMethod == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$description$UISapEjbJarDescriptionIsolationMethod = UISapEjbJarDescriptionIsolationMethod.class$("com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description.UISapEjbJarDescriptionIsolationMethod")) : class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$description$UISapEjbJarDescriptionIsolationMethod));
    private static final String ALL = "<all>";
    private static final String[] BUSINESS_LOCAL = new String[]{"<all>", "Local"};
    private static final String[] BUSINESS_REMOTE = new String[]{"<all>", "Remote"};
    private static final String[] BUSINESS_ALL = new String[]{"<all>", "Local", "Remote"};
    private static final String[] HOME_LOCALHOME = new String[]{"<all>", "LocalHome"};
    private static final String[] HOME_HOME = new String[]{"<all>", "Home"};
    private static final String[] HOME_ALL = new String[]{"<all>", "LocalHome", "Home"};
    private static final String[] OTHER_METHODS = new String[]{"<all>"};
    private Combo _methodIntfCombo;
    private boolean _modifyCallbackActive = true;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$sapejbjar$internal$description$UISapEjbJarDescriptionIsolationMethod;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Affected interface");
        this._methodIntfCombo = pane.addComboBox(new String[0], "", true, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this._methodIntfCombo.addModifyListener((ModifyListener)new NameModifyAdapter());
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        this.refreshMethodIntfFromUI();
    }

    private void refreshMethodIntfFromUI() {
        String METHOD = "refreshMethodIntfFromUI()";
        if (this.getMethod() != null && this.getMethod().getMethod() != null) {
            IMethod element = this.getMethod().getMethod();
            String value = this._methodIntfCombo.getText();
            if (value.equals(ALL)) {
                element.removeMethodIntf();
            } else {
                try {
                    IMethodIntf methodIntf = element.getMethodIntf();
                    if (methodIntf == null) {
                        methodIntf = element.createMethodIntf(null);
                    }
                    methodIntf.setValue(value);
                }
                catch (J2eeCreateException e) {
                    TRACER.error(METHOD, "Can not create element: " + e.toString(), (Throwable)e);
                }
            }
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this._modifyCallbackActive = false;
            IsolationMethodChooserResult method = this.getMethod();
            if (method != null) {
                if (method.getMethod() != null) {
                    if (method.getSingleMethod().getType() == 2) {
                        IBusinessMethod casted = (IBusinessMethod)method.getSingleMethod();
                        boolean local = casted.isLocalExposed();
                        boolean remote = casted.isRemoteExposed();
                        if (local && !remote) {
                            this._methodIntfCombo.setItems(BUSINESS_LOCAL);
                        } else if (remote && !local) {
                            this._methodIntfCombo.setItems(BUSINESS_REMOTE);
                        } else {
                            this._methodIntfCombo.setItems(BUSINESS_ALL);
                        }
                    } else if (method.getSingleMethod().getType() == 1) {
                        boolean local = true;
                        boolean home = true;
                        if (local && !home) {
                            this._methodIntfCombo.setItems(HOME_LOCALHOME);
                        } else if (home && !local) {
                            this._methodIntfCombo.setItems(HOME_HOME);
                        } else {
                            this._methodIntfCombo.setItems(HOME_ALL);
                        }
                    } else {
                        this._methodIntfCombo.setItems(OTHER_METHODS);
                    }
                } else {
                    this._methodIntfCombo.setItems(OTHER_METHODS);
                }
                String methodIntf = method.getMethodIntf();
                if (methodIntf == null || methodIntf.length() == 0) {
                    methodIntf = ALL;
                }
                this._methodIntfCombo.setText(methodIntf);
                if (method.getSingleMethodAsString() != null) {
                    this.setTitle(method.getSingleMethodAsString());
                } else {
                    this.setTitle("*");
                }
                this.updateSpecificEditableBehavior();
            }
            Object var6_7 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        boolean methodEnabled = false;
        IsolationMethodChooserResult method = this.getMethod();
        if (method != null && method.getMethod() != null) {
            int type = method.getSingleMethod().getType();
            methodEnabled = type == 2 || type == 1;
        }
        this._methodIntfCombo.setEnabled(this.isEditable() && methodEnabled);
    }

    private IsolationMethodChooserResult getMethod() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        IsolationMethodChooserResult result = null;
        if (value instanceof IsolationMethodChooserResult) {
            result = (IsolationMethodChooserResult)((Object)value);
        }
        return result;
    }

    protected void handleNameModifyEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        this.refreshMethodIntfFromUI();
        super.handleEvent();
    }

    protected void handleEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            UISapEjbJarDescriptionIsolationMethod.this.handleNameModifyEvent();
        }
    }
}

