/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description;

import com.tssap.j2ee.model.ejb.IEjbMethod;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.ext.SapEjbJarDescriptionDefaultFactory;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEjbName;
import com.tssap.j2ee.model.ext.ejbjar.dd.IIsolationLevel;
import com.tssap.j2ee.model.ext.ejbjar.dd.IMethod;
import com.tssap.j2ee.model.ext.ejbjar.dd.IMethodIntf;
import com.tssap.j2ee.ui.dialog.AbstractMethodChooserResult;
import com.tssap.j2ee.ui.dialog.IMethodChooserResult;
import java.util.ArrayList;

public final class IsolationMethodChooserResult
extends AbstractMethodChooserResult {
    private static final IsolationMethodChooserResult[] EMPTY_ARRAY = new IsolationMethodChooserResult[0];
    IEjbAssemblyProject _project;
    private IIsolationLevel _isolationLevel;
    private IMethod _method;
    private IEjbName _ejbNameObject;
    private int _type;
    private IEnterpriseJavaBean _bean;
    private String _ejbName;
    private IEjbMethod _singleMethod;
    private String _singleMethodAsString;
    private IMethodChooserResult _parent;
    private IMethodChooserResult[] _child;

    protected IsolationMethodChooserResult(IEjbAssemblyProject project, IIsolationLevel isolationLevel, IMethod method) {
        this._project = project;
        this._isolationLevel = isolationLevel;
        this._method = method;
        this._parent = null;
        this._child = EMPTY_ARRAY;
        this._bean = this._project.getReferencedEjb(this._method.getEjbName().getValue());
        this._ejbName = this._bean.getEjbName();
        this._singleMethod = SapEjbJarDescriptionDefaultFactory.getEjbMethod((IEnterpriseJavaBean)this._bean, (IMethod)this._method);
        if (this._singleMethod != null) {
            this._type = 7;
            this._singleMethodAsString = SapEjbJarDescriptionDefaultFactory.getEjbMethodAsString((IEjbMethod)this._singleMethod);
        } else {
            this._type = 6;
            IMethodIntf methodIntf = this._method.getMethodIntf();
            if (methodIntf != null) {
                String value = methodIntf.getValue();
                if (value.equals("Remote") || value.equals("Local")) {
                    this._type = 2;
                } else if (value.equals("Home") || value.equals("LocalHome")) {
                    this._type = 1;
                }
            }
        }
    }

    protected IsolationMethodChooserResult(IEjbAssemblyProject project, IIsolationLevel isolationLevel, IEjbName ejbName) {
        this._project = project;
        this._isolationLevel = isolationLevel;
        this._ejbNameObject = ejbName;
        this._parent = null;
        this._child = EMPTY_ARRAY;
        this._bean = this._project.getReferencedEjb(this._ejbNameObject.getValue());
        this._ejbName = this._bean.getEjbName();
        this._type = 6;
    }

    public final int getType() {
        return this._type;
    }

    public final IEnterpriseJavaBean getBean() {
        return this._bean;
    }

    public final String getEjbName() {
        return this._ejbName;
    }

    public final IEjbMethod getSingleMethod() {
        return this._singleMethod;
    }

    public final String getSingleMethodAsString() {
        return this._singleMethodAsString;
    }

    public final IMethodChooserResult getParent() {
        return this._parent;
    }

    public final IMethodChooserResult[] getChildren() {
        return this._child;
    }

    public final IIsolationLevel getIsolationLevel() {
        return this._isolationLevel;
    }

    public final IMethod getMethod() {
        return this._method;
    }

    public final IEjbName getEjbNameObject() {
        return this._ejbNameObject;
    }

    public final String getMethodIntf() {
        if (this._method == null) {
            return null;
        }
        IMethodIntf intf = this._method.getMethodIntf();
        if (intf == null) {
            return null;
        }
        return intf.getValue();
    }

    public static IsolationMethodChooserResult[] create(IEjbAssemblyProject project, IIsolationLevel isolationLevel) {
        ArrayList<IsolationMethodChooserResult> resultList = new ArrayList<IsolationMethodChooserResult>();
        IMethod[] method = isolationLevel.getMethods();
        int i = 0;
        while (i < method.length) {
            resultList.add(new IsolationMethodChooserResult(project, isolationLevel, method[i]));
            ++i;
        }
        IEjbName[] ejbName = isolationLevel.getEjbNames();
        int i2 = 0;
        while (i2 < ejbName.length) {
            resultList.add(new IsolationMethodChooserResult(project, isolationLevel, ejbName[i2]));
            ++i2;
        }
        IsolationMethodChooserResult[] result = new IsolationMethodChooserResult[resultList.size()];
        resultList.toArray(result);
        return result;
    }
}

