/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description;

import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description.EjbNameIsolationWrapper;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description.IsolationLevelFolderWrapper;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description.IsolationMethodChooserResult;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.swt.graphics.Image;

public class IsolationLevelLabelProvider
extends J2eeModelLabelProvider {
    public static final Image IMAGE_FOLDER = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_FOLDER");
    public static final Image IMAGE_ENTITY = UIPlugin.getImage((String)"entityBean");
    public static final Image IMAGE_SESSION = UIPlugin.getImage((String)"sessionBean");
    public static final Image IMAGE_MESSAGE = UIPlugin.getImage((String)"messagedrivenBean");
    public static final Image IMAGE_BUSINESS_METHOD = UIPlugin.getImage((String)"businessMethod");
    public static final Image IMAGE_BUSINESS_METHOD_LOCAL = UIPlugin.getImage((String)"localPropagated");
    public static final Image IMAGE_BUSINESS_METHOD_REMOTE = UIPlugin.getImage((String)"remotePropagated");
    public static final Image IMAGE_HOME_METHOD = UIPlugin.getImage((String)"homeMethod");
    public static final Image IMAGE_HOME_METHOD_HOME = UIPlugin.getImage((String)"homeMethod");
    public static final Image IMAGE_HOME_METHOD_LOCAL_HOME = UIPlugin.getImage((String)"homeMethod");
    public static final Image IMAGE_DEFAULT_METHOD = UIPlugin.getImage((String)"defaultMethod");
    public static final Image IMAGE_CREATE_METHOD = UIPlugin.getImage((String)"createMethod");
    public static final Image IMAGE_FINDER_METHOD = UIPlugin.getImage((String)"finderMethod");
    public static final Image IMAGE_SELECT_METHOD = UIPlugin.getImage((String)"selectMethod");
    public static final String SPECIFYABLE_ISOLATION_LEVEL_TEXT = "repeatable read";
    public static final String TEXT_ALL_METHODS = "*";

    public Image getImage(Object element) {
        ParentHolder parentHolder = (ParentHolder)element;
        Object value = parentHolder.getValue();
        Image result = null;
        if (value instanceof IsolationLevelFolderWrapper) {
            result = IMAGE_FOLDER;
        } else if (value instanceof EjbNameIsolationWrapper) {
            EjbNameIsolationWrapper casted = (EjbNameIsolationWrapper)value;
            if (casted.getType() == 0) {
                result = IMAGE_ENTITY;
            } else if (casted.getType() == 1) {
                result = IMAGE_SESSION;
            } else if (casted.getType() == 2) {
                result = IMAGE_MESSAGE;
            }
        } else if (value instanceof IsolationMethodChooserResult) {
            IsolationMethodChooserResult casted = (IsolationMethodChooserResult)((Object)value);
            if (casted.getType() == 7) {
                int methodType = casted.getSingleMethod().getType();
                if (methodType == 2) {
                    result = IMAGE_BUSINESS_METHOD;
                    String methodIntf = casted.getMethodIntf();
                    boolean first = "Local".equals(methodIntf);
                    boolean second = "Remote".equals(methodIntf);
                    if (first && !second) {
                        result = IMAGE_BUSINESS_METHOD_LOCAL;
                    }
                    if (second && !first) {
                        result = IMAGE_BUSINESS_METHOD_REMOTE;
                    }
                } else if (methodType == 1) {
                    result = IMAGE_HOME_METHOD;
                    String methodIntf = casted.getMethodIntf();
                    boolean first = "LocalHome".equals(methodIntf);
                    boolean second = "Home".equals(methodIntf);
                    if (first && !second) {
                        result = IMAGE_HOME_METHOD_LOCAL_HOME;
                    }
                    if (second && !first) {
                        result = IMAGE_HOME_METHOD_HOME;
                    }
                } else if (methodType == 3) {
                    result = IMAGE_CREATE_METHOD;
                } else if (methodType == 4) {
                    result = IMAGE_FINDER_METHOD;
                } else if (methodType == 5) {
                    result = IMAGE_SELECT_METHOD;
                }
            } else {
                result = IMAGE_DEFAULT_METHOD;
            }
        }
        return result;
    }

    public String getText(Object element) {
        ParentHolder parentHolder = (ParentHolder)element;
        Object value = parentHolder.getValue();
        String result = null;
        if (value instanceof IsolationLevelFolderWrapper) {
            IsolationLevelFolderWrapper casted = (IsolationLevelFolderWrapper)value;
            if (casted.getType() == "Repeatable") {
                result = SPECIFYABLE_ISOLATION_LEVEL_TEXT;
            }
        } else if (value instanceof EjbNameIsolationWrapper) {
            EjbNameIsolationWrapper casted = (EjbNameIsolationWrapper)value;
            result = casted.getEjbName();
        } else if (value instanceof IsolationMethodChooserResult) {
            IsolationMethodChooserResult casted = (IsolationMethodChooserResult)((Object)value);
            int type = casted.getType();
            result = type == 7 ? casted.getSingleMethodAsString() : TEXT_ALL_METHODS;
        }
        return result;
    }
}

