/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description;

import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.IEjbJ2eeEngineHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description.EjbNameIsolationWrapper;
import com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.internal.description.IsolationMethodChooserResult;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEjbJ2eeEngine;
import com.tssap.j2ee.model.ext.ejbjar.dd.IIsolationLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class IsolationLevelFolderWrapper {
    public static final String SPECIFYABLE_ISOLATION_LEVEL = "Repeatable";
    private static final EjbNameIsolationWrapper[] EMPTY_CHILDREN = new EjbNameIsolationWrapper[0];
    private String _type;
    private IEjbJ2eeEngineHolder _holder;
    private IEjbAssemblyProject _ejbAssemblyProject;
    private EjbNameIsolationWrapper[] _children;
    private Map _childrenMap;

    public IsolationLevelFolderWrapper(IEjbAssemblyProject ejbAssemblyProject, IEjbJ2eeEngineHolder holder, String type) {
        this._ejbAssemblyProject = ejbAssemblyProject;
        this._holder = holder;
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public IEjbJ2eeEngine getEjbJ2eeEngine() {
        return this._holder.getEjbJ2eeEngine();
    }

    public EjbNameIsolationWrapper[] getChildren() {
        if (this._children == null) {
            this.createChildren();
        }
        if (this._children == null) {
            return EMPTY_CHILDREN;
        }
        return this._children;
    }

    public void resetChildren() {
        this._children = null;
    }

    public void createChildren() {
        IEjbJ2eeEngine ejbJ2eeEngine = this._holder.getEjbJ2eeEngine();
        if (ejbJ2eeEngine != null) {
            if (ejbJ2eeEngine.getTransactionDescriptor() == null) {
                this._children = EMPTY_CHILDREN;
            } else {
                IIsolationLevel[] isolationLevel = ejbJ2eeEngine.getTransactionDescriptor().getIsolationLevels();
                HashMap<String, ArrayList<IsolationMethodChooserResult>> resultMap = new HashMap<String, ArrayList<IsolationMethodChooserResult>>();
                int i = 0;
                while (i < isolationLevel.length) {
                    String isolationAttribute = isolationLevel[i].getIsolationAttribute().getValue();
                    if (this._type.equals(isolationAttribute)) {
                        IsolationMethodChooserResult[] allSubNodes = IsolationMethodChooserResult.create(this._ejbAssemblyProject, isolationLevel[i]);
                        int k = 0;
                        while (k < allSubNodes.length) {
                            ArrayList<IsolationMethodChooserResult> resultsPerEjbName = (ArrayList<IsolationMethodChooserResult>)resultMap.get(allSubNodes[k].getEjbName());
                            if (resultsPerEjbName == null) {
                                resultsPerEjbName = new ArrayList<IsolationMethodChooserResult>();
                                resultMap.put(allSubNodes[k].getEjbName(), resultsPerEjbName);
                            }
                            resultsPerEjbName.add(allSubNodes[k]);
                            ++k;
                        }
                    }
                    ++i;
                }
                EjbNameIsolationWrapper[] result = new EjbNameIsolationWrapper[resultMap.size()];
                int resultPos = 0;
                Iterator lists = resultMap.keySet().iterator();
                this._childrenMap = new HashMap();
                while (lists.hasNext()) {
                    String ejbName = (String)lists.next();
                    ArrayList nextList = (ArrayList)resultMap.get(ejbName);
                    IsolationMethodChooserResult[] chooser = new IsolationMethodChooserResult[nextList.size()];
                    nextList.toArray(chooser);
                    this._childrenMap.put(ejbName, chooser);
                    IEnterpriseJavaBean bean = chooser[0].getBean();
                    EjbNameIsolationWrapper wrapper = new EjbNameIsolationWrapper(this, bean);
                    result[resultPos++] = wrapper;
                }
                this._children = result;
            }
        }
    }

    protected IsolationMethodChooserResult[] getChildrenForEjbName(String ejbName) {
        return (IsolationMethodChooserResult[])this._childrenMap.get(ejbName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IsolationLevelFolderWrapper)) {
            return false;
        }
        IsolationLevelFolderWrapper other = (IsolationLevelFolderWrapper)o;
        return other.getType() == this.getType();
    }

    public int hashCode() {
        return this.getType().hashCode();
    }
}

