/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapear.internal;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableDefaultObjectEditorComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IReferenceComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IReferenceComponentAdapter;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.ReferenceComponent;
import com.tssap.j2ee.model.ext.ear.dd.IReference;
import com.tssap.j2ee.model.ext.ear.dd.IReferenceTarget;
import com.tssap.util.ui.pane.IGridLayoutPane;

public class UISapEarReference
extends EditableDefaultObjectEditorComponent
implements IReferenceComponentAdapter {
    private static final String[] REFERENCE_TYPES = new String[]{"hard", "weak"};
    private static final String[] REFERENCE_TARGET_TYPES = new String[]{"application", "interface", "library", "service"};
    private IReferenceComponent _referenceComponent;
    private boolean _modifyCallbackActive = true;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, true));
        this._referenceComponent = new ReferenceComponent(this, REFERENCE_TYPES, REFERENCE_TARGET_TYPES);
        this._referenceComponent.createPartControl(pane);
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getReference() != null) {
            this.refreshReferenceNameFromUI();
            String value = this._referenceComponent.getAttribProviderName();
            if (value != null && value.trim().length() != 0) {
                this.getReference().getReferenceTarget().setAttribProviderName(value);
            } else {
                this.getReference().getReferenceTarget().removeAttribProviderName();
            }
        }
    }

    private void refreshReferenceNameFromUI() {
        if (this.getReference() != null) {
            IReferenceTarget referenceTarget = this.getReference().getReferenceTarget();
            String value = this._referenceComponent.getReferenceTarget();
            referenceTarget.setValue(value);
            this.setTitle(value);
            value = this._referenceComponent.getAttribReferenceType();
            this.getReference().setAttribReferenceType(value);
            value = this._referenceComponent.getAttribTargetType();
            this.getReference().getReferenceTarget().setAttribTargetType(value);
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this._modifyCallbackActive = false;
            if (this.getReference() != null) {
                IReferenceTarget referenceTarget = this.getReference().getReferenceTarget();
                this.setTitle(referenceTarget.getValue());
                this._referenceComponent.refresh();
            }
            Object var3_2 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        this._referenceComponent.setEditable(this.isEditable());
    }

    public String getAttribProviderName() {
        if (this.getReference() != null && this.getReference().getReferenceTarget() != null) {
            return this.getReference().getReferenceTarget().getAttribProviderName();
        }
        return null;
    }

    public String getAttribTargetType() {
        if (this.getReference() != null && this.getReference().getReferenceTarget() != null) {
            return this.getReference().getReferenceTarget().getAttribTargetType();
        }
        return null;
    }

    public String getReferenceTarget() {
        if (this.getReference() != null && this.getReference().getReferenceTarget() != null) {
            return this.getReference().getReferenceTarget().getValue();
        }
        return null;
    }

    public String getAttribReferenceType() {
        if (this.getReference() != null) {
            return this.getReference().getAttribReferenceType();
        }
        return null;
    }

    public void referenceChanged() {
        this.refreshReferenceNameFromUI();
        this.handleEvent();
    }

    private IReference getReference() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        IReference result = null;
        if (value instanceof IReference) {
            result = (IReference)value;
        }
        return result;
    }

    protected void handleEvent() {
        if (!this._modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }
}

