/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapear.internal;

import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.j2ee.model.ui.IProjectHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.IApplicationJ2eeEngineHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.ISapEarEditor;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.internal.ReferencesAddRemoveCallback;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.internal.ReferencesContentProvider;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.internal.ReferencesLabelProvider;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.internal.ReferencesReusableManager;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.internal.SapEarEditorPage;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ext.ear.dd.IFailOverEnable;
import com.tssap.j2ee.model.ext.ear.dd.IProviderName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SapEarGeneralPage
extends SapEarEditorPage
implements IModifiedCallback,
IApplicationJ2eeEngineHolder,
IProjectHolder {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$sapear$internal$SapEarGeneralPage == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$sapear$internal$SapEarGeneralPage = SapEarGeneralPage.class$("com.sap.ide.eclipse.j2ee.model.ui.sapear.internal.SapEarGeneralPage")) : class$com$sap$ide$eclipse$j2ee$model$ui$sapear$internal$SapEarGeneralPage));
    public static final String[] FAILOVER_ATTRIBUTES = new String[]{"disable", "on_request", "on_attribute"};
    public static final String DEFAULT_FAILOVER_ATTRIBUTE = "disable";
    private boolean _isModListenerActive = false;
    private TreeSelectorEditorComponent _treeEditor;
    private Text _providerNameTextField;
    private Combo _failoverEnabledCombo;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$sapear$internal$SapEarGeneralPage;

    public SapEarGeneralPage(Composite parent, ISapEarEditor editor) {
        super(parent, editor, 1);
    }

    public String getPageName() {
        return "General";
    }

    public Control createControls(IGridLayoutPane grid) {
        IGridLayoutPane pane = grid.addGridLayoutPane(2, false, grid.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Vendor name");
        this._providerNameTextField = pane.addTextField("", false, grid.createGridLayoutData(4, 4, true, false, 1, 1));
        pane.addPlaceholder(2, 1);
        pane.addTextLabel("Failover");
        this._failoverEnabledCombo = pane.addComboBox(FAILOVER_ATTRIBUTES, "", true, pane.createGridLayoutData(1, 2, 1, 1));
        grid.addPlaceholder();
        TreeSelector treeSelector = new TreeSelector();
        treeSelector.setSplitterWeight(2);
        this._treeEditor = new TreeSelectorEditorComponent(treeSelector);
        this.registerTreeForEditableBehaviour(this._treeEditor);
        treeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this._treeEditor.setTreeContentProvider((ITreeContentProvider)new ReferencesContentProvider());
        this._treeEditor.setTreeLabelProvider((ILabelProvider)new ReferencesLabelProvider());
        this._treeEditor.setAddRemoveCallback((IAddRemoveCallback)new ReferencesAddRemoveCallback(this, this));
        this._treeEditor.setReusableManager((IReuseableManager)new ReferencesReusableManager());
        this._treeEditor.setModifiedCallback((IModifiedCallback)this);
        this._providerNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SapEarGeneralPage.this.dataModified(true);
            }
        });
        this._failoverEnabledCombo.addSelectionListener((SelectionListener)new FailoverCheckboxListener());
    }

    protected void initControlsWithData() {
        try {
            this._isModListenerActive = false;
            if (this.isComponentProject()) {
                String vendorName = this.getDCVendorName();
                this._providerNameTextField.setText(vendorName + "    <for Development Component Projects (DC) this value can only be changed in the DC-MetaData>");
            } else {
                IProviderName providerName = this.getApplicationJ2eeEngine().getProviderName();
                if (providerName != null) {
                    this._providerNameTextField.setText(providerName.getValue());
                } else {
                    this._providerNameTextField.setText("");
                }
            }
            IFailOverEnable failOverEnable = this.getApplicationJ2eeEngine().getFailOverEnable();
            if (failOverEnable != null) {
                this._failoverEnabledCombo.setText(failOverEnable.getAttribMode());
            } else {
                this._failoverEnabledCombo.setText(DEFAULT_FAILOVER_ATTRIBUTE);
            }
            this._treeEditor.setTreeInput((Object)this.getApplicationJ2eeEngine());
            Object var3_2 = null;
            this._isModListenerActive = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._isModListenerActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        this._providerNameTextField.setEditable(this.isEditable() && !this.isComponentProject());
    }

    protected void updateDataFromControls() {
        String METHOD = "updateDataFromControls()";
        if (TRACER.debug()) {
            TRACER.debug(METHOD, "");
        }
        try {
            String value;
            if (!this.isComponentProject()) {
                value = this._providerNameTextField.getText();
                if (value != null && value.trim().length() == 0) {
                    value = null;
                }
                IProviderName providerName = this.getApplicationJ2eeEngine().getProviderName();
                if (value != null) {
                    if (providerName == null) {
                        providerName = this.getApplicationJ2eeEngine().createProviderName(null);
                    }
                    providerName.setValue(value);
                } else {
                    this.getApplicationJ2eeEngine().removeProviderName();
                }
            }
            value = this._failoverEnabledCombo.getText();
            IFailOverEnable failoverEnable = this.getApplicationJ2eeEngine().getFailOverEnable();
            if (failoverEnable == null) {
                failoverEnable = this.getApplicationJ2eeEngine().createFailOverEnable(null);
            }
            failoverEnable.setAttribMode(value);
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Cannot create tag: " + e.toString(), (Throwable)e);
        }
        this._treeEditor.aboutToLeave();
    }

    private boolean isComponentProject() {
        IJ2eeProject j2eeProject = this.getJ2eeProject();
        if (j2eeProject == null) {
            return false;
        }
        return J2eeProjectManager.isComponentProject((IJ2eeProject)j2eeProject);
    }

    private IJ2eeProject getJ2eeProject() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IJ2eeProject j2eeProject = J2eeProjectManager.getJ2eeProject((String)project.getName());
        return j2eeProject;
    }

    private String getDCVendorName() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IDevelopmentComponentNode node = ComponentUtil.getDCNode((IProject)project);
        return node == null ? null : node.getVendor();
    }

    public void dataModified(boolean modified) {
        if (this._isModListenerActive) {
            this.getEditor().setDirtyFlag(modified);
        }
        this.getTreeSelector().refreshTree(true);
    }

    private TreeSelector getTreeSelector() {
        TreeSelector result = null;
        if (this._treeEditor != null) {
            result = this._treeEditor.getTreeSelector();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FailoverCheckboxListener
    extends SelectionAdapter {
        private FailoverCheckboxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SapEarGeneralPage.this.dataModified(true);
        }
    }
}

