/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.sapear.internal;

import com.sap.ide.eclipse.j2ee.model.ui.IProjectHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.ParentHolder;
import com.sap.ide.eclipse.j2ee.model.ui.common.ReferencesHelper;
import com.sap.ide.eclipse.j2ee.model.ui.common.dialog.StringChooserDialog;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.IApplicationJ2eeEngineHolder;
import com.sap.ide.eclipse.j2ee.model.ui.sapear.internal.ReferencesContentProvider;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ext.SapEarDefaultFactory;
import com.tssap.j2ee.model.ext.ear.dd.IApplicationJ2eeEngine;
import com.tssap.j2ee.model.ext.ear.dd.IReference;
import com.tssap.tools.addlib.AddLibManager;
import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibDefinition;
import com.tssap.tools.addlib.IAddLibManager;
import com.tssap.tools.addlib.internal.AddLibDefinition;
import com.tssap.tools.ui.addlib.dialog.AddLibSelectionDialog;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ReferencesAddRemoveCallback
implements IAddRemoveCallback {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$sapear$internal$ReferencesAddRemoveCallback == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$sapear$internal$ReferencesAddRemoveCallback = ReferencesAddRemoveCallback.class$("com.sap.ide.eclipse.j2ee.model.ui.sapear.internal.ReferencesAddRemoveCallback")) : class$com$sap$ide$eclipse$j2ee$model$ui$sapear$internal$ReferencesAddRemoveCallback));
    private static final IReference[] EMPTY_REFERENCE_ARRAY = new IReference[0];
    private IApplicationJ2eeEngineHolder _holder;
    private IProjectHolder _projectHolder;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$sapear$internal$ReferencesAddRemoveCallback;

    public ReferencesAddRemoveCallback(IApplicationJ2eeEngineHolder holder, IProjectHolder projectHolder) {
        this._holder = holder;
        this._projectHolder = projectHolder;
    }

    public boolean canAddElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value == ReferencesContentProvider.FOLDER_REFERENCES) {
            result = true;
        }
        return result;
    }

    public Object addElement(Object currentSelection) {
        IReference[] addedReferences;
        String METHOD = "addElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        ParentHolder result = null;
        if (this.getApplicationJ2eeEngine() != null && value == ReferencesContentProvider.FOLDER_REFERENCES && (addedReferences = this.openAddReferences()) != null && addedReferences.length > 0) {
            result = new ParentHolder(parentHolder, addedReferences[0]);
        }
        return result;
    }

    private IReference[] openAddReferences() {
        String METHOD = "openAddReferences()";
        IReference[] ret = null;
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog msgDiag = new MessageDialog(currentShell, "Please choose", null, "Do you want to create a new reference or select from known libraries", 3, new String[]{"Create new", "Select library/interface/service", "Select application"}, 1);
        int addNew = msgDiag.open();
        try {
            if (addNew == 0) {
                ret = new IReference[]{SapEarDefaultFactory.createReference((IApplicationJ2eeEngine)this.getApplicationJ2eeEngine())};
            } else if (addNew == 1) {
                IReference[] currentRefs = this.getApplicationJ2eeEngine().getReferences();
                AddLibDefinition[] currentAddLibs = new AddLibDefinition[currentRefs.length];
                int i = 0;
                while (i < currentRefs.length) {
                    currentAddLibs[i] = new AddLibDefinition(currentRefs[i].getReferenceTarget().getAttribProviderName(), currentRefs[i].getReferenceTarget().getValue());
                    ++i;
                }
                IAddLib[] selectedAddLibs = AddLibSelectionDialog.openSelection((Shell)currentShell, (IAddLibManager)AddLibManager.getManager(), (IAddLibDefinition[])currentAddLibs, (IAddLibDefinition[])currentAddLibs);
                if (selectedAddLibs != null && selectedAddLibs.length > 0) {
                    ArrayList<IReference> retList = new ArrayList<IReference>();
                    int i2 = 0;
                    while (i2 < selectedAddLibs.length) {
                        boolean isCurrentlyUsed = false;
                        int j = 0;
                        while (j < currentAddLibs.length && !isCurrentlyUsed) {
                            if (currentAddLibs[j].matches((IAddLibDefinition)selectedAddLibs[i2])) {
                                isCurrentlyUsed = true;
                            }
                            ++j;
                        }
                        if (!isCurrentlyUsed) {
                            IReference newRef = SapEarDefaultFactory.createReference((IApplicationJ2eeEngine)this.getApplicationJ2eeEngine());
                            newRef.getReferenceTarget().setValue(selectedAddLibs[i2].getName());
                            newRef.getReferenceTarget().setAttribProviderName(selectedAddLibs[i2].getVendor());
                            if (selectedAddLibs[i2].getSubType() == 2) {
                                newRef.getReferenceTarget().setAttribTargetType("library");
                            } else if (selectedAddLibs[i2].getSubType() == 3) {
                                newRef.getReferenceTarget().setAttribTargetType("interface");
                            } else if (selectedAddLibs[i2].getSubType() == 4) {
                                newRef.getReferenceTarget().setAttribTargetType("service");
                            }
                            retList.add(newRef);
                        }
                        ++i2;
                    }
                    ret = retList.toArray(new IReference[retList.size()]);
                }
            } else if (addNew == 2) {
                IReference[] destRefs = this.getApplicationJ2eeEngine().getReferences();
                ArrayList<String> destList = new ArrayList<String>();
                int i = 0;
                while (i < destRefs.length) {
                    if (destRefs[i].getReferenceTarget().getAttribTargetType().equals("application")) {
                        String value = ReferencesHelper.concatVendorAndName(destRefs[i].getReferenceTarget().getAttribProviderName(), destRefs[i].getReferenceTarget().getValue());
                        destList.add(value);
                    }
                    ++i;
                }
                String[] destNames = new String[destList.size()];
                destList.toArray(destNames);
                IEarProject earProject = J2eeProjectManager.getEarProject((String)this._projectHolder.getProject().getName());
                String[] sourceNames = ReferencesHelper.getAllApplicationDefinitions(earProject);
                String[] result = StringChooserDialog.openDialog(sourceNames, destNames, null, "Enterprise Application Projects");
                ret = this.handleReferenceSelection(destNames, result);
            }
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
        }
        return ret;
    }

    private IReference[] handleReferenceSelection(String[] before, String[] added) {
        String METHOD = "handleSelection()";
        ArrayList<IReference> resultList = new ArrayList<IReference>();
        if (added == null) {
            return EMPTY_REFERENCE_ARRAY;
        }
        try {
            int i = 0;
            while (i < added.length) {
                IReference ref = SapEarDefaultFactory.createReference((IApplicationJ2eeEngine)this.getApplicationJ2eeEngine());
                String[] split = ReferencesHelper.splitVendorAndName(added[i]);
                ref.getReferenceTarget().setAttribProviderName(split[0]);
                ref.getReferenceTarget().setValue(split[1]);
                ref.getReferenceTarget().setAttribTargetType("application");
                resultList.add(ref);
                ++i;
            }
        }
        catch (J2eeCreateException e) {
            TRACER.error(METHOD, "Can not create element: " + e.toString(), (Throwable)e);
        }
        IReference[] result = new IReference[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public boolean canRemoveElement(Object currentSelection) {
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value instanceof IReference) {
            result = true;
        }
        return result;
    }

    public boolean removeElement(Object currentSelection) {
        String METHOD = "removeElement(currentSelection)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "currentSelection = " + currentSelection);
        }
        ParentHolder parentHolder = (ParentHolder)currentSelection;
        Object value = null;
        if (parentHolder != null) {
            value = parentHolder.getValue();
        }
        boolean result = false;
        if (value instanceof IReference && this.getApplicationJ2eeEngine() != null) {
            this.getApplicationJ2eeEngine().removeReference((IReference)value);
            result = true;
        }
        return result;
    }

    private IApplicationJ2eeEngine getApplicationJ2eeEngine() {
        if (this._holder != null) {
            return this._holder.getApplicationJ2eeEngine();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

