/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.provider;

import com.sap.ide.eclipse.j2ee.model.ui.J2EEModelUIPlugin;
import com.sap.ide.eclipse.j2ee.model.ui.provider.ModelProviderPlugin;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.dd.IApplication;
import com.tssap.j2ee.model.ear.dd.impl.dom.Application;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.impl.dom.EjbJar;
import com.tssap.j2ee.model.ext.AdditionalDTDEntityResolver;
import com.tssap.j2ee.model.ext.ModelPlugin;
import com.tssap.j2ee.model.ext.SapDSAliasesDeltaHandler;
import com.tssap.j2ee.model.ext.SapEarDeltaHandler;
import com.tssap.j2ee.model.ext.SapEjbJarDescriptionDeltaHandler;
import com.tssap.j2ee.model.ext.SapEjbJarPersistentDeltaHandler;
import com.tssap.j2ee.model.ext.SapLogDeltaHandler;
import com.tssap.j2ee.model.ext.SapWarDeltaHandler;
import com.tssap.j2ee.model.ext.XMLParserHelper;
import com.tssap.j2ee.model.ext.dsaliases.dd.IDataSourceAliases;
import com.tssap.j2ee.model.ext.dsaliases.dd.impl.dom.DataSourceAliases;
import com.tssap.j2ee.model.ext.ear.dd.IApplicationJ2eeEngine;
import com.tssap.j2ee.model.ext.ear.dd.impl.dom.ApplicationJ2eeEngine;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEjbJ2eeEngine;
import com.tssap.j2ee.model.ext.ejbjar.dd.impl.dom.EjbJ2eeEngine;
import com.tssap.j2ee.model.ext.ejbjarpersistent.IPersistentDeltaHandlerResult;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IPersistentEjbMap;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.impl.dom.PersistentEjbMap;
import com.tssap.j2ee.model.ext.log.dd.ILogConfiguration;
import com.tssap.j2ee.model.ext.log.dd.impl.dom.LogConfiguration;
import com.tssap.j2ee.model.ext.web.dd.IWebJ2eeEngine;
import com.tssap.j2ee.model.ext.web.dd.impl.dom.WebJ2eeEngine;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.model.web.dd.impl.dom.WebApp;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.util.file.FileUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class J2EEModelChangeListener
implements ModelChangeListener {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$provider$J2EEModelChangeListener == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$provider$J2EEModelChangeListener = J2EEModelChangeListener.class$("com.sap.ide.eclipse.j2ee.model.ui.provider.J2EEModelChangeListener")) : class$com$sap$ide$eclipse$j2ee$model$ui$provider$J2EEModelChangeListener));
    public static final int EAR_MODEL = 0;
    public static final int EJBJAR_MODEL = 1;
    public static final int WAR_MODEL = 2;
    private int _modelType;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$provider$J2EEModelChangeListener;

    public J2EEModelChangeListener(int modelType) {
        this._modelType = modelType;
    }

    public void modelChanged(ModelChangeEvent changeEvent) {
        String METHOD = "modelChanged(changeEvent)";
        if (TRACER.debug()) {
            TRACER.debug(METHOD, "changeEvent = " + changeEvent);
        }
        try {
            boolean anythingChanged;
            if (this._modelType == 0) {
                return;
            }
            ModelDeltaNode node = changeEvent.getRootDelta();
            boolean bl = anythingChanged = this.checkForChangesInParent(node) || this.checkForChangesInXMLFileOrChildren(node, false);
            if (anythingChanged) {
                this.handleChange(changeEvent.getModel());
            }
        }
        catch (RuntimeException e) {
            TRACER.error("Problems in the delta-handling: " + e.toString(), (Throwable)e);
        }
    }

    private boolean checkForChangesInParent(ModelDeltaNode node) {
        if (node.isTotallyChanged()) {
            Element element = node.getElement();
            boolean isParent = element.getModel().equals(element);
            return isParent;
        }
        return false;
    }

    private boolean checkForChangesInXMLFileOrChildren(ModelDeltaNode node, boolean inCorrectSubTreeOriginal) {
        boolean inCorrectSubTree = inCorrectSubTreeOriginal;
        if (node == null) {
            return false;
        }
        if (!inCorrectSubTree && node.getElement() != null) {
            UniqueName uniqueName = node.getElement().getUniqueName();
            if (this._modelType == 0 && EarModelMetaInfo.isEar((UniqueName)uniqueName)) {
                inCorrectSubTree = true;
            }
            if (this._modelType == 1 && EjbJarModelMetaInfo.isEjbJar((UniqueName)uniqueName)) {
                inCorrectSubTree = true;
            }
            if (this._modelType == 2 && WebAppModelMetaInfo.isWebApp((UniqueName)uniqueName)) {
                inCorrectSubTree = true;
            }
        }
        if (inCorrectSubTree && (node.isChanged() || node.isDeleted() || node.isNew() || node.isTotallyChanged())) {
            return true;
        }
        Enumeration children = node.changedChildren();
        if (children != null) {
            while (children.hasMoreElements()) {
                ModelDeltaNode c = (ModelDeltaNode)children.nextElement();
                boolean result = this.checkForChangesInXMLFileOrChildren(c, inCorrectSubTree);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    private void handleChange(Model model) {
        String METHOD = "handleChange(model)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "model = " + model);
        }
        try {
            if (this._modelType == 0) {
                J2EEModelChangeListener.handleEarChange(model);
            } else if (this._modelType == 1) {
                J2EEModelChangeListener.handleEjbJarChange(model);
            } else if (this._modelType == 2) {
                J2EEModelChangeListener.handleWarChange(model);
            }
        }
        catch (Exception e) {
            TRACER.error(METHOD, "Can not handle change in Model: " + e.toString(), (Throwable)e);
        }
    }

    public static void handleEarChange(Model model) throws Exception {
        String METHOD = "handleEarChange(model)";
        String projectName = model.getUniqueName().getName();
        IEarProject project = J2eeProjectManager.getEarProject((String)projectName);
        if (project != null) {
            IApplication source = J2EEModelChangeListener.getApplicationForProject(project);
            if (TRACER.debug()) {
                TRACER.path(METHOD, "source = " + source);
            }
            if (source != null) {
                boolean ok;
                IEditorPart editorPart;
                boolean anythingChanged;
                ApplicationJ2eeEngine destination;
                Document document;
                IFile file = project.getProject().getFile("META-INF/application-j2ee-engine.xml");
                if (TRACER.debug()) {
                    TRACER.path(METHOD, "file = " + file);
                }
                if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/application-j2ee-engine.dtd")) != null) {
                    destination = new ApplicationJ2eeEngine(document);
                    anythingChanged = SapEarDeltaHandler.handleDeltas((IApplication)source, (IApplicationJ2eeEngine)destination);
                    editorPart = ModelProviderPlugin.findEditorPart(project.getProject(), "com.sap.ide.eclipse.j2ee.model.ui.sapear.sapeareditor");
                    if (anythingChanged) {
                        if (editorPart != null && editorPart.isDirty()) {
                            ok = MessageDialog.openQuestion((Shell)J2EEModelUIPlugin.getShell(), (String)"Accept changes?", (String)("It is necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you just made. This file is currently open in the Editor and has some unsaved changes. You can either accept those changes or discard those changes, before adjusting the file. Do you want to accept the changes?"));
                            if (ok) {
                                editorPart.doSave(null);
                                document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/application-j2ee-engine.dtd");
                                destination = new ApplicationJ2eeEngine(document);
                                SapEarDeltaHandler.handleDeltas((IApplication)source, (IApplicationJ2eeEngine)destination);
                            }
                        } else {
                            J2EEModelChangeListener.startInfoDialogFileChanged(file);
                        }
                        XMLParserHelper.setDomAsContent((Document)document, (IFile)file);
                    }
                    if (editorPart != null && editorPart instanceof IApplicationInterested) {
                        ((IApplicationInterested)editorPart).setApplication(source);
                    }
                }
                file = project.getProject().getFile("META-INF/log-configuration.xml");
                if (TRACER.debug()) {
                    TRACER.path(METHOD, "file = " + file);
                }
                if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/log-configuration.dtd")) != null) {
                    destination = new LogConfiguration(document);
                    anythingChanged = SapLogDeltaHandler.handleDeltas((IApplication)source, (ILogConfiguration)destination);
                    editorPart = ModelProviderPlugin.findEditorPart(project.getProject(), "com.sap.ide.eclipse.j2ee.model.ui.saplog.saplogeditor");
                    if (anythingChanged) {
                        if (editorPart != null && editorPart.isDirty()) {
                            ok = MessageDialog.openQuestion((Shell)J2EEModelUIPlugin.getShell(), (String)"Accept changes?", (String)("It is necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you just made. This file is currently open in the Editor and has some unsaved changes. You can either accept those changes or discard those changes, before adjusting the file. Do you want to accept the changes?"));
                            if (ok) {
                                editorPart.doSave(null);
                                document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/log-configuration.dtd");
                                destination = new LogConfiguration(document);
                                SapLogDeltaHandler.handleDeltas((IApplication)source, (ILogConfiguration)destination);
                            }
                        } else {
                            J2EEModelChangeListener.startInfoDialogFileChanged(file);
                        }
                        XMLParserHelper.setDomAsContent((Document)document, (IFile)file);
                    }
                    if (editorPart != null && editorPart instanceof IApplicationInterested) {
                        ((IApplicationInterested)editorPart).setApplication(source);
                    }
                }
                file = project.getProject().getFile("META-INF/data-source-aliases.xml");
                if (TRACER.debug()) {
                    TRACER.path(METHOD, "file = " + file);
                }
                if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/data-source-aliases.dtd")) != null) {
                    destination = new DataSourceAliases(document);
                    anythingChanged = SapDSAliasesDeltaHandler.handleDeltas((IApplication)source, (IDataSourceAliases)destination);
                    editorPart = ModelProviderPlugin.findEditorPart(project.getProject(), "com.sap.ide.eclipse.j2ee.model.ui.sapdsaliases.sapdsaliaseseditor");
                    if (anythingChanged) {
                        if (editorPart != null && editorPart.isDirty()) {
                            ok = MessageDialog.openQuestion((Shell)J2EEModelUIPlugin.getShell(), (String)"Accept changes?", (String)("It is necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you just made. This file is currently open in the Editor and has some unsaved changes. You can either accept those changes or discard those changes, before adjusting the file. Do you want to accept the changes?"));
                            if (ok) {
                                editorPart.doSave(null);
                                document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/data-source-aliases.dtd");
                                destination = new DataSourceAliases(document);
                                SapDSAliasesDeltaHandler.handleDeltas((IApplication)source, (IDataSourceAliases)destination);
                            }
                        } else {
                            J2EEModelChangeListener.startInfoDialogFileChanged(file);
                        }
                        XMLParserHelper.setDomAsContent((Document)document, (IFile)file);
                    }
                    if (editorPart != null && editorPart instanceof IApplicationInterested) {
                        ((IApplicationInterested)editorPart).setApplication(source);
                    }
                }
            }
        }
    }

    public static void handleEjbJarChange(Model model) throws Exception {
        String METHOD = "handleEjbJarChange(model)";
        String projectName = model.getUniqueName().getName();
        IEjbModule project = J2eeProjectManager.getEjbModule((String)projectName);
        if (project != null) {
            IEjbJar source = J2EEModelChangeListener.getEjbJarForProject((IEjbAssemblyProject)project);
            if (TRACER.debug()) {
                TRACER.path(METHOD, "source = " + source);
            }
            if (source != null) {
                EjbJ2eeEngine destination;
                Document document;
                IFile file = project.getProject().getFile("META-INF/ejb-j2ee-engine.xml");
                if (TRACER.debug()) {
                    TRACER.path(METHOD, "file = " + file);
                }
                if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/ejb-j2ee-engine.dtd")) != null) {
                    destination = new EjbJ2eeEngine(document);
                    boolean anythingChanged = SapEjbJarDescriptionDeltaHandler.handleDeltas((IEjbAssemblyProject)project, (IEjbJar)source, (IEjbJ2eeEngine)destination);
                    IEditorPart editorPart = ModelProviderPlugin.findEditorPart(project.getProject(), "com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.sapejbjardescriptioneditor");
                    if (anythingChanged) {
                        if (editorPart != null && editorPart.isDirty()) {
                            boolean ok = MessageDialog.openQuestion((Shell)J2EEModelUIPlugin.getShell(), (String)"Accept changes?", (String)("It is necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you just made. This file is currently open in the Editor and has some unsaved changes. You can either accept those changes or discard those changes, before adjusting the file. Do you want to accept the changes?"));
                            if (ok) {
                                editorPart.doSave(null);
                                document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/ejb-j2ee-engine.dtd");
                                destination = new EjbJ2eeEngine(document);
                                SapEjbJarDescriptionDeltaHandler.handleDeltas((IEjbAssemblyProject)project, (IEjbJar)source, (IEjbJ2eeEngine)destination);
                            }
                        } else {
                            J2EEModelChangeListener.startInfoDialogFileChanged(file);
                        }
                        XMLParserHelper.setDomAsContent((Document)document, (IFile)file);
                    }
                    if (editorPart != null && editorPart instanceof IEjbJarInterested) {
                        ((IEjbJarInterested)editorPart).setEjbJar(source);
                    }
                }
                file = project.getProject().getFile("META-INF/persistent.xml");
                if (TRACER.debug()) {
                    TRACER.path(METHOD, "file = " + file);
                }
                if (file != null) {
                    document = null;
                    if (file.exists()) {
                        document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/persistent.dtd");
                    }
                    if (document == null) {
                        document = J2EEModelChangeListener.createDefaultDocument();
                    }
                    destination = new PersistentEjbMap(document);
                    IPersistentDeltaHandlerResult result = SapEjbJarPersistentDeltaHandler.handleDeltas((IEjbAssemblyProject)project, (IEjbJar)J2EEModelChangeListener.getEjbJarForProject((IEjbAssemblyProject)project), (IPersistentEjbMap)destination);
                    boolean anythingChanged = result.getAnythingChanged();
                    IEditorPart editorPart = ModelProviderPlugin.findEditorPart(project.getProject(), "com.sap.ide.eclipse.j2ee.model.ui.sapejbjar.sapejbjarpersistenteditor");
                    if (anythingChanged) {
                        if (destination.getEntityBeans() != null && destination.getEntityBeans().getEntityBeans().length != 0) {
                            if (editorPart != null && editorPart.isDirty()) {
                                boolean ok = MessageDialog.openQuestion((Shell)J2EEModelUIPlugin.getShell(), (String)"Accept changes?", (String)("It is necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you just made. This file is currently open in the Editor and has some unsaved changes. You can either accept those changes or discard those changes, before adjusting the file. Do you want to accept the changes?"));
                                if (ok) {
                                    editorPart.doSave(null);
                                    document = XMLParserHelper.getContentAsDom((IFile)file, (String)"META-INF/persistent.dtd");
                                    destination = new PersistentEjbMap(document);
                                    result = SapEjbJarPersistentDeltaHandler.handleDeltas((IEjbAssemblyProject)project, (IEjbJar)J2EEModelChangeListener.getEjbJarForProject((IEjbAssemblyProject)project), (IPersistentEjbMap)destination);
                                }
                            } else {
                                J2EEModelChangeListener.startInfoDialogFileChanged(file);
                            }
                            XMLParserHelper.setDomAsContent((Document)document, (IFile)file);
                        } else if (file.exists()) {
                            if (editorPart != null) {
                                IWorkbenchPage workbenchPage = J2EEModelUIPlugin.getActivePage();
                                if (workbenchPage != null) {
                                    workbenchPage.closeEditor(editorPart, false);
                                }
                                editorPart = null;
                            }
                            file.delete(true, true, null);
                        }
                    }
                    if (editorPart != null && editorPart instanceof IEjbJarInterested) {
                        ((IEjbJarInterested)editorPart).setEjbJar(source);
                    }
                }
            }
        }
    }

    public static void handleWarChange(Model model) throws Exception {
        String METHOD = "handleWarChange(model)";
        String projectName = model.getUniqueName().getName();
        IWebModule project = J2eeProjectManager.getWebModule((String)projectName);
        if (project != null) {
            IWebApp source = J2EEModelChangeListener.getWebAppForProject((IWebAssemblyProject)project);
            if (TRACER.debug()) {
                TRACER.path(METHOD, "source = " + source);
            }
            if (source != null) {
                Document document;
                IFile file = project.getProject().getFile("WEB-INF/web-j2ee-engine.xml");
                if (TRACER.debug()) {
                    TRACER.path(METHOD, "file = " + file);
                }
                if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom((IFile)file, (String)"WEB-INF/web-j2ee-engine.dtd")) != null) {
                    WebJ2eeEngine destination = new WebJ2eeEngine(document);
                    boolean anythingChanged = SapWarDeltaHandler.handleDeltas((IWebApp)source, (IWebJ2eeEngine)destination);
                    IEditorPart editorPart = ModelProviderPlugin.findEditorPart(project.getProject(), "com.sap.ide.eclipse.j2ee.model.ui.sapwar.sapwareditor");
                    if (anythingChanged) {
                        if (editorPart != null && editorPart.isDirty()) {
                            boolean ok = MessageDialog.openQuestion((Shell)J2EEModelUIPlugin.getShell(), (String)"Accept changes?", (String)("It is necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you just made. This file is currently open in the Editor and has some unsaved changes. You can either accept those changes or discard those changes, before adjusting the file. Do you want to accept the changes?"));
                            if (ok) {
                                editorPart.doSave(null);
                                document = XMLParserHelper.getContentAsDom((IFile)file, (String)"WEB-INF/web-j2ee-engine.dtd");
                                destination = new WebJ2eeEngine(document);
                                SapWarDeltaHandler.handleDeltas((IWebApp)source, (IWebJ2eeEngine)destination);
                            }
                        } else {
                            J2EEModelChangeListener.startInfoDialogFileChanged(file);
                        }
                        XMLParserHelper.setDomAsContent((Document)document, (IFile)file);
                    }
                    if (editorPart != null && editorPart instanceof IWebAppInterested) {
                        ((IWebAppInterested)editorPart).setWebApp(source);
                    }
                }
            }
        }
    }

    public static IEjbJar getEjbJarForProject(IEjbAssemblyProject project) throws SAXException, ParserConfigurationException, CoreException, IOException {
        if (project == null) {
            return null;
        }
        IFile file = project.getDescriptorLocation();
        if (file == null || !file.exists()) {
            return null;
        }
        DocumentBuilder documentBuilder = XMLParserHelper.createNewDocumentBuilder();
        documentBuilder.setEntityResolver((EntityResolver)new AdditionalDTDEntityResolver((Plugin)UIPlugin.getDefault(), "definitions", null));
        Document document = documentBuilder.parse(file.getContents());
        EjbJar source = new EjbJar(document);
        return source;
    }

    public static IApplication getApplicationForProject(IEarProject project) throws SAXException, ParserConfigurationException, CoreException, IOException {
        if (project == null) {
            return null;
        }
        IFile file = project.getDescriptorLocation();
        if (file == null || !file.exists()) {
            return null;
        }
        DocumentBuilder documentBuilder = XMLParserHelper.createNewDocumentBuilder();
        documentBuilder.setEntityResolver((EntityResolver)new AdditionalDTDEntityResolver((Plugin)UIPlugin.getDefault(), "definitions", null));
        Document document = documentBuilder.parse(file.getContents());
        Application source = new Application(document);
        return source;
    }

    public static IWebApp getWebAppForProject(IWebAssemblyProject project) throws SAXException, ParserConfigurationException, CoreException, IOException {
        if (project == null) {
            return null;
        }
        IFile file = project.getDescriptorLocation();
        if (file == null || !file.exists()) {
            return null;
        }
        DocumentBuilder documentBuilder = XMLParserHelper.createNewDocumentBuilder();
        documentBuilder.setEntityResolver((EntityResolver)new AdditionalDTDEntityResolver((Plugin)UIPlugin.getDefault(), "definitions", null));
        Document document = documentBuilder.parse(file.getContents());
        WebApp source = new WebApp(document);
        return source;
    }

    public static Document createDefaultDocument() throws Exception {
        URL templateDirectory = FileUtil.getURLForRelativePath((Plugin)ModelPlugin.getDefault(), (String)"templates/");
        URL template = new URL(templateDirectory, "META-INF/persistent.xml");
        InputStream in = template.openStream();
        DocumentBuilder documentBuilder = XMLParserHelper.createNewDocumentBuilder();
        AdditionalDTDEntityResolver entityResolver = new AdditionalDTDEntityResolver((Plugin)ModelPlugin.getDefault(), "templates/", "META-INF/persistent.dtd");
        documentBuilder.setEntityResolver((EntityResolver)entityResolver);
        Document document = documentBuilder.parse(in);
        return document;
    }

    public static void startInfoDialogFileChanged(IFile file) {
        if (file.isReadOnly()) {
            MessageDialog.openWarning((Shell)J2EEModelUIPlugin.getShell(), (String)"Can not adjust file", (String)("It is necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you just made. This file is currently read-only. Please make it readable and open the file to perform an automatic adjustment."));
            UIPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)UIPlugin.getShell());
        }
    }

    public static boolean showDialogAdjustFile(IFile file) {
        if (file.isReadOnly()) {
            MessageDialog.openWarning((Shell)J2EEModelUIPlugin.getShell(), (String)"Can not adjust file", (String)("It is necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you made. This file is currently read-only. Please make it readable and open the file again to perform an automatic adjustment."));
            UIPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)UIPlugin.getShell());
        } else {
            MessageDialog.openInformation((Shell)J2EEModelUIPlugin.getShell(), (String)"File adjusted", (String)("It was necessary to adjust the file '" + file.getName() + "' to keep it consistent after the changes you made. Please save save the editor to overtake the changes (recommended)."));
        }
        return !file.isReadOnly();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface IWebAppInterested {
        public void setWebApp(IWebApp var1);
    }

    public static interface IEjbJarInterested {
        public void setEjbJar(IEjbJar var1);
    }

    public static interface IApplicationInterested {
        public void setApplication(IApplication var1);
    }
}

