/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.portal.contextroot;

import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.tssap.dii.dtri.DtriUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.MalformedURLException;
import javax.naming.CompoundName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class CRServerStatus {
    public static final int NO_ERROR = 0;
    public static final int ERROR_NO_NAMESERVER = 1;
    public static final int ERROR_NO_PREFIXES = 2;
    public static final int ERROR_NO_ACTIVITY = 3;
    public static final String CONTEXT_ROOT_CATEGORY = "SAP_ApplicationContextRoot";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$portal$contextroot$CRServerStatus == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$portal$contextroot$CRServerStatus = CRServerStatus.class$("com.sap.ide.eclipse.j2ee.model.ui.portal.contextroot.CRServerStatus")) : class$com$sap$ide$eclipse$j2ee$model$ui$portal$contextroot$CRServerStatus));
    private int errorCode = 0;
    private boolean online = true;
    private NameAllocator allocator = null;
    private String serverName = null;
    private String[] prefixe = new String[0];
    private IVfsFile vfsfile = null;
    private IVfsActivity vfsActivity = null;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$portal$contextroot$CRServerStatus;

    public CRServerStatus(IFile file) {
        this.getNameServer(file);
        this.initPrefixe();
        this.getVfsFileAndActivity(file);
    }

    private void getNameServer(IFile file) {
        try {
            this.allocator = NameServerUtil.getNameAllocator((IProject)file.getProject());
            if (this.allocator != null) {
                this.serverName = NameServerUtil.getURL((NameAllocator)this.allocator);
            }
        }
        catch (MalformedURLException e) {
            tracer.error("", (Throwable)e);
        }
        catch (CommunicationFailureException e) {
            tracer.error("", (Throwable)e);
        }
        if (this.allocator == null || this.serverName == null) {
            this.setStatus(false, 1);
        }
    }

    private void initPrefixe() {
        if (!this.isOnline()) {
            return;
        }
        try {
            CompoundName[] n = this.allocator.listAllowedPrefixes(CONTEXT_ROOT_CATEGORY, true);
            if (n != null) {
                this.prefixe = new String[n.length];
                int i = 0;
                while (i < n.length) {
                    this.prefixe[i] = n[i].toString();
                    ++i;
                }
            }
        }
        catch (CommunicationFailureException e) {
            tracer.error("", (Throwable)e);
        }
        if (this.prefixe.length == 0) {
            this.setStatus(false, 2);
        }
    }

    private void getVfsFileAndActivity(IFile file) {
        if (!this.isOnline()) {
            return;
        }
        IVfsFolderItem folderItem = DtriUtil.getVfsFolderItem((Object)file);
        this.vfsfile = null;
        this.vfsActivity = null;
        if (folderItem instanceof IVfsFile) {
            this.vfsfile = (IVfsFile)folderItem;
            IVfsActivity[] tmpActivity = this.vfsfile.getOpenActivities();
            if (tmpActivity != null && tmpActivity.length > 0) {
                this.vfsActivity = tmpActivity[0];
            }
        }
        if (this.vfsActivity == null) {
            this.setStatus(false, 3);
        }
    }

    private void setStatus(boolean isOnline, int errorCode) {
        this.online = isOnline;
        this.errorCode = errorCode;
    }

    public boolean isOnline() {
        return this.online;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public NameAllocator getAllocator() {
        return this.allocator;
    }

    public String getServerName() {
        return this.serverName;
    }

    public IVfsActivity getVfsActivity() {
        return this.vfsActivity;
    }

    public IVfsFile getVfsfile() {
        return this.vfsfile;
    }

    public String[] getPrefixe() {
        return this.prefixe;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

