/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.portal.contextroot;

import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.eclipse.j2ee.model.ui.portal.contextroot.CRDialog;
import com.sap.ide.eclipse.j2ee.model.ui.portal.contextroot.CRServerStatus;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.ForeignContextException;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.lcr.namealloc.api.NotOwnerException;
import com.sap.lcr.namealloc.api.ReservedBeforeException;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CRDialogHandler {
    private static final String TITLE_ONLY_TESTAPP = "Context-roots only for test application";
    private static final String TITLE_NAME_SERVER = "Nameserver";
    private static final String MSG_GENERAL = "  Therefore, you can only insert context-roots for test applications.";
    private static final String MSG_NO_PREFIXES = "No prefixes are defined on the name server of this Development Component project.  Therefore, you can only insert context-roots for test applications.";
    private static final String MSG_NO_NAMESERVER = "No connection can be established to the name server of this Development Component project.  Therefore, you can only insert context-roots for test applications.";
    private static final String MSG_NO_ACTIVITY = "File <application.xml> is not in a valid activity.  Therefore, you can only insert context-roots for test applications.";
    private static final String MSG_TECHNICAL_ERROR = "A technical error occured during name reservation. Please, try again later.";
    private static final String MSG_INVALID_SYNTAX = "Invalid context-root syntax!";
    private static final String MSG_ALREADY_RESERVED = "Name already reserved: Use name nevertheless for test purposes?";
    private static final String MSG_SUCCESFULLY_RESERVED = "Name for context-root reserved succesfully on name server.";
    private static final String INVALID_CONTEXT_ROOT_CHARS = "\\!%&()=? '";
    private static final String CR_SEPARATOR = "/";
    public static final int RET_CLOSE_DIALOG_OK = 0;
    public static final int RET_CLOSE_DIALOG_CANCEL = 1;
    public static final int RET_DONT_CLOSE_DIALOG = 2;
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$portal$contextroot$CRDialogHandler == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$portal$contextroot$CRDialogHandler = CRDialogHandler.class$("com.sap.ide.eclipse.j2ee.model.ui.portal.contextroot.CRDialogHandler")) : class$com$sap$ide$eclipse$j2ee$model$ui$portal$contextroot$CRDialogHandler));
    private String oldCRPref = null;
    private String oldCRName = null;
    private String oldCR = "";
    private String newContextRoot = null;
    private CRServerStatus myServer;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$portal$contextroot$CRDialogHandler;

    public CRDialogHandler(IFile applicationXml, String oldContextRoot) {
        this.myServer = new CRServerStatus(applicationXml);
        if (!this.myServer.isOnline()) {
            String info = null;
            switch (this.myServer.getErrorCode()) {
                case 1: {
                    info = MSG_NO_NAMESERVER;
                    break;
                }
                case 2: {
                    info = MSG_NO_PREFIXES;
                    break;
                }
                case 3: {
                    info = MSG_NO_ACTIVITY;
                    break;
                }
            }
            if (info != null) {
                MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)TITLE_ONLY_TESTAPP, (String)info);
            }
        }
        this.splitOldContextRoot(oldContextRoot);
    }

    public int handleInputData(String prefix, String name) {
        if (!this.checkSyntax(name)) {
            return this.handleNameSyntax();
        }
        if (!this.isOnline()) {
            this.setNewContextRoot(name);
            return 0;
        }
        String sep = name.charAt(0) == '/' ? "" : CR_SEPARATOR;
        String tmpContextRoot = prefix + sep + name;
        if (tmpContextRoot.equals(this.oldCR)) {
            return 1;
        }
        int ret = this.alreadyReserved(tmpContextRoot) ? this.revertPropState(tmpContextRoot) : this.reserveName(tmpContextRoot);
        if (ret == 0) {
            this.removePropFromDTR();
            this.setNewContextRoot(tmpContextRoot);
        }
        return ret;
    }

    private int reserveName(String contextRoot) {
        try {
            NameAllocator allocator = this.myServer.getAllocator();
            String user = allocator.getMyConnectUser();
            AllocationState state = allocator.reservePreliminary("SAP_ApplicationContextRoot", contextRoot, user, "reserveration context-root", null, null, null);
            if (state != null) {
                boolean isOK = this.addPropertyToVfs(contextRoot, state.getReservationKey());
                if (isOK) {
                    return this.handleReservedSuccesfully();
                }
                try {
                    allocator.revert("SAP_ApplicationContextRoot", contextRoot, state.getReservationKey());
                }
                catch (NameNotFoundException e) {
                    tracer.error("", (Throwable)e);
                }
                return this.handleTechnicalProblem(new Exception("add vfs-property failed"));
            }
            return this.handleTechnicalProblem(new Exception("allocation state was null"));
        }
        catch (NotOwnerException e) {
            return this.handleReserved((Exception)((Object)e));
        }
        catch (ForeignContextException e) {
            return this.handleTechnicalProblem((Exception)((Object)e));
        }
        catch (ReservedBeforeException e) {
            return this.handleReserved((Exception)((Object)e));
        }
        catch (NameSyntaxViolation e) {
            tracer.log(4, "", (Throwable)e);
            return this.handleNameSyntax();
        }
        catch (CommunicationFailureException e) {
            return this.handleTechnicalProblem((Exception)((Object)e));
        }
    }

    private boolean addPropertyToVfs(String contextRoot, String reservationKey) {
        try {
            NameServerUtil.NameReservationData data = new NameServerUtil.NameReservationData("SAP_ApplicationContextRoot", contextRoot, reservationKey, this.myServer.getServerName(), null);
            return NameServerUtil.reserveMultiNameInDTR((IVfsFile)this.myServer.getVfsfile(), (NameServerUtil.NameReservationData)data, (IVfsActivity)this.myServer.getVfsActivity(), (Shell)UIPlugin.getShell());
        }
        catch (VfsException e) {
            tracer.error("", (Throwable)e);
        }
        catch (Exception e) {
            tracer.error("", (Throwable)e);
        }
        return false;
    }

    private boolean checkSyntax(String contextRoot) {
        boolean isValid = true;
        if (contextRoot == null || contextRoot.length() == 0) {
            isValid = false;
        } else if (StringUtils.containsChar((String)contextRoot, (String)INVALID_CONTEXT_ROOT_CHARS)) {
            isValid = false;
        } else if (contextRoot.indexOf("//") >= 0) {
            isValid = false;
        } else if (contextRoot.endsWith(CR_SEPARATOR)) {
            isValid = false;
        }
        return isValid;
    }

    public String getNewContextRoot() {
        CRDialog crDialog = new CRDialog(UIPlugin.getShell(), this);
        crDialog.open();
        if (crDialog.getReturnCode() == 0) {
            return this.newContextRoot;
        }
        return null;
    }

    public String[] getPrefixe() {
        return this.myServer.getPrefixe();
    }

    public boolean isOnline() {
        return this.myServer.isOnline();
    }

    private void setNewContextRoot(String contextRoot) {
        this.newContextRoot = contextRoot;
    }

    private int handleNameSyntax() {
        MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)TITLE_NAME_SERVER, (String)MSG_INVALID_SYNTAX);
        return 2;
    }

    private int handleTechnicalProblem(Exception e) {
        tracer.error("handleTechnicalProblem", (Throwable)e);
        MessageDialog.openError((Shell)UIPlugin.getShell(), (String)TITLE_NAME_SERVER, (String)MSG_TECHNICAL_ERROR);
        return 1;
    }

    private int handleReserved(Exception e) {
        tracer.info("handleReserved", e.getMessage());
        boolean ret = MessageDialog.openQuestion((Shell)UIPlugin.getShell(), (String)TITLE_NAME_SERVER, (String)MSG_ALREADY_RESERVED);
        if (ret) {
            return 0;
        }
        return 2;
    }

    private int handleReservedSuccesfully() {
        MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)TITLE_NAME_SERVER, (String)MSG_SUCCESFULLY_RESERVED);
        return 0;
    }

    public String getOldCRName() {
        return this.oldCRName;
    }

    public String getOldCRPref() {
        return this.oldCRPref;
    }

    private void splitOldContextRoot(String cr) {
        if (cr == null) {
            return;
        }
        this.oldCR = cr;
        if (!this.isOnline()) {
            this.oldCRPref = null;
            this.oldCRName = cr;
        } else {
            int s;
            if (cr.startsWith(CR_SEPARATOR)) {
                cr = cr.substring(1);
            }
            if ((s = cr.indexOf(CR_SEPARATOR)) <= 0) {
                return;
            }
            String pref = cr.substring(0, s);
            boolean validPref = false;
            String[] prefixe = this.myServer.getPrefixe();
            int i = 0;
            while (i < prefixe.length) {
                if (prefixe[i].equals(pref)) {
                    validPref = true;
                    break;
                }
                ++i;
            }
            if (!validPref) {
                return;
            }
            String name = cr.substring(s + 1);
            this.oldCRPref = pref;
            this.oldCRName = name;
        }
    }

    private void removePropFromDTR() {
        try {
            NameServerUtil.NameReservationData[] data = NameServerUtil.getMultiNameFromDTR((IVfsFile)this.myServer.getVfsfile());
            if (data != null) {
                int i = 0;
                while (i < data.length) {
                    if (this.oldCR.equals(data[i].getName())) {
                        NameServerUtil.removeMultiNameFromDTR((IVfsFile)this.myServer.getVfsfile(), (String)this.oldCR, (String)"SAP_ApplicationContextRoot", (IVfsActivity)this.myServer.getVfsActivity(), (Shell)UIPlugin.getShell());
                        return;
                    }
                    ++i;
                }
            }
        }
        catch (VfsException e) {
            tracer.error("", (Throwable)e);
        }
        catch (Exception e) {
            tracer.error("", (Throwable)e);
        }
    }

    private boolean alreadyReserved(String contextRoot) {
        try {
            NameServerUtil.NameReservationData[] data = NameServerUtil.getMultiNameFromDTR((IVfsFile)this.myServer.getVfsfile());
            if (data != null) {
                int i = 0;
                while (i < data.length) {
                    if (contextRoot.equals(data[i].getName())) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (VfsException e) {
            tracer.error("", (Throwable)e);
        }
        catch (Exception e) {
            tracer.error("", (Throwable)e);
        }
        return false;
    }

    private int revertPropState(String contextRoot) {
        try {
            boolean isOK;
            AllocationState state = this.myServer.getAllocator().getAllocationState("SAP_ApplicationContextRoot", contextRoot);
            if (state != null && (isOK = this.addPropertyToVfs(contextRoot, state.getReservationKey()))) {
                return 0;
            }
            return this.handleTechnicalProblem(new Exception("allocation state was null or add prop failed"));
        }
        catch (CommunicationFailureException e) {
            return this.handleTechnicalProblem((Exception)((Object)e));
        }
        catch (NameNotFoundException e) {
            return this.handleTechnicalProblem((Exception)((Object)e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

